/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import java.util.Comparator;

public class SortedSymbolIndexRowCursorFactory
implements RowCursorFactory {
    private static final ThreadLocal<SortHelper> TL_SORT_HELPER = new ThreadLocal<SortHelper>(() -> new SortHelper());
    private final int columnIndex;
    private final boolean columnOrderDirectionAsc;
    private final ListBasedSymbolIndexRowCursor cursor = new ListBasedSymbolIndexRowCursor();
    private final int indexDirection;
    private final IntList symbolKeys = new IntList();
    private int symbolKeyLimit;

    public SortedSymbolIndexRowCursorFactory(int columnIndex, boolean columnOrderDirectionAsc, int indexDirection) {
        this.columnIndex = columnIndex;
        this.indexDirection = indexDirection;
        this.columnOrderDirectionAsc = columnOrderDirectionAsc;
    }

    @Override
    public RowCursor getCursor(PageFrame pageFrame, PageFrameMemory pageFrameMemory) {
        this.cursor.of(pageFrame);
        return this.cursor;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public void prepareCursor(PageFrameCursor pageFrameCursor) {
        this.symbolKeys.clear();
        StaticSymbolTable staticSymbolTable = pageFrameCursor.getSymbolTable(this.columnIndex);
        int count = staticSymbolTable.getSymbolCount();
        SortHelper sortHelper = TL_SORT_HELPER.get();
        ObjList<SymbolTableEntry> entries = sortHelper.getEntries();
        this.symbolKeyLimit = count + 1;
        sortHelper.fillEntries(this.symbolKeyLimit);
        for (int i = 0; i < count; ++i) {
            SymbolTableEntry e = entries.getQuick(i);
            e.key = TableUtils.toIndexKey(i);
            e.value = Chars.toString(staticSymbolTable.valueOf(i));
        }
        SymbolTableEntry e = entries.getQuick(count);
        e.key = TableUtils.toIndexKey(Integer.MIN_VALUE);
        e.value = null;
        if (this.columnOrderDirectionAsc) {
            sortHelper.sort(this.symbolKeyLimit, sortHelper.ascComparator);
        } else {
            sortHelper.sort(this.symbolKeyLimit, sortHelper.dscComparator);
        }
        for (int i = 0; i < this.symbolKeyLimit; ++i) {
            this.symbolKeys.add(entries.getQuick((int)i).key);
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index ").type(BitmapIndexReader.nameOf(this.indexDirection)).type(" scan").meta("on").putColumnName(this.columnIndex);
        sink.attr("symbolOrder").val(this.columnOrderDirectionAsc ? "asc" : "desc");
    }

    private class ListBasedSymbolIndexRowCursor
    implements RowCursor {
        private RowCursor current;
        private int index;
        private PageFrame pageFrame;

        private ListBasedSymbolIndexRowCursor() {
        }

        @Override
        public boolean hasNext() {
            return this.current.hasNext() || this.fetchNext();
        }

        @Override
        public long next() {
            return this.current.next();
        }

        private boolean fetchNext() {
            while (this.index < SortedSymbolIndexRowCursorFactory.this.symbolKeyLimit) {
                this.current = this.pageFrame.getBitmapIndexReader(SortedSymbolIndexRowCursorFactory.this.columnIndex, SortedSymbolIndexRowCursorFactory.this.indexDirection).getCursor(true, SortedSymbolIndexRowCursorFactory.this.symbolKeys.getQuick(this.index++), this.pageFrame.getPartitionLo(), this.pageFrame.getPartitionHi() - 1L);
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }

        private void of(PageFrame pageFrame) {
            this.pageFrame = pageFrame;
            this.index = 0;
            this.current = EmptyRowCursor.INSTANCE;
        }
    }

    private static class SortHelper {
        private final Comparator<SymbolTableEntry> ascComparator = this::compareAsc;
        private final Comparator<SymbolTableEntry> dscComparator = this::compareDesc;
        private final ObjList<SymbolTableEntry> entries = new ObjList();

        private SortHelper() {
        }

        public void fillEntries(int max) {
            int size = this.entries.size();
            if (max > this.entries.size()) {
                while (size++ < max) {
                    this.entries.add(new SymbolTableEntry());
                }
            }
        }

        public ObjList<SymbolTableEntry> getEntries() {
            return this.entries;
        }

        public void sort(int max, Comparator<SymbolTableEntry> comparator) {
            this.entries.sort(0, max, comparator);
        }

        private int compareAsc(SymbolTableEntry e1, SymbolTableEntry e2) {
            return e1.value == null && e2.value == null ? 0 : (e1.value == null ? -1 : (e2.value == null ? 1 : e1.value.compareTo(e2.value)));
        }

        private int compareDesc(SymbolTableEntry e1, SymbolTableEntry e2) {
            return e1.value == null && e2.value == null ? 0 : (e1.value == null ? 1 : (e2.value == null ? -1 : e2.value.compareTo(e1.value)));
        }
    }

    private static class SymbolTableEntry {
        private int key;
        private String value;

        private SymbolTableEntry() {
        }
    }
}

