/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.filewatch;

import io.questdb.FileEventCallback;
import io.questdb.cairo.CairoException;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.filewatch.FileWatcher;
import io.questdb.std.filewatch.WindowsAccessor;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public class FileWatcherWindows
extends FileWatcher {
    private final WindowsAccessor accessor;
    private final Path dirPath = new Path();
    private final DirectUtf8Sink fileName = new DirectUtf8Sink(64L);
    private long pWatch;

    public FileWatcherWindows(WindowsAccessor accessor, @NotNull Utf8Sequence filePath, @NotNull FileEventCallback callback) {
        super(callback);
        this.accessor = accessor;
        this.dirPath.of(filePath).parent();
        this.fileName.put(Paths.get(filePath.toString(), new String[0]).getFileName().toString());
        this.pWatch = accessor.openDirectory(this.dirPath.$());
        if (this.pWatch == -1L) {
            Misc.free(this.dirPath);
            Misc.free(this.fileName);
            throw CairoException.critical(Os.errno()).put("could not create configuration watch [dirPath=").put(this.dirPath).put(']');
        }
    }

    @Override
    protected void _close() {
        if (this.pWatch != 0L) {
            this.accessor.closeDirectory(this.pWatch);
            this.pWatch = 0L;
        }
        Misc.free(this.dirPath);
        Misc.free(this.fileName);
    }

    @Override
    protected void releaseWait() {
        this.accessor.stopWatch(this.pWatch);
    }

    @Override
    protected void waitForChange() {
        if (this.accessor.readDirectoryChanges(this.pWatch)) {
            this.callback.onFileEvent();
        }
    }
}

