/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.str.CloneableMutable;
import io.questdb.std.str.MutableUtf16Sink;
import io.questdb.std.str.Utf16Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringSink
implements MutableUtf16Sink,
CharSequence,
CloneableMutable,
Utf16Sink {
    private char[] buffer;
    private int pos;

    public StringSink() {
        this(16);
    }

    public StringSink(int initialCapacity) {
        this.buffer = new char[initialCapacity];
        this.pos = 0;
    }

    @Override
    public char charAt(int index) {
        return this.buffer[index];
    }

    public void clear(int pos) {
        this.pos = pos;
    }

    @Override
    public void clear() {
        this.clear(0);
    }

    @Override
    public <T> T copy() {
        return (T)new String(this.buffer, 0, this.pos);
    }

    public boolean equals(Object obj) {
        CharSequence cs;
        int len;
        if (obj instanceof CharSequence && (len = (cs = (CharSequence)obj).length()) == this.pos) {
            for (int i = 0; i < len; ++i) {
                if (this.buffer[i] == cs.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Chars.hashCode(this.buffer, 0, this.pos);
    }

    public int indexOf(@NotNull String s) {
        return Chars.indexOf((CharSequence)this, 0, this.pos, s);
    }

    public int indexOf(@NotNull String s, int fromIndex) {
        return Chars.indexOf((CharSequence)this, Math.min(fromIndex, this.pos), this.pos, s);
    }

    public int lastIndexOf(@NotNull String s) {
        return Chars.lastIndexOf((CharSequence)this, 0, this.pos, s);
    }

    public int lastIndexOf(@NotNull String s, int fromIndex) {
        return Chars.lastIndexOf((CharSequence)this, 0, Math.min(fromIndex + s.length(), this.pos), s);
    }

    @Override
    public int length() {
        return this.pos;
    }

    @Override
    public Utf16Sink put(@Nullable CharSequence cs) {
        if (cs != null) {
            int len = cs.length();
            this.checkCapacity(len);
            for (int i = 0; i < len; ++i) {
                this.buffer[this.pos + i] = cs.charAt(i);
            }
            this.pos += len;
        }
        return this;
    }

    @Override
    public Utf16Sink put(@NotNull CharSequence cs, int lo, int hi) {
        int len = hi - lo;
        this.checkCapacity(len);
        for (int i = lo; i < hi; ++i) {
            this.buffer[this.pos + i - lo] = cs.charAt(i);
        }
        this.pos += len;
        return this;
    }

    @Override
    public Utf16Sink put(char c) {
        this.checkCapacity(1);
        this.buffer[this.pos++] = c;
        return this;
    }

    @Override
    public Utf16Sink put(char @NotNull [] chars, int start, int len) {
        this.checkCapacity(len);
        System.arraycopy(chars, start, this.buffer, this.pos, len);
        this.pos += len;
        return this;
    }

    public Utf16Sink put(char c, int n) {
        this.checkCapacity(n);
        for (int i = 0; i < n; ++i) {
            this.buffer[this.pos + i] = c;
        }
        this.pos += n;
        return this;
    }

    public void replace(char from, char to) {
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] != from) continue;
            this.buffer[i] = to;
        }
    }

    public void setCharAt(int index, char ch) {
        this.buffer[index] = ch;
    }

    @Override
    @NotNull
    public CharSequence subSequence(int lo, int hi) {
        return new String(this.buffer, lo, hi - lo);
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.buffer, 0, this.pos);
    }

    public void trimTo(int pos) {
        this.clear(pos);
    }

    private void checkCapacity(int extra) {
        int len = this.pos + extra;
        if (this.buffer.length >= len) {
            return;
        }
        len = Math.max(this.pos * 2, len);
        char[] n = new char[len];
        System.arraycopy(this.buffer, 0, n, 0, this.pos);
        this.buffer = n;
    }
}

