/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Unsafe;
import io.questdb.std.bytes.ByteSequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;

public interface Utf8Sequence
extends ByteSequence {
    @NotNull
    public CharSequence asAsciiCharSequence();

    @Override
    public byte byteAt(int var1);

    default public int intAt(int offset) {
        int result = 0;
        result |= this.byteAt(offset) & 0xFF;
        result |= (this.byteAt(offset + 1) & 0xFF) << 8;
        result |= (this.byteAt(offset + 2) & 0xFF) << 16;
        return result |= (this.byteAt(offset + 3) & 0xFF) << 24;
    }

    default public boolean isAscii() {
        return false;
    }

    default public boolean isStable() {
        return false;
    }

    default public long longAt(int offset) {
        long result = 0L;
        result |= (long)this.byteAt(offset) & 0xFFL;
        result |= ((long)this.byteAt(offset + 1) & 0xFFL) << 8;
        result |= ((long)this.byteAt(offset + 2) & 0xFFL) << 16;
        result |= ((long)this.byteAt(offset + 3) & 0xFFL) << 24;
        result |= ((long)this.byteAt(offset + 4) & 0xFFL) << 32;
        result |= ((long)this.byteAt(offset + 5) & 0xFFL) << 40;
        result |= ((long)this.byteAt(offset + 6) & 0xFFL) << 48;
        return result |= ((long)this.byteAt(offset + 7) & 0xFFL) << 56;
    }

    default public long ptr() {
        return -1L;
    }

    default public short shortAt(int offset) {
        int result = 0;
        result |= this.byteAt(offset) & 0xFF;
        return (short)(result |= (this.byteAt(offset + 1) & 0xFF) << 8);
    }

    @Override
    public int size();

    default public long tailPadding() {
        return 0L;
    }

    default public void writeTo(long addr, int lo, int hi) {
        int i = lo;
        int n = hi - 7;
        while (i < n) {
            Unsafe.getUnsafe().putLong(addr, this.longAt(i));
            i += 8;
            addr += 8L;
        }
        while (i < hi) {
            Unsafe.getUnsafe().putByte(addr, this.byteAt(i));
            ++i;
            ++addr;
        }
    }

    default public long zeroPaddedSixPrefix() {
        return Utf8s.zeroPaddedSixPrefix(this);
    }
}

