/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.statik;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalSctpChunk;
import org.pcap4j.packet.SctpPacket;
import org.pcap4j.packet.UnknownSctpChunk;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.SctpChunkType;

public final class StaticSctpChunkFactory
implements PacketFactory<SctpPacket.SctpChunk, SctpChunkType> {
    private static final StaticSctpChunkFactory INSTANCE = new StaticSctpChunkFactory();
    private final Map<SctpChunkType, Instantiater> instantiaters = new HashMap<SctpChunkType, Instantiater>();

    private StaticSctpChunkFactory() {
    }

    public static StaticSctpChunkFactory getInstance() {
        return INSTANCE;
    }

    public SctpPacket.SctpChunk newInstance(byte[] rawData, int offset, int length, SctpChunkType number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData, offset, length);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalSctpChunk.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        return this.newInstance(rawData, offset, length);
    }

    public SctpPacket.SctpChunk newInstance(byte[] rawData, int offset, int length) {
        try {
            return UnknownSctpChunk.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalSctpChunk.newInstance((byte[])rawData, (int)offset, (int)length);
        }
    }

    public Class<? extends SctpPacket.SctpChunk> getTargetClass(SctpChunkType number) {
        if (number == null) {
            throw new NullPointerException("number must not be null.");
        }
        Instantiater instantiater = this.instantiaters.get(number);
        return instantiater != null ? instantiater.getTargetClass() : this.getTargetClass();
    }

    public Class<? extends SctpPacket.SctpChunk> getTargetClass() {
        return UnknownSctpChunk.class;
    }

    private static interface Instantiater {
        public SctpPacket.SctpChunk newInstance(byte[] var1, int var2, int var3) throws IllegalRawDataException;

        public Class<? extends SctpPacket.SctpChunk> getTargetClass();
    }
}

