/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate.realtime.window;

import java.util.HashMap;
import java.util.List;
import org.apache.hertzbeat.alert.AlerterWorkerPool;
import org.apache.hertzbeat.alert.calculate.JexlExprCalculator;
import org.apache.hertzbeat.alert.calculate.realtime.window.MatchingLogEvent;
import org.apache.hertzbeat.alert.calculate.realtime.window.WindowAggregator;
import org.apache.hertzbeat.alert.service.AlertDefineService;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogWorker {
    private static final Logger log = LoggerFactory.getLogger(LogWorker.class);
    private static final String LOG_PREFIX = "log";
    private final AlertDefineService alertDefineService;
    private final JexlExprCalculator jexlExprCalculator;
    private final WindowAggregator windowAggregator;
    private final AlerterWorkerPool workerPool;

    @Autowired
    public LogWorker(AlertDefineService alertDefineService, JexlExprCalculator jexlExprCalculator, WindowAggregator windowAggregator, AlerterWorkerPool workerPool) {
        this.alertDefineService = alertDefineService;
        this.jexlExprCalculator = jexlExprCalculator;
        this.windowAggregator = windowAggregator;
        this.workerPool = workerPool;
    }

    public void reduceAndSendLogTask(LogEntry logEntry) {
        this.workerPool.executeLogJob(this.reduceLogTask(logEntry));
    }

    public Runnable reduceLogTask(LogEntry logEntry) {
        return () -> {
            try {
                this.processLogEntry(logEntry);
            }
            catch (Exception e) {
                log.error("Error processing log entry in worker: {}", (Object)e.getMessage(), (Object)e);
            }
        };
    }

    private void processLogEntry(LogEntry logEntry) {
        List<AlertDefine> alertDefines = this.alertDefineService.getLogRealTimeAlertDefines();
        HashMap<String, Object> context = new HashMap<String, Object>(8);
        context.put(LOG_PREFIX, logEntry);
        for (AlertDefine define : alertDefines) {
            if (define.getExpr() == null || define.getExpr().trim().isEmpty()) continue;
            try {
                boolean match = this.jexlExprCalculator.execAlertExpression(context, define.getExpr(), false);
                if (!match) continue;
                MatchingLogEvent event = this.createMatchingLogEvent(logEntry, define);
                this.windowAggregator.addMatchingLog(event);
            }
            catch (Exception e) {
                log.warn("Error evaluating expression for alert define {}: {}", (Object)define.getName(), (Object)e.getMessage());
            }
        }
    }

    private MatchingLogEvent createMatchingLogEvent(LogEntry logEntry, AlertDefine define) {
        long eventTimestamp = this.extractEventTimestamp(logEntry);
        return MatchingLogEvent.builder().logEntry(logEntry).alertDefine(define).eventTimestamp(eventTimestamp).workerTimestamp(System.currentTimeMillis()).build();
    }

    private long extractEventTimestamp(LogEntry logEntry) {
        if (logEntry.getTimeUnixNano() != null && logEntry.getTimeUnixNano() != 0L) {
            return logEntry.getTimeUnixNano() / 1000000L;
        }
        if (logEntry.getObservedTimeUnixNano() != null && logEntry.getObservedTimeUnixNano() != 0L) {
            return logEntry.getObservedTimeUnixNano() / 1000000L;
        }
        return System.currentTimeMillis();
    }
}

