/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.reduce;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hertzbeat.alert.reduce.AlarmGroupReduce;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlarmCommonReduce {
    private static final Logger log = LoggerFactory.getLogger(AlarmCommonReduce.class);
    private final AlarmGroupReduce alarmGroupReduce;
    private ThreadPoolExecutor workerExecutor;

    public AlarmCommonReduce(AlarmGroupReduce alarmGroupReduce) {
        this.initWorkExecutor();
        this.alarmGroupReduce = alarmGroupReduce;
    }

    private void initWorkExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("alerter-reduce-worker has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("alerter-reduce-worker-%d").build();
        this.workerExecutor = new ThreadPoolExecutor(2, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public void reduceAndSendAlarm(SingleAlert alert) {
        this.workerExecutor.execute(this.reduceAlarmTask(alert));
    }

    public void reduceAndSendAlarmGroup(Map<String, String> groupLabels, List<SingleAlert> alerts) {
        this.workerExecutor.execute(() -> {
            try {
                for (SingleAlert alert : alerts) {
                    String fingerprint = this.generateAlertFingerprint(alert.getLabels());
                    alert.setFingerprint(fingerprint);
                }
                this.alarmGroupReduce.processGroupAlert(groupLabels, alerts);
            }
            catch (Exception e) {
                log.error("Reduce alarm group failed: {}", (Object)e.getMessage());
            }
        });
    }

    Runnable reduceAlarmTask(SingleAlert alert) {
        return () -> {
            try {
                String fingerprint = this.generateAlertFingerprint(alert.getLabels());
                alert.setFingerprint(fingerprint);
                this.alarmGroupReduce.processGroupAlert(alert);
            }
            catch (Exception e) {
                log.error("Reduce alarm failed: {}", (Object)e.getMessage());
            }
        };
    }

    private String generateAlertFingerprint(Map<String, String> labels) {
        labels.remove("timestamp");
        labels.remove("start_at");
        labels.remove("active_at");
        return labels.entrySet().stream().filter(e -> !"timestamp".equals(e.getKey()) && !"starts_at".equals(e.getKey()) && !"actives_at".equals(e.getKey()) && !"end_at".equals(e.getKey()) && !"ends_at".equals(e.getKey()) && !"start_at".equals(e.getKey()) && !"active_at".equals(e.getKey())).sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(","));
    }
}

