/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.obs.services.ObsClient;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectResult;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.apache.hertzbeat.manager.pojo.dto.FileDTO;
import org.apache.hertzbeat.manager.pojo.dto.ObjectStoreDTO;
import org.apache.hertzbeat.manager.service.ObjectStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObsObjectStoreServiceImpl
implements ObjectStoreService {
    private static final Logger log = LoggerFactory.getLogger(ObsObjectStoreServiceImpl.class);
    private final ObsClient obsClient;
    private final String bucketName;
    private final String rootPath;

    public ObsObjectStoreServiceImpl(ObsClient obsClient, String bucketName, String rootPath) {
        this.obsClient = obsClient;
        this.bucketName = bucketName;
        this.rootPath = rootPath.startsWith("/") ? rootPath.substring(1) : rootPath;
    }

    @Override
    public boolean upload(String filePath, InputStream is) {
        String objectKey = this.getObjectKey(filePath);
        PutObjectResult response = this.obsClient.putObject(this.bucketName, objectKey, is);
        return Objects.equals(response.getStatusCode(), 200);
    }

    @Override
    public void remove(String filePath) {
        String objectKey = this.getObjectKey(filePath);
        this.obsClient.deleteObject(this.bucketName, objectKey);
    }

    @Override
    public boolean isExist(String filePath) {
        String objectKey = this.getObjectKey(filePath);
        return this.obsClient.doesObjectExist(this.bucketName, objectKey);
    }

    @Override
    public FileDTO download(String filePath) {
        String objectKey = this.getObjectKey(filePath);
        try {
            ObsObject obsObject = this.obsClient.getObject(this.bucketName, objectKey);
            return new FileDTO(filePath, obsObject.getObjectContent());
        }
        catch (Exception ex) {
            log.warn("download file from obs error {}", (Object)objectKey);
            return null;
        }
    }

    @Override
    public List<FileDTO> list(String dir) {
        ListObjectsRequest request = new ListObjectsRequest(this.bucketName);
        request.setPrefix(this.getObjectKey(dir));
        return this.obsClient.listObjects(request).getObjects().stream().map(it -> new FileDTO(it.getObjectKey(), it.getObjectContent())).toList();
    }

    @Override
    public ObjectStoreDTO.Type type() {
        return ObjectStoreDTO.Type.OBS;
    }

    private String getObjectKey(String filePath) {
        return this.rootPath + "/" + filePath;
    }
}

