/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.AbstractWireable;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.IpmiChannelNumberCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.IpmiCommandName;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.IpmiLun;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.AbstractIpmiResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.code.IpmiEntityIdCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.code.IpmiReadingTypeCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.code.IpmiSensorTypeCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.code.IpmiSensorUnitTypeCode;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteOrderUtils;

public class GetSdrResponse
extends AbstractIpmiResponse {
    public int nextRecordId;
    public int recordId;
    public byte recordType;
    public byte recordLength;
    public byte sensorOwnerId;
    public IpmiLun sensorOwnerLun;
    public IpmiChannelNumberCode sensorOwnerChannelNumber;
    public byte sensorNumber;
    public IpmiEntityIdCode entityIdCode;
    public IpmiSensorTypeCode sensorTypeCode;
    public IpmiReadingTypeCode readingTypeCode;
    public byte analogDataFormat;
    public IpmiSensorUnitTypeCode unitTypeCode;
    public byte linear;
    public int m;
    public int b;
    public int k1;
    public int k2;
    public String sensorIdString;

    @Override
    public void fromResponseData(IpmiPacketContext context, ByteBuffer buffer) {
        byte[] recordIdBytes = ByteOrderUtils.readBytes(buffer, 2);
        this.nextRecordId = ByteConvertUtils.lsMsByteToInt(recordIdBytes[0], recordIdBytes[1]);
        this.fromSensorRecordHeader(context, buffer);
        int remainingLength = buffer.remaining();
        if (remainingLength == 0) {
            return;
        }
        if (this.recordType != 1) {
            buffer.position(buffer.limit());
            return;
        }
        this.fromRecordKeyBytes(context, buffer);
        this.fromFullSensorRecord(context, buffer);
    }

    @Override
    public IpmiCommandName getCommandName() {
        return IpmiCommandName.GetSdr;
    }

    public void fromSensorRecordHeader(IpmiPacketContext context, ByteBuffer buffer) {
        this.recordId = ByteOrderUtils.readLeChar(buffer);
        GetSdrResponse.ignoreBytes(buffer, 1);
        this.recordType = buffer.get();
        this.recordLength = buffer.get();
    }

    public void fromRecordKeyBytes(IpmiPacketContext context, ByteBuffer buffer) {
        this.sensorOwnerId = buffer.get();
        byte t = buffer.get();
        this.sensorOwnerLun = IpmiCode.fromByte(IpmiLun.class, AbstractWireable.getBits(t, 3));
        this.sensorOwnerChannelNumber = IpmiCode.fromByte(IpmiChannelNumberCode.class, AbstractWireable.getBits(t, 4, 15));
        this.sensorNumber = buffer.get();
    }

    public void fromFullSensorRecord(IpmiPacketContext context, ByteBuffer buffer) {
        this.entityIdCode = IpmiCode.fromBuffer(IpmiEntityIdCode.class, buffer);
        GetSdrResponse.ignoreBytes(buffer, 3);
        this.sensorTypeCode = IpmiCode.fromBuffer(IpmiSensorTypeCode.class, buffer);
        this.readingTypeCode = IpmiCode.fromBuffer(IpmiReadingTypeCode.class, buffer);
        GetSdrResponse.ignoreBytes(buffer, 6);
        byte t = buffer.get();
        this.analogDataFormat = AbstractWireable.getBits(t, 6, 3);
        this.unitTypeCode = IpmiCode.fromBuffer(IpmiSensorUnitTypeCode.class, buffer);
        GetSdrResponse.ignoreBytes(buffer, 1);
        this.linear = buffer.get();
        short mt = buffer.getShort();
        this.m = (mt & 0xFF00) >> 8 | (mt & 0xC0) << 2;
        this.m = ByteConvertUtils.getBitsAsSigned(this.m, 10);
        short ba = buffer.getShort();
        this.b = (ba & 0xFF00) >> 8 | (ba & 0xC0) << 2;
        this.b = ByteConvertUtils.getBitsAsSigned(this.b, 10);
        GetSdrResponse.ignoreBytes(buffer, 1);
        byte rb = buffer.get();
        this.k1 = AbstractWireable.getBits(rb, 0, 15);
        this.k1 = ByteConvertUtils.getBitsAsSigned(this.k1, 4);
        this.k2 = AbstractWireable.getBits(rb, 4, 15);
        this.k2 = ByteConvertUtils.getBitsAsSigned(this.k2, 4);
        GetSdrResponse.ignoreBytes(buffer, 17);
        int length = buffer.get() & 0x1F;
        if (buffer.remaining() < length) {
            length = buffer.remaining();
        }
        byte[] sensorIdBytes = ByteOrderUtils.readBytes(buffer, length);
        this.sensorIdString = new String(sensorIdBytes, StandardCharsets.US_ASCII);
    }
}

