/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.Bootstrap;
import io.questdb.FreeOnExit;
import io.questdb.PropBootstrapConfiguration;
import io.questdb.ServerConfiguration;
import io.questdb.TelemetryJob;
import io.questdb.WorkerPoolManager;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.FlushQueryCacheJob;
import io.questdb.cairo.mv.MatViewRefreshJob;
import io.questdb.cairo.mv.MatViewTimerJob;
import io.questdb.cairo.security.ReadOnlySecurityContextFactory;
import io.questdb.cairo.security.SecurityContextFactory;
import io.questdb.cairo.wal.ApplyWal2TableJob;
import io.questdb.cairo.wal.WalPurgeJob;
import io.questdb.cutlass.Services;
import io.questdb.cutlass.auth.AuthUtils;
import io.questdb.cutlass.auth.DefaultLineAuthenticatorFactory;
import io.questdb.cutlass.auth.EllipticCurveAuthenticatorFactory;
import io.questdb.cutlass.auth.LineAuthenticatorFactory;
import io.questdb.cutlass.http.DefaultHttpAuthenticatorFactory;
import io.questdb.cutlass.http.HttpAuthenticatorFactory;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpFullFatServerConfiguration;
import io.questdb.cutlass.http.HttpServer;
import io.questdb.cutlass.http.StaticHttpAuthenticatorFactory;
import io.questdb.cutlass.line.tcp.StaticChallengeResponseMatcher;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.cutlass.pgwire.PGServer;
import io.questdb.cutlass.pgwire.ReadOnlyUsersAwareSecurityContextFactory;
import io.questdb.cutlass.text.CopyJob;
import io.questdb.cutlass.text.CopyRequestJob;
import io.questdb.griffin.engine.table.AsyncFilterAtom;
import io.questdb.log.LogFactory;
import io.questdb.metrics.QueryTracingJob;
import io.questdb.mp.WorkerPool;
import io.questdb.mp.WorkerPoolUtils;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.filewatch.FileWatcher;
import java.io.Closeable;
import java.io.File;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ServerMain
implements Closeable {
    private final Bootstrap bootstrap;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CairoEngine engine;
    private final FreeOnExit freeOnExit = new FreeOnExit();
    private final AtomicBoolean running = new AtomicBoolean();
    protected PGServer pgServer;
    private FileWatcher fileWatcher;
    private HttpServer httpServer;
    private Thread hydrateMetadataThread;
    private boolean initialized;
    private WorkerPoolManager workerPoolManager;

    public ServerMain(String ... args) {
        this(new Bootstrap(args));
    }

    public ServerMain(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        this.engine = this.freeOnExit.register(bootstrap.newCairoEngine());
        try {
            ServerConfiguration config = bootstrap.getConfiguration();
            config.init(this.engine, this.freeOnExit);
            this.freeOnExit.register(config.getFactoryProvider());
            this.engine.load();
        }
        catch (Throwable th) {
            Misc.free(this.freeOnExit);
            throw th;
        }
    }

    public static ServerMain create(String root, Map<String, String> env) {
        final HashMap<String, String> newEnv = new HashMap<String, String>(System.getenv());
        newEnv.putAll(env);
        PropBootstrapConfiguration bootstrapConfiguration = new PropBootstrapConfiguration(){

            @Override
            public Map<String, String> getEnv() {
                return newEnv;
            }
        };
        return new ServerMain(new Bootstrap(bootstrapConfiguration, Bootstrap.getServerMainArgs(root)));
    }

    public static ServerMain create(String root) {
        return new ServerMain(Bootstrap.getServerMainArgs(root));
    }

    public static ServerMain createWithoutWalApplyJob(String root, Map<String, String> env) {
        final HashMap<String, String> newEnv = new HashMap<String, String>(System.getenv());
        newEnv.putAll(env);
        PropBootstrapConfiguration bootstrapConfiguration = new PropBootstrapConfiguration(){

            @Override
            public Map<String, String> getEnv() {
                return newEnv;
            }
        };
        return new ServerMain(new Bootstrap(bootstrapConfiguration, Bootstrap.getServerMainArgs(root))){

            @Override
            protected void setupWalApplyJob(WorkerPool workerPool, CairoEngine engine, int sharedQueryWorkerCount) {
            }
        };
    }

    public static HttpAuthenticatorFactory getHttpAuthenticatorFactory(ServerConfiguration configuration) {
        HttpFullFatServerConfiguration httpConfig = configuration.getHttpServerConfiguration();
        String username = httpConfig.getUsername();
        if (Chars.empty(username)) {
            return DefaultHttpAuthenticatorFactory.INSTANCE;
        }
        return new StaticHttpAuthenticatorFactory(username, httpConfig.getPassword());
    }

    public static LineAuthenticatorFactory getLineAuthenticatorFactory(ServerConfiguration configuration) {
        LineAuthenticatorFactory authenticatorFactory;
        if (configuration.getLineTcpReceiverConfiguration().isEnabled() && configuration.getLineTcpReceiverConfiguration().getAuthDB() != null) {
            String rootDir = new File(configuration.getCairoConfiguration().getDbRoot()).getParent();
            String absPath = new File(rootDir, configuration.getLineTcpReceiverConfiguration().getAuthDB()).getAbsolutePath();
            CharSequenceObjHashMap<PublicKey> authDb = AuthUtils.loadAuthDb(absPath);
            authenticatorFactory = new EllipticCurveAuthenticatorFactory(() -> new StaticChallengeResponseMatcher(authDb));
        } else {
            authenticatorFactory = DefaultLineAuthenticatorFactory.INSTANCE;
        }
        return authenticatorFactory;
    }

    public static SecurityContextFactory getSecurityContextFactory(ServerConfiguration configuration) {
        boolean readOnlyInstance = configuration.getCairoConfiguration().isReadOnlyInstance();
        if (readOnlyInstance) {
            return ReadOnlySecurityContextFactory.INSTANCE;
        }
        PGConfiguration pgConfiguration = configuration.getPGWireConfiguration();
        HttpContextConfiguration httpContextConfiguration = configuration.getHttpServerConfiguration().getHttpContextConfiguration();
        boolean settingsReadOnly = configuration.getHttpServerConfiguration().isSettingsReadOnly();
        boolean pgWireReadOnlyContext = pgConfiguration.readOnlySecurityContext();
        boolean pgWireReadOnlyUserEnabled = pgConfiguration.isReadOnlyUserEnabled();
        String pgWireReadOnlyUsername = pgWireReadOnlyUserEnabled ? pgConfiguration.getReadOnlyUsername() : null;
        boolean httpReadOnly = httpContextConfiguration.readOnlySecurityContext();
        return new ReadOnlyUsersAwareSecurityContextFactory(pgWireReadOnlyContext, pgWireReadOnlyUsername, httpReadOnly, settingsReadOnly);
    }

    public static void main(String[] args) {
        try {
            new ServerMain(args).start(true);
        }
        catch (Bootstrap.BootstrapException e) {
            if (e.isSilentStacktrace()) {
                System.err.println(e.getMessage());
            } else {
                e.printStackTrace();
            }
            LogFactory.closeInstance();
            System.exit(55);
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            LogFactory.closeInstance();
            System.exit(55);
        }
    }

    @NotNull
    public static String propertyPathToEnvVarName(@NotNull String propertyPath) {
        return "QDB_" + propertyPath.replace('.', '_').toUpperCase();
    }

    public void awaitTable(String tableName) {
        this.getEngine().awaitTable(tableName, 30L, TimeUnit.SECONDS);
    }

    public void awaitTxn(String tableName, long txn) {
        this.getEngine().awaitTxn(tableName, txn, 15L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.hydrateMetadataThread != null) {
                try {
                    this.hydrateMetadataThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            System.err.println("QuestDB is shutting down...");
            System.out.println("QuestDB is shutting down...");
            if (this.bootstrap != null && this.bootstrap.getLog() != null) {
                this.bootstrap.getLog().info().$("QuestDB is shutting down...").$();
            }
            if (this.initialized) {
                this.workerPoolManager.halt();
                this.fileWatcher = Misc.free(this.fileWatcher);
            }
            this.freeOnExit.close();
        }
    }

    public ServerConfiguration getConfiguration() {
        return this.bootstrap.getConfiguration();
    }

    public CairoEngine getEngine() {
        if (this.closed.get()) {
            throw new IllegalStateException("close was called");
        }
        return this.engine;
    }

    public int getHttpServerPort() {
        if (this.httpServer != null) {
            return this.httpServer.getPort();
        }
        throw CairoException.nonCritical().put("http server is not running");
    }

    public int getPgWireServerPort() {
        if (this.pgServer != null) {
            return this.pgServer.getPort();
        }
        throw CairoException.nonCritical().put("pgwire server is not running");
    }

    public WorkerPoolManager getWorkerPoolManager() {
        if (this.closed.get()) {
            throw new IllegalStateException("close was called");
        }
        return this.workerPoolManager;
    }

    public boolean hasBeenClosed() {
        return this.closed.get();
    }

    public boolean hasStarted() {
        return this.running.get();
    }

    public void resetQueryCache() {
        this.pgServer.resetQueryCache();
    }

    public void start() {
        this.start(false);
    }

    public synchronized void start(boolean addShutdownHook) {
        if (!this.closed.get() && this.running.compareAndSet(false, true)) {
            this.initialize();
            if (addShutdownHook) {
                this.addShutdownHook();
            }
            this.workerPoolManager.start(this.bootstrap.getLog());
            this.bootstrap.logBannerAndEndpoints(this.webConsoleSchema());
            System.gc();
            this.bootstrap.getLog().advisoryW().$("enjoy").$();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                System.err.println("SIGTERM received");
                System.out.println("SIGTERM received");
                this.bootstrap.getLog().debug().$("Pre-touch magic number: ").$(AsyncFilterAtom.PRE_TOUCH_BLACK_HOLE.sum()).$();
                this.close();
                LogFactory.closeInstance();
            }
            catch (Error error) {
            }
            finally {
                System.err.println("QuestDB is shutdown.");
                System.out.println("QuestDB is shutdown.");
            }
        }));
    }

    private synchronized void initialize() {
        this.initialized = true;
        final ServerConfiguration config = this.bootstrap.getConfiguration();
        final CairoConfiguration cairoConfig = config.getCairoConfiguration();
        final boolean walSupported = cairoConfig.isWalSupported();
        final boolean isReadOnly = cairoConfig.isReadOnlyInstance();
        final boolean walApplyEnabled = cairoConfig.isWalApplyEnabled();
        final boolean matViewEnabled = cairoConfig.isMatViewEnabled();
        this.workerPoolManager = new WorkerPoolManager(config){

            @Override
            protected void configureWorkerPools(WorkerPool sharedPoolQuery, WorkerPool sharedPoolWrite) {
                try {
                    sharedPoolWrite.assign(ServerMain.this.engine.getEngineMaintenanceJob());
                    WorkerPoolUtils.setupQueryJobs(sharedPoolQuery, ServerMain.this.engine);
                    QueryTracingJob queryTracingJob = new QueryTracingJob(ServerMain.this.engine);
                    sharedPoolQuery.assign(queryTracingJob);
                    ServerMain.this.freeOnExit.register(queryTracingJob);
                    if (!isReadOnly) {
                        WorkerPoolUtils.setupWriterJobs(sharedPoolWrite, ServerMain.this.engine);
                        if (walSupported) {
                            sharedPoolWrite.assign(config.getFactoryProvider().getWalJobFactory().createCheckWalTransactionsJob(ServerMain.this.engine));
                            WalPurgeJob walPurgeJob = config.getFactoryProvider().getWalJobFactory().createWalPurgeJob(ServerMain.this.engine);
                            ServerMain.this.engine.setWalPurgeJobRunLock(walPurgeJob.getRunLock());
                            walPurgeJob.delayByHalfInterval();
                            sharedPoolWrite.assign(walPurgeJob);
                            sharedPoolWrite.freeOnExit(walPurgeJob);
                            if (walApplyEnabled && !config.getWalApplyPoolConfiguration().isEnabled()) {
                                ServerMain.this.setupWalApplyJob(sharedPoolWrite, ServerMain.this.engine, sharedPoolQuery.getWorkerCount());
                            }
                        }
                        CopyJob.assignToPool(ServerMain.this.engine.getMessageBus(), sharedPoolWrite);
                        if (!Chars.empty(cairoConfig.getSqlCopyInputRoot())) {
                            CopyRequestJob copyRequestJob = new CopyRequestJob(ServerMain.this.engine, Math.max(1, sharedPoolWrite.getWorkerCount() - 2));
                            sharedPoolWrite.assign(copyRequestJob);
                            sharedPoolWrite.freeOnExit(copyRequestJob);
                        }
                        if (matViewEnabled && !config.getMatViewRefreshPoolConfiguration().isEnabled()) {
                            ServerMain.this.setupMatViewJobs(sharedPoolWrite, ServerMain.this.engine, sharedPoolQuery.getWorkerCount());
                        }
                    }
                    if (!cairoConfig.getTelemetryConfiguration().getDisableCompletely()) {
                        TelemetryJob telemetryJob = new TelemetryJob(ServerMain.this.engine);
                        ServerMain.this.freeOnExit.register(telemetryJob);
                        if (cairoConfig.getTelemetryConfiguration().getEnabled()) {
                            sharedPoolWrite.assign(telemetryJob);
                        }
                    }
                }
                catch (Throwable thr) {
                    throw new Bootstrap.BootstrapException(thr);
                }
            }
        };
        this.engine.buildMatViewGraph();
        if (matViewEnabled && !isReadOnly && config.getMatViewRefreshPoolConfiguration().isEnabled()) {
            WorkerPool matViewRefreshWorkerPool = this.workerPoolManager.getInstanceWrite(config.getMatViewRefreshPoolConfiguration(), WorkerPoolManager.Requester.MAT_VIEW_REFRESH);
            this.setupMatViewJobs(matViewRefreshWorkerPool, this.engine, this.workerPoolManager.getSharedQueryWorkerCount());
        }
        if (walApplyEnabled && !isReadOnly && walSupported && config.getWalApplyPoolConfiguration().isEnabled()) {
            WorkerPool walApplyWorkerPool = this.workerPoolManager.getInstanceWrite(config.getWalApplyPoolConfiguration(), WorkerPoolManager.Requester.WAL_APPLY);
            this.setupWalApplyJob(walApplyWorkerPool, this.engine, this.workerPoolManager.getSharedQueryWorkerCount());
        }
        this.httpServer = this.services().createHttpServer(config, this.engine, this.workerPoolManager);
        this.freeOnExit.register(this.httpServer);
        this.freeOnExit.register(this.services().createMinHttpServer(config.getHttpMinServerConfiguration(), this.workerPoolManager));
        this.pgServer = this.services().createPGWireServer(config.getPGWireConfiguration(), this.engine, this.workerPoolManager);
        this.freeOnExit.register(this.pgServer);
        this.workerPoolManager.getSharedPoolNetwork().assign(new FlushQueryCacheJob(this.engine.getMessageBus(), this.httpServer, this.pgServer));
        if (!isReadOnly && config.getLineTcpReceiverConfiguration().isEnabled()) {
            this.freeOnExit.register(this.services().createLineTcpReceiver(config.getLineTcpReceiverConfiguration(), this.engine, this.workerPoolManager));
            this.freeOnExit.register(this.services().createLineUdpReceiver(config.getLineUdpReceiverConfiguration(), this.engine, this.workerPoolManager));
        }
        this.hydrateMetadataThread = new Thread(this.engine.getMetadataCache()::onStartupAsyncHydrator);
        this.hydrateMetadataThread.start();
        System.gc();
        this.bootstrap.getLog().advisoryW().$("server is ready to be started").$();
    }

    protected Services services() {
        return Services.INSTANCE;
    }

    protected void setupMatViewJobs(WorkerPool sharedPoolWrite, CairoEngine engine, int sharedQueryWorkerCount) {
        int workerCount = sharedPoolWrite.getWorkerCount();
        for (int i = 0; i < workerCount; ++i) {
            MatViewRefreshJob matViewRefreshJob = new MatViewRefreshJob(i, engine, sharedQueryWorkerCount);
            sharedPoolWrite.assign(i, matViewRefreshJob);
            sharedPoolWrite.freeOnExit(matViewRefreshJob);
        }
        MatViewTimerJob matViewTimerJob = new MatViewTimerJob(engine);
        sharedPoolWrite.assign(matViewTimerJob);
    }

    protected void setupWalApplyJob(WorkerPool sharedPoolWrite, CairoEngine engine, int sharedQueryWorkerCount) {
        int workerCount = sharedPoolWrite.getWorkerCount();
        for (int i = 0; i < workerCount; ++i) {
            ApplyWal2TableJob applyWal2TableJob = new ApplyWal2TableJob(engine, sharedQueryWorkerCount);
            sharedPoolWrite.assign(i, applyWal2TableJob);
            sharedPoolWrite.freeOnExit(applyWal2TableJob);
        }
    }

    protected String webConsoleSchema() {
        return "http";
    }
}

