/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.TelemetryConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SCSequence;
import io.questdb.preferences.PreferencesMap;
import io.questdb.preferences.PreferencesUpdateListener;
import io.questdb.std.Chars;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.NanosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import java.io.Closeable;

public class TelemetryConfigLogger
implements PreferencesUpdateListener,
Closeable {
    public static final String OS_NAME = "os.name";
    public static final String TELEMETRY_CONFIG_TABLE_NAME = "telemetry_config";
    private static final String INSTANCE_DESC = "instance_description";
    private static final String INSTANCE_NAME = "instance_name";
    private static final String INSTANCE_TYPE = "instance_type";
    private static final Log LOG = LogFactory.getLog(TelemetryConfigLogger.class);
    private static final String QDB_PACKAGE = "QDB_PACKAGE";
    private final CairoEngine engine;
    private final CharSequence questDBVersion;
    private final TelemetryConfiguration telemetryConfiguration;
    private final SCSequence tempSequence = new SCSequence();
    private TableToken configTableToken;
    private TableWriter configWriter;
    private CharSequence instanceDesc;
    private CharSequence instanceName;
    private CharSequence instanceType;

    public TelemetryConfigLogger(CairoEngine engine) {
        this.engine = engine;
        this.questDBVersion = engine.getConfiguration().getBuildInformation().getSwVersion();
        this.telemetryConfiguration = engine.getConfiguration().getTelemetryConfiguration();
    }

    @Override
    public void close() {
        this.configWriter = Misc.free(this.configWriter);
    }

    @Override
    public void update(PreferencesMap preferencesMap) {
        this.instanceName = preferencesMap.get(INSTANCE_NAME);
        this.instanceName = this.instanceName == null ? "" : this.instanceName;
        this.instanceType = preferencesMap.get(INSTANCE_TYPE);
        this.instanceType = this.instanceType == null ? "" : this.instanceType;
        this.instanceDesc = preferencesMap.get(INSTANCE_DESC);
        this.instanceDesc = this.instanceDesc == null ? "" : this.instanceDesc;
        try (SqlCompiler compiler = this.engine.getSqlCompiler();){
            SqlExecutionContextImpl sqlExecutionContext = new SqlExecutionContextImpl(this.engine, 1);
            sqlExecutionContext.with(this.engine.getConfiguration().getFactoryProvider().getSecurityContextFactory().getRootContext(), null, null);
            this.updateTelemetryConfig(this.engine, compiler, sqlExecutionContext, this.configTableToken);
        }
        catch (Throwable th) {
            LOG.error().$("could not update config telemetry [table=`").$safe(TELEMETRY_CONFIG_TABLE_NAME).$("]").$(th).$();
        }
    }

    private void appendConfigRow(CairoEngine engine, TableWriter configWriter, Long256 id, boolean enabled) {
        TableWriter.Row row = configWriter.newRow();
        if (id == null) {
            MicrosecondClock clock = engine.getConfiguration().getMicrosecondClock();
            NanosecondClock nanosecondClock = engine.getConfiguration().getNanosecondClock();
            long a = nanosecondClock.getTicks();
            long b = clock.getTicks();
            row.putLong256(0, a, b, 0L, 0L);
            LOG.info().$("new instance [id=").$256(a, b, 0L, 0L).$(", enabled=").$(enabled).I$();
        } else {
            row.putLong256(0, id);
        }
        row.putBool(1, enabled);
        row.putSym(2, this.questDBVersion);
        row.putSym(3, System.getProperty(OS_NAME));
        String packageStr = System.getenv().get(QDB_PACKAGE);
        if (packageStr != null) {
            row.putSym(4, packageStr);
        }
        row.putSym(5, this.instanceName);
        row.putSym(6, this.instanceType);
        row.putSym(7, this.instanceDesc);
        row.append();
        configWriter.commit();
    }

    private void tryAddColumn(SqlCompiler compiler, SqlExecutionContext executionContext, CharSequence columnDetails) {
        try {
            CompiledQuery cc = compiler.query().$("ALTER TABLE ").$(TELEMETRY_CONFIG_TABLE_NAME).$(" ADD COLUMN IF NOT EXISTS ").$(columnDetails).compile(executionContext);
            try (OperationFuture fut = cc.execute(this.tempSequence);){
                fut.await();
            }
        }
        catch (SqlException sqlException) {
            // empty catch block
        }
    }

    private void updateTelemetryConfig(CairoEngine engine, SqlCompiler compiler, SqlExecutionContextImpl sqlExecutionContext, TableToken tableToken) throws SqlException {
        try (TableWriter configWriter = engine.getWriter(tableToken, "telemetryConfig");){
            CompiledQuery cc = compiler.query().$(TELEMETRY_CONFIG_TABLE_NAME).$(" LIMIT -1").compile(sqlExecutionContext);
            try (RecordCursorFactory factory = cc.getRecordCursorFactory();
                 RecordCursor cursor = factory.getCursor(sqlExecutionContext);){
                boolean enabled = this.telemetryConfiguration.getEnabled();
                if (cursor.hasNext()) {
                    Record record = cursor.getRecord();
                    Long256 l256 = record.getLong256A(0);
                    boolean _enabled = record.getBool(1);
                    CharSequence _questDBVersion = record.getSymA(2);
                    CharSequence _instanceName = record.getSymA(5);
                    CharSequence _instanceType = record.getSymA(6);
                    CharSequence _instanceDesc = record.getSymA(7);
                    if (!(enabled == _enabled && Chars.equalsNc(this.questDBVersion, _questDBVersion) && Chars.equalsNc(this.instanceName, _instanceName) && Chars.equalsNc(this.instanceType, _instanceType) && Chars.equalsNc(this.instanceDesc, _instanceDesc))) {
                        this.appendConfigRow(engine, configWriter, l256, enabled);
                        LOG.advisory().$("instance config changes [id=").$256(l256.getLong0(), l256.getLong1(), 0L, 0L).$(", enabled=").$(enabled).I$();
                    } else {
                        LOG.advisory().$("instance [id=").$256(l256.getLong0(), l256.getLong1(), 0L, 0L).$(", enabled=").$(enabled).I$();
                    }
                } else {
                    this.appendConfigRow(engine, configWriter, null, enabled);
                }
            }
        }
        catch (CairoException ex) {
            LOG.error().$("could not update config telemetry [table=`").$safe(TELEMETRY_CONFIG_TABLE_NAME).$("`, msg=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
        }
    }

    void init(CairoEngine engine, SqlCompiler compiler, SqlExecutionContextImpl sqlExecutionContext) throws SqlException {
        this.configTableToken = compiler.query().$("CREATE TABLE IF NOT EXISTS ").$(TELEMETRY_CONFIG_TABLE_NAME).$(" (id long256, enabled boolean, version symbol, os symbol, package symbol, instance_name symbol, instance_type symbol, instance_desc symbol)").createTable(sqlExecutionContext);
        this.tryAddColumn(compiler, sqlExecutionContext, "version symbol");
        this.tryAddColumn(compiler, sqlExecutionContext, "os symbol");
        this.tryAddColumn(compiler, sqlExecutionContext, "package symbol");
        this.tryAddColumn(compiler, sqlExecutionContext, "instance_name symbol");
        this.tryAddColumn(compiler, sqlExecutionContext, "instance_type symbol");
        this.tryAddColumn(compiler, sqlExecutionContext, "instance_desc symbol");
        engine.getSettingsStore().registerListener(this);
    }
}

