/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.ServerConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.metrics.Target;
import io.questdb.mp.Worker;
import io.questdb.mp.WorkerPool;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.ObjList;
import io.questdb.std.str.BorrowableUtf8Sink;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WorkerPoolManager
implements Target {
    private static final Log LOG = LogFactory.getLog(WorkerPoolManager.class);
    protected final WorkerPool sharedPoolNetwork;
    @Nullable
    protected final WorkerPool sharedPoolQuery;
    protected final WorkerPool sharedPoolWrite;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CharSequenceObjHashMap<WorkerPool> dedicatedPools = new CharSequenceObjHashMap(4);
    private final AtomicBoolean running = new AtomicBoolean();

    public WorkerPoolManager(ServerConfiguration config) {
        this.sharedPoolNetwork = new WorkerPool(config.getNetworkWorkerPoolConfiguration());
        this.sharedPoolQuery = config.getQueryWorkerPoolConfiguration().getWorkerCount() > 0 ? new WorkerPool(config.getQueryWorkerPoolConfiguration()) : null;
        this.sharedPoolWrite = new WorkerPool(config.getWriteWorkerPoolConfiguration());
        WorkerPool queryPool = this.sharedPoolQuery != null ? this.sharedPoolQuery : this.sharedPoolNetwork;
        this.configureWorkerPools(queryPool, this.sharedPoolWrite);
        config.getMetrics().addScrapable(this);
    }

    public WorkerPool getSharedNetworkPool(@NotNull WorkerPoolConfiguration config, @NotNull Requester requester) {
        return this.getWorkerPool(config, requester, this.sharedPoolNetwork);
    }

    public WorkerPool getInstanceWrite(@NotNull WorkerPoolConfiguration config, @NotNull Requester requester) {
        return this.getWorkerPool(config, requester, this.sharedPoolWrite);
    }

    public WorkerPool getSharedPoolNetwork() {
        return this.sharedPoolNetwork;
    }

    public int getSharedQueryWorkerCount() {
        return this.sharedPoolQuery != null ? this.sharedPoolQuery.getWorkerCount() : 0;
    }

    public void halt() {
        ObjList<CharSequence> poolNames = this.dedicatedPools.keys();
        int limit = poolNames.size();
        for (int i = 0; i < limit; ++i) {
            CharSequence name = poolNames.getQuick(i);
            WorkerPool pool = this.dedicatedPools.get(name);
            this.closePool(pool, "closing dedicated pool [name=");
        }
        this.dedicatedPools.clear();
        this.closePool(this.sharedPoolNetwork, "closing shared Network pool [name=");
        this.closePool(this.sharedPoolQuery, "closing shared Query pool [name=");
        this.closePool(this.sharedPoolWrite, "closing shared Write pool [name=");
        this.closed.set(true);
    }

    @Override
    public void scrapeIntoPrometheus(@NotNull BorrowableUtf8Sink sink) {
        long now = Worker.CLOCK_MICROS.getTicks();
        this.sharedPoolNetwork.updateWorkerMetrics(now);
        if (this.sharedPoolQuery != null) {
            this.sharedPoolQuery.updateWorkerMetrics(now);
        }
        this.sharedPoolWrite.updateWorkerMetrics(now);
        ObjList<CharSequence> poolNames = this.dedicatedPools.keys();
        int limit = poolNames.size();
        for (int i = 0; i < limit; ++i) {
            this.dedicatedPools.get(poolNames.getQuick(i)).updateWorkerMetrics(now);
        }
    }

    public void start(Log sharedPoolLog) {
        if (this.running.compareAndSet(false, true)) {
            WorkerPoolManager.startWorkerPool(sharedPoolLog, this.sharedPoolNetwork, "started shared pool [name=");
            WorkerPoolManager.startWorkerPool(sharedPoolLog, this.sharedPoolQuery, "started shared pool [name=");
            WorkerPoolManager.startWorkerPool(sharedPoolLog, this.sharedPoolWrite, "started shared pool [name=");
            ObjList<CharSequence> poolNames = this.dedicatedPools.keys();
            int limit = poolNames.size();
            for (int i = 0; i < limit; ++i) {
                CharSequence name = poolNames.get(i);
                WorkerPool pool = this.dedicatedPools.get(name);
                WorkerPoolManager.startWorkerPool(sharedPoolLog, pool, "started dedicated pool [name=");
            }
        }
    }

    private static void startWorkerPool(Log sharedPoolLog, WorkerPool p, String msg) {
        if (p != null) {
            p.start(sharedPoolLog);
            LOG.info().$(msg).$(p.getPoolName()).$(", workers=").$(p.getWorkerCount()).I$();
        }
    }

    private void closePool(WorkerPool p, String message) {
        if (p != null) {
            LOG.info().$(message).$(p.getPoolName()).$(", workers=").$(p.getWorkerCount()).I$();
            p.halt();
        }
    }

    @NotNull
    private WorkerPool getWorkerPool(@NotNull WorkerPoolConfiguration config, @NotNull Requester requester, WorkerPool sharedPool) {
        if (this.running.get() || this.closed.get()) {
            throw new IllegalStateException("can only get instance before start");
        }
        if (config.getWorkerCount() < 1) {
            LOG.info().$("using SHARED pool [requester=").$((Object)requester).$(", workers=").$(sharedPool.getWorkerCount()).$(", pool=").$(sharedPool.getPoolName()).I$();
            return sharedPool;
        }
        String poolName = config.getPoolName();
        WorkerPool pool = this.dedicatedPools.get(poolName);
        if (pool == null) {
            pool = new WorkerPool(config);
            this.dedicatedPools.put(poolName, pool);
        }
        LOG.info().$("new DEDICATED pool [name=").$(poolName).$(", requester=").$((Object)requester).$(", workers=").$(pool.getWorkerCount()).$(", priority=").$(config.workerPoolPriority()).I$();
        return pool;
    }

    protected abstract void configureWorkerPools(WorkerPool var1, WorkerPool var2);

    public static enum Requester {
        HTTP_SERVER("http"),
        HTTP_MIN_SERVER("min-http"),
        PG_WIRE_SERVER("pg-wire"),
        LINE_TCP_IO("line-tcp-io"),
        LINE_TCP_WRITER("line-tcp-writer"),
        OTHER("other"),
        WAL_APPLY("wal-apply"),
        MAT_VIEW_REFRESH("mat-view-refresh");

        private final String requester;

        private Requester(String requester) {
            this.requester = requester;
        }

        public String toString() {
            return this.requester;
        }
    }
}

