/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BinaryTypeDriver;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.StringTypeDriver;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.LowerCaseAsciiCharSequenceIntHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;

public final class ColumnType {
    public static final int ARRAY_NDIMS_LIMIT = 32;
    public static final String[] ARRAY_DIM_SUFFIX;
    public static final int GEOBYTE_MAX_BITS = 7;
    public static final int GEOBYTE_MIN_BITS = 1;
    public static final int GEOINT_MAX_BITS = 31;
    public static final int GEOINT_MIN_BITS = 16;
    public static final int GEOLONG_MAX_BITS = 60;
    public static final int GEOLONG_MIN_BITS = 32;
    public static final int GEOSHORT_MAX_BITS = 15;
    public static final int GEOSHORT_MIN_BITS = 8;
    public static final int LEGACY_VAR_SIZE_AUX_SHL = 3;
    public static final int MIGRATION_VERSION = 427;
    public static final short OVERLOAD_FULL = -1;
    public static final short OVERLOAD_NONE = 10000;
    public static final short UNDEFINED = 0;
    public static final short BOOLEAN = 1;
    public static final short BYTE = 2;
    public static final short SHORT = 3;
    public static final short CHAR = 4;
    public static final short INT = 5;
    public static final short LONG = 6;
    public static final short DATE = 7;
    public static final short TIMESTAMP = 8;
    public static final short FLOAT = 9;
    public static final short DOUBLE = 10;
    public static final short STRING = 11;
    public static final short SYMBOL = 12;
    public static final short LONG256 = 13;
    public static final short GEOBYTE = 14;
    public static final short GEOSHORT = 15;
    public static final short GEOINT = 16;
    public static final short GEOLONG = 17;
    public static final short BINARY = 18;
    public static final short UUID = 19;
    public static final short CURSOR = 20;
    public static final short VAR_ARG = 21;
    public static final short RECORD = 22;
    public static final short GEOHASH = 23;
    public static final short LONG128 = 24;
    public static final short IPv4 = 25;
    public static final short VARCHAR = 26;
    public static final short ARRAY = 27;
    public static final short REGCLASS = 28;
    public static final short REGPROCEDURE = 29;
    public static final short ARRAY_STRING = 30;
    public static final short PARAMETER = 31;
    public static final short INTERVAL = 32;
    public static final short NULL = 33;
    private static final short[] TYPE_SIZE;
    private static final short[] TYPE_SIZE_POW2;
    private static final short OVERLOAD_PRIORITY_N;
    private static final int[] OVERLOAD_PRIORITY_MATRIX;
    public static final int VARCHAR_AUX_SHL = 4;
    public static final int VERSION = 426;
    static final int[] GEO_TYPE_SIZE_POW2;
    private static final boolean ALLOW_DEFAULT_STRING_CHANGE = false;
    private static final int ARRAY_ELEMTYPE_FIELD_MASK = 63;
    private static final int ARRAY_ELEMTYPE_FIELD_POS = 8;
    private static final int ARRAY_NDIMS_FIELD_MASK = 31;
    private static final int ARRAY_NDIMS_FIELD_POS = 14;
    private static final int BYTE_BITS = 8;
    private static final short[][] OVERLOAD_PRIORITY;
    private static final int TYPE_FLAG_DESIGNATED_TIMESTAMP = 131072;
    private static final int TYPE_FLAG_GEO_HASH = 65536;
    private static final IntHashSet arrayTypeSet;
    private static final LowerCaseAsciiCharSequenceIntHashMap nameTypeMap;
    private static final IntHashSet nonPersistedTypes;
    private static final IntObjHashMap<String> typeNameMap;

    private ColumnType() {
    }

    public static short commonWideningType(short typeA, short typeB) {
        return typeA == typeB && typeA != 12 ? typeA : (ColumnType.isStringyType(typeA) && ColumnType.isStringyType(typeB) ? (short)11 : (ColumnType.isStringyType(typeA) && ColumnType.isParseableType(typeB) ? typeA : (ColumnType.isStringyType(typeB) && ColumnType.isParseableType(typeA) ? (short)typeB : (typeA == 33 && ColumnType.isCastableFromNull(typeB) && typeB != 12 ? (short)typeB : (typeB == 33 && ColumnType.isCastableFromNull(typeA) && typeA != 12 ? typeA : (typeA == 8 && typeB == 6 ? (short)8 : (typeA == 6 && typeB == 8 ? (short)8 : (typeA == 26 || typeB == 26 ? (short)26 : (typeA == 11 || typeB == 11 ? (short)11 : (typeA == 1 || typeB == 1 ? (short)11 : (ColumnType.isToSameOrWider(typeB, typeA) && typeA != 12 && typeA != 4 ? typeA : (ColumnType.isToSameOrWider(typeA, typeB) && typeB != 12 && typeB != 4 ? (short)typeB : (short)11))))))))))));
    }

    public static int decodeArrayDimensionality(int encodedType) {
        if (ColumnType.isNull(encodedType)) {
            return 0;
        }
        assert (ColumnType.isArray(encodedType)) : "typeTag of encodedType is not ARRAY";
        return (encodedType >> 14 & 0x1F) + 1;
    }

    public static short decodeArrayElementType(int encodedType) {
        if (ColumnType.isNull(encodedType)) {
            return 33;
        }
        assert (ColumnType.isArray(encodedType)) : "typeTag of encodedType is not ARRAY";
        return (short)(encodedType >> 8 & 0x3F);
    }

    public static boolean defaultStringImplementationIsUtf8() {
        return Chars.equals(ColumnType.nameOf(11), "VARCHAR");
    }

    public static int encodeArrayType(short elemType, int nDims) {
        assert (nDims >= 1 && nDims <= 32) : "nDims out of range: " + nDims;
        assert (ColumnType.isSupportedArrayElementType(elemType) || elemType == 0) : "not supported as array element type: " + ColumnType.nameOf(elemType);
        return (--nDims & 0x1F) << 14 | (elemType & 0x3F) << 8 | 0x1B;
    }

    public static ColumnTypeDriver getDriver(int columnType) {
        switch (ColumnType.tagOf(columnType)) {
            case 11: {
                return StringTypeDriver.INSTANCE;
            }
            case 18: {
                return BinaryTypeDriver.INSTANCE;
            }
            case 26: {
                return VarcharTypeDriver.INSTANCE;
            }
            case 27: {
                return ArrayTypeDriver.INSTANCE;
            }
        }
        throw CairoException.critical(0).put("no driver for type: ").put(columnType);
    }

    public static int getGeoHashBits(int type) {
        return (byte)(type >> 8 & 0xFF);
    }

    public static int getGeoHashTypeWithBits(int bits) {
        assert (bits > 0 && bits <= 60);
        return ColumnType.mkGeoHashType(bits, (short)(14 + ColumnType.pow2SizeOfBits(bits)));
    }

    public static int getWalDataColumnShl(int columnType, boolean designatedTimestamp) {
        if (columnType == 8 && designatedTimestamp) {
            return 4;
        }
        return ColumnType.pow2SizeOf(columnType);
    }

    public static boolean isArray(int columnType) {
        return ColumnType.tagOf(columnType) == 27;
    }

    public static boolean isAssignableFrom(int fromType, int toType) {
        return ColumnType.isToSameOrWider(fromType, toType) || ColumnType.isNarrowingCast(fromType, toType);
    }

    public static boolean isBinary(int columnType) {
        return columnType == 18;
    }

    public static boolean isBoolean(int columnType) {
        return columnType == 1;
    }

    public static boolean isBuiltInWideningCast(int fromType, int toType) {
        return fromType >= 2 && toType >= 2 && toType <= 10 && fromType < toType || fromType == 33 || fromType == 4 && toType == 3 || fromType == 2 && toType == 1 || fromType == 8 && toType == 6 || fromType == 11 && toType >= 2 && toType <= 10;
    }

    public static boolean isCastableFromNull(int columnType) {
        return ColumnType.tagOf(columnType) != 4;
    }

    public static boolean isChar(int columnType) {
        return columnType == 4;
    }

    public static boolean isComparable(int columnType) {
        short typeTag = ColumnType.tagOf(columnType);
        return typeTag != 18 && typeTag != 32 && typeTag != 27;
    }

    public static boolean isCursor(int columnType) {
        return columnType == 20;
    }

    public static boolean isDesignatedTimestamp(int columnType) {
        return ColumnType.tagOf(columnType) == 8 && (columnType & 0x20000) != 0;
    }

    public static boolean isDouble(int columnType) {
        return columnType == 10;
    }

    public static boolean isFixedSize(int columnType) {
        switch (columnType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGenericType(int columnType) {
        return ColumnType.isGeoHash(columnType) || ColumnType.isArray(columnType);
    }

    public static boolean isGeoHash(int columnType) {
        return (columnType & 0x10000) != 0;
    }

    public static boolean isGeoType(int colType) {
        return colType >= 14 && colType <= 17;
    }

    public static boolean isInt(int columnType) {
        return columnType == 5;
    }

    public static boolean isInterval(int columnType) {
        return columnType == 32;
    }

    public static boolean isNull(int columnType) {
        return columnType == 33;
    }

    public static boolean isParseableType(int colType) {
        return colType == 8 || colType == 13;
    }

    public static boolean isPersisted(int columnType) {
        return nonPersistedTypes.excludes(columnType);
    }

    public static boolean isString(int columnType) {
        return columnType == 11;
    }

    public static boolean isStringyType(int colType) {
        return colType == 26 || colType == 11;
    }

    public static boolean isSupportedArrayElementType(short typeTag) {
        return arrayTypeSet.contains(typeTag);
    }

    public static boolean isSymbol(int columnType) {
        return columnType == 12;
    }

    public static boolean isSymbolOrString(int columnType) {
        return columnType == 12 || columnType == 11;
    }

    public static boolean isSymbolOrStringOrVarchar(int columnType) {
        return columnType == 12 || columnType == 11 || columnType == 26;
    }

    public static boolean isTimestamp(int columnType) {
        return columnType == 8;
    }

    public static boolean isToSameOrWider(int fromType, int toType) {
        return ColumnType.tagOf(fromType) == ColumnType.tagOf(toType) && !ColumnType.isArray(fromType) && (ColumnType.getGeoHashBits(fromType) == 0 || ColumnType.getGeoHashBits(fromType) >= ColumnType.getGeoHashBits(toType)) || ColumnType.isBuiltInWideningCast(fromType, toType) || ColumnType.isStringCast(fromType, toType) || ColumnType.isVarcharCast(fromType, toType) || ColumnType.isGeoHashWideningCast(fromType, toType) || ColumnType.isImplicitParsingCast(fromType, toType) || ColumnType.isIPv4Cast(fromType, toType) || ColumnType.isArrayCast(fromType, toType);
    }

    public static boolean isUndefined(int columnType) {
        return columnType == 0;
    }

    public static boolean isUnderdefined(int columnType) {
        return columnType == 0 || ColumnType.isUndefinedArray(columnType);
    }

    public static boolean isVarSize(int columnType) {
        return columnType == 11 || columnType == 18 || columnType == 26 || ColumnType.tagOf(columnType) == 27;
    }

    public static boolean isVarchar(int columnType) {
        return columnType == 26;
    }

    public static boolean isVarcharOrString(int columnType) {
        return columnType == 26 || columnType == 11;
    }

    public static void makeUtf16DefaultString() {
    }

    public static void makeUtf8DefaultString() {
    }

    public static String nameOf(int columnType) {
        int index = typeNameMap.keyIndex(columnType);
        if (index > -1) {
            return "unknown";
        }
        return typeNameMap.valueAtQuick(index);
    }

    public static int overloadDistance(short from, short to) {
        short fromTag = ColumnType.tagOf(from);
        short toTag = ColumnType.tagOf(to);
        assert (toTag > 0) : "Undefined not supported in overloads";
        return OVERLOAD_PRIORITY_MATRIX[OVERLOAD_PRIORITY_N * fromTag + toTag];
    }

    public static int pow2SizeOf(int columnType) {
        return TYPE_SIZE_POW2[ColumnType.tagOf(columnType)];
    }

    public static int pow2SizeOfBits(int bits) {
        assert (bits <= 60);
        return GEO_TYPE_SIZE_POW2[bits];
    }

    public static void resetStringToDefault() {
        ColumnType.makeUtf16DefaultString();
    }

    public static int setDesignatedTimestampBit(int tsType, boolean designated) {
        if (designated) {
            return tsType | 0x20000;
        }
        return tsType & 0xFFFDFFFF;
    }

    public static int sizeOf(int columnType) {
        short tag = ColumnType.tagOf(columnType);
        if (tag < TYPE_SIZE.length) {
            return TYPE_SIZE[tag];
        }
        return -1;
    }

    public static short tagOf(int type) {
        if (type == -1) {
            return (short)type;
        }
        return (short)(type & 0xFF);
    }

    public static short tagOf(CharSequence name) {
        return ColumnType.tagOf(nameTypeMap.get(name));
    }

    public static int typeOf(CharSequence name) {
        return nameTypeMap.get(name);
    }

    private static boolean isArrayCast(int fromType, int toType) {
        return ColumnType.isArray(fromType) && ColumnType.isArray(toType) && ColumnType.decodeArrayElementType(fromType) == ColumnType.decodeArrayElementType(toType) && ColumnType.decodeArrayDimensionality(fromType) == ColumnType.decodeArrayDimensionality(toType);
    }

    private static boolean isGeoHashWideningCast(int fromType, int toType) {
        short toTag = ColumnType.tagOf(toType);
        short fromTag = ColumnType.tagOf(fromType);
        switch (fromTag) {
            case 17: {
                if (toTag == 16) {
                    return true;
                }
            }
            case 16: {
                if (toTag == 15) {
                    return true;
                }
            }
            case 15: {
                if (toTag != 14) break;
                return true;
            }
        }
        return false;
    }

    private static boolean isIPv4Cast(int fromType, int toType) {
        return (fromType == 11 || fromType == 26) && toType == 25;
    }

    private static boolean isImplicitParsingCast(int fromType, int toType) {
        short toTag = ColumnType.tagOf(toType);
        switch (fromType) {
            case 4: {
                return toTag == 14 && ColumnType.getGeoHashBits(toType) < 6;
            }
            case 11: 
            case 26: {
                return toTag == 14 || toTag == 15 || toTag == 16 || toTag == 17 || toTag == 8 || toTag == 13;
            }
            case 12: {
                return toTag == 8;
            }
        }
        return false;
    }

    private static boolean isNarrowingCast(int fromType, int toType) {
        return fromType == 10 && (toType == 9 || toType >= 2 && toType <= 6) || fromType == 9 && toType >= 2 && toType <= 6 || fromType == 6 && toType >= 2 && toType <= 5 || fromType == 5 && toType >= 2 && toType <= 3 || fromType == 3 && toType == 2 || fromType == 4 && toType == 2 || ColumnType.isStringyType(fromType) && (toType == 2 || toType == 3 || toType == 5 || toType == 6 || toType == 7 || toType == 8 || toType == 9 || toType == 10 || toType == 4 || toType == 19 || ColumnType.isArray(toType));
    }

    private static boolean isStringCast(int fromType, int toType) {
        return fromType == 11 && toType == 12 || fromType == 12 && toType == 11 || fromType == 4 && toType == 12 || fromType == 4 && toType == 11 || fromType == 19 && toType == 11;
    }

    private static boolean isUndefinedArray(int columnType) {
        return ColumnType.tagOf(columnType) == 27 && ColumnType.decodeArrayElementType(columnType) == 0;
    }

    private static boolean isVarcharCast(int fromType, int toType) {
        return fromType == 11 && toType == 26 || fromType == 26 && toType == 12 || fromType == 26 && toType == 11 || fromType == 12 && toType == 26 || fromType == 4 && toType == 26 || fromType == 19 && toType == 26;
    }

    private static int mkGeoHashType(int bits, short baseType) {
        return baseType & 0xFFFF00FF | bits << 8 | 0x10000;
    }

    static {
        int i;
        ARRAY_DIM_SUFFIX = new String[33];
        TYPE_SIZE = new short[34];
        TYPE_SIZE_POW2 = new short[TYPE_SIZE.length];
        OVERLOAD_PRIORITY_N = (short)Math.pow(2.0, (double)Numbers.msb(33) + 1.0);
        OVERLOAD_PRIORITY_MATRIX = new int[OVERLOAD_PRIORITY_N * OVERLOAD_PRIORITY_N];
        arrayTypeSet = new IntHashSet();
        nameTypeMap = new LowerCaseAsciiCharSequenceIntHashMap();
        nonPersistedTypes = new IntHashSet();
        typeNameMap = new IntObjHashMap();
        OVERLOAD_PRIORITY = new short[][]{{10, 9, 11, 26, 6, 8, 7, 5, 4, 3, 2, 1}, {1}, {2, 3, 5, 6, 9, 10}, {3, 5, 6, 9, 10, 4}, {4, 11, 26, 3, 5, 6, 9, 10}, {5, 6, 9, 10, 8, 7}, {6, 10, 8, 7}, {7, 8, 6, 10}, {8, 6, 7, 10}, {9, 10}, {10}, {11, 26, 4, 10, 6, 5, 9, 3, 2, 8, 7, 12, 25}, {12, 11, 26, 4, 5, 8}, {13, 6}, {14, 15, 16, 17, 23}, {15, 16, 17, 23}, {16, 17, 23}, {17, 23}, {18}, {19, 11}, {20}, new short[0], new short[0], new short[0], {24}, {25, 11, 26}, {26, 11, 4, 10, 6, 5, 9, 3, 2, 8, 7, 12, 25}, {27}, new short[0], new short[0], new short[0], new short[0], {32, 11}, {26, 11, 10, 9, 6, 5}};
        for (int fromTag = 0; fromTag < 33; fromTag = (int)((short)(fromTag + 1))) {
            for (short toTag = 1; toTag <= 33; toTag = (short)(toTag + 1)) {
                int value = 10000;
                short[] priority = OVERLOAD_PRIORITY[fromTag];
                for (int i2 = 0; i2 < priority.length; i2 = (int)((short)(i2 + 1))) {
                    if (priority[i2] != toTag) continue;
                    value = i2;
                    break;
                }
                ColumnType.OVERLOAD_PRIORITY_MATRIX[ColumnType.OVERLOAD_PRIORITY_N * fromTag + toTag] = value;
            }
        }
        ColumnType.OVERLOAD_PRIORITY_MATRIX[ColumnType.OVERLOAD_PRIORITY_N * 33 + 11] = -1;
        ColumnType.OVERLOAD_PRIORITY_MATRIX[ColumnType.OVERLOAD_PRIORITY_N * 33 + 12] = -1;
        GEO_TYPE_SIZE_POW2 = new int[61];
        for (int bits = 1; bits <= 60; ++bits) {
            ColumnType.GEO_TYPE_SIZE_POW2[bits] = Numbers.msb(Numbers.ceilPow2(bits + 8 & 0xFFFFFFF8) >> 3);
        }
        typeNameMap.put(1, "BOOLEAN");
        typeNameMap.put(2, "BYTE");
        typeNameMap.put(10, "DOUBLE");
        typeNameMap.put(9, "FLOAT");
        typeNameMap.put(5, "INT");
        typeNameMap.put(6, "LONG");
        typeNameMap.put(3, "SHORT");
        typeNameMap.put(4, "CHAR");
        typeNameMap.put(11, "STRING");
        typeNameMap.put(26, "VARCHAR");
        typeNameMap.put(27, "ARRAY");
        typeNameMap.put(12, "SYMBOL");
        typeNameMap.put(18, "BINARY");
        typeNameMap.put(7, "DATE");
        typeNameMap.put(31, "PARAMETER");
        typeNameMap.put(8, "TIMESTAMP");
        typeNameMap.put(13, "LONG256");
        typeNameMap.put(19, "UUID");
        typeNameMap.put(24, "LONG128");
        typeNameMap.put(20, "CURSOR");
        typeNameMap.put(22, "RECORD");
        typeNameMap.put(21, "VARARG");
        typeNameMap.put(23, "GEOHASH");
        typeNameMap.put(28, "regclass");
        typeNameMap.put(29, "regprocedure");
        typeNameMap.put(30, "text[]");
        typeNameMap.put(25, "IPv4");
        typeNameMap.put(32, "INTERVAL");
        typeNameMap.put(33, "NULL");
        arrayTypeSet.add(10);
        nameTypeMap.put("boolean", 1);
        nameTypeMap.put("byte", 2);
        nameTypeMap.put("double", 10);
        nameTypeMap.put("float", 9);
        nameTypeMap.put("int", 5);
        nameTypeMap.put("integer", 5);
        nameTypeMap.put("long", 6);
        nameTypeMap.put("short", 3);
        nameTypeMap.put("char", 4);
        nameTypeMap.put("string", 11);
        nameTypeMap.put("varchar", 26);
        nameTypeMap.put("array", 27);
        nameTypeMap.put("symbol", 12);
        nameTypeMap.put("binary", 18);
        nameTypeMap.put("date", 7);
        nameTypeMap.put("parameter", 31);
        nameTypeMap.put("timestamp", 8);
        nameTypeMap.put("cursor", 20);
        nameTypeMap.put("long256", 13);
        nameTypeMap.put("uuid", 19);
        nameTypeMap.put("long128", 24);
        nameTypeMap.put("geohash", 23);
        nameTypeMap.put("text", 11);
        nameTypeMap.put("smallint", 3);
        nameTypeMap.put("bigint", 6);
        nameTypeMap.put("real", 9);
        nameTypeMap.put("bytea", 11);
        nameTypeMap.put("regclass", 28);
        nameTypeMap.put("regprocedure", 29);
        nameTypeMap.put("text[]", 30);
        nameTypeMap.put("IPv4", 25);
        nameTypeMap.put("interval", 32);
        StringSink sink = new StringSink();
        for (int b = 1; b <= 60; ++b) {
            sink.clear();
            if (b % 5 != 0) {
                ((Utf16Sink)sink.put("GEOHASH(").put(b)).put("b)");
            } else {
                ((Utf16Sink)sink.put("GEOHASH(").put(b / 5)).put("c)");
            }
            String name = sink.toString();
            int type = ColumnType.getGeoHashTypeWithBits(b);
            typeNameMap.put(type, name);
            nameTypeMap.put(name, type);
        }
        ColumnType.TYPE_SIZE_POW2[0] = -1;
        ColumnType.TYPE_SIZE_POW2[1] = 0;
        ColumnType.TYPE_SIZE_POW2[2] = 0;
        ColumnType.TYPE_SIZE_POW2[3] = 1;
        ColumnType.TYPE_SIZE_POW2[4] = 1;
        ColumnType.TYPE_SIZE_POW2[9] = 2;
        ColumnType.TYPE_SIZE_POW2[5] = 2;
        ColumnType.TYPE_SIZE_POW2[25] = 2;
        ColumnType.TYPE_SIZE_POW2[12] = 2;
        ColumnType.TYPE_SIZE_POW2[10] = 3;
        ColumnType.TYPE_SIZE_POW2[11] = -1;
        ColumnType.TYPE_SIZE_POW2[26] = -1;
        ColumnType.TYPE_SIZE_POW2[27] = -1;
        ColumnType.TYPE_SIZE_POW2[6] = 3;
        ColumnType.TYPE_SIZE_POW2[7] = 3;
        ColumnType.TYPE_SIZE_POW2[8] = 3;
        ColumnType.TYPE_SIZE_POW2[13] = 5;
        ColumnType.TYPE_SIZE_POW2[14] = 0;
        ColumnType.TYPE_SIZE_POW2[15] = 1;
        ColumnType.TYPE_SIZE_POW2[16] = 2;
        ColumnType.TYPE_SIZE_POW2[17] = 3;
        ColumnType.TYPE_SIZE_POW2[18] = -1;
        ColumnType.TYPE_SIZE_POW2[31] = -1;
        ColumnType.TYPE_SIZE_POW2[20] = -1;
        ColumnType.TYPE_SIZE_POW2[21] = -1;
        ColumnType.TYPE_SIZE_POW2[22] = -1;
        ColumnType.TYPE_SIZE_POW2[33] = -1;
        ColumnType.TYPE_SIZE_POW2[24] = 4;
        ColumnType.TYPE_SIZE_POW2[19] = 4;
        ColumnType.TYPE_SIZE_POW2[32] = 4;
        ColumnType.TYPE_SIZE[0] = -1;
        ColumnType.TYPE_SIZE[1] = 1;
        ColumnType.TYPE_SIZE[2] = 1;
        ColumnType.TYPE_SIZE[3] = 2;
        ColumnType.TYPE_SIZE[4] = 2;
        ColumnType.TYPE_SIZE[9] = 4;
        ColumnType.TYPE_SIZE[5] = 4;
        ColumnType.TYPE_SIZE[25] = 4;
        ColumnType.TYPE_SIZE[12] = 4;
        ColumnType.TYPE_SIZE[11] = 0;
        ColumnType.TYPE_SIZE[26] = 0;
        ColumnType.TYPE_SIZE[27] = 0;
        ColumnType.TYPE_SIZE[10] = 8;
        ColumnType.TYPE_SIZE[6] = 8;
        ColumnType.TYPE_SIZE[7] = 8;
        ColumnType.TYPE_SIZE[8] = 8;
        ColumnType.TYPE_SIZE[13] = 32;
        ColumnType.TYPE_SIZE[14] = 1;
        ColumnType.TYPE_SIZE[15] = 2;
        ColumnType.TYPE_SIZE[16] = 4;
        ColumnType.TYPE_SIZE[17] = 8;
        ColumnType.TYPE_SIZE[18] = 0;
        ColumnType.TYPE_SIZE[31] = -1;
        ColumnType.TYPE_SIZE[20] = -1;
        ColumnType.TYPE_SIZE[21] = -1;
        ColumnType.TYPE_SIZE[22] = -1;
        ColumnType.TYPE_SIZE[19] = 16;
        ColumnType.TYPE_SIZE[33] = 0;
        ColumnType.TYPE_SIZE[24] = 16;
        ColumnType.TYPE_SIZE[32] = 16;
        nonPersistedTypes.add(0);
        nonPersistedTypes.add(32);
        nonPersistedTypes.add(31);
        nonPersistedTypes.add(20);
        nonPersistedTypes.add(21);
        nonPersistedTypes.add(22);
        nonPersistedTypes.add(33);
        nonPersistedTypes.add(28);
        nonPersistedTypes.add(29);
        nonPersistedTypes.add(30);
        int n = arrayTypeSet.size();
        for (i = 0; i < n; ++i) {
            short type = (short)arrayTypeSet.get(i);
            sink.clear();
            sink.put(ColumnType.nameOf(type));
            for (int d = 1; d <= 32; ++d) {
                sink.put("[]");
                int arrayType = ColumnType.encodeArrayType(type, d);
                String name = sink.toString();
                typeNameMap.put(arrayType, name);
                nameTypeMap.put(name, arrayType);
            }
        }
        sink.clear();
        n = 33;
        for (i = 0; i < n; ++i) {
            ColumnType.ARRAY_DIM_SUFFIX[i] = sink.toString();
            sink.put("[]");
        }
    }
}

