/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Job;
import io.questdb.std.DirectLongList;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Vect;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import io.questdb.tasks.O3PartitionPurgeTask;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;

public class O3PartitionPurgeJob
extends AbstractQueueConsumerJob<O3PartitionPurgeTask>
implements Closeable {
    private static final Log LOG = LogFactory.getLog(O3PartitionPurgeJob.class);
    private final CairoConfiguration configuration;
    private final CairoEngine engine;
    private final Utf8StringSink[] fileNameSinks;
    private final AtomicBoolean halted = new AtomicBoolean(false);
    private final ObjList<DirectLongList> partitionList;
    private final ObjList<TxReader> txnReaders;

    public O3PartitionPurgeJob(CairoEngine engine, int workerCount) {
        super(engine.getMessageBus().getO3PurgeDiscoveryQueue(), engine.getMessageBus().getO3PurgeDiscoverySubSeq());
        try {
            this.engine = engine;
            this.configuration = engine.getMessageBus().getConfiguration();
            this.fileNameSinks = new Utf8StringSink[workerCount];
            this.partitionList = new ObjList(workerCount);
            this.txnReaders = new ObjList(workerCount);
            for (int i = 0; i < workerCount; ++i) {
                this.fileNameSinks[i] = new Utf8StringSink();
                this.partitionList.add(new DirectLongList((long)this.configuration.getPartitionPurgeListCapacity() * 2L, 45));
                this.txnReaders.add(new TxReader(this.configuration.getFilesFacade()));
            }
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void close() {
        if (this.halted.compareAndSet(false, true)) {
            Misc.freeObjList(this.partitionList);
            Misc.freeObjList(this.txnReaders);
        }
    }

    private static void parsePartitionDateVersion(Utf8StringSink fileNameSink, DirectLongList partitionList, CharSequence tableName, DateFormat partitionByFormat) {
        int index = Utf8s.lastIndexOfAscii(fileNameSink, '.');
        int len = fileNameSink.size();
        if (index < 0) {
            index = len;
        }
        try {
            if (index < len) {
                long partitionVersion = Numbers.parseLong(fileNameSink, index + 1, len);
                partitionList.add(partitionVersion + 1L);
            } else {
                partitionList.add(0L);
            }
            try {
                long partitionTs = partitionByFormat.parse(fileNameSink.asAsciiCharSequence(), 0, index, DateFormatUtils.EN_LOCALE);
                partitionList.add(partitionTs);
            }
            catch (NumericException e) {
                if (!(Utf8s.startsWithAscii(fileNameSink, "wal") || Utf8s.equalsAscii("txn_seq", fileNameSink) || Utf8s.equalsAscii("seq", fileNameSink))) {
                    LOG.info().$("unknown directory [table=").$safe(tableName).$(", dir=").$(fileNameSink).I$();
                }
                partitionList.setPos(partitionList.size() - 1L);
            }
        }
        catch (NumericException e) {
            LOG.error().$("unknown directory [table=").$safe(tableName).$(", dir=").$(fileNameSink).I$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverPartitions(FilesFacade ff, Utf8StringSink fileNameSink, DirectLongList partitionList, CharSequence root, TableToken tableToken, TxReader txReader, int partitionBy) {
        LOG.info().$("processing [table=").$(tableToken).I$();
        Path path = Path.getThreadLocal(root).concat(tableToken);
        int plimit = path.size();
        partitionList.clear();
        DateFormat partitionByFormat = PartitionBy.getPartitionDirFormatMethod(partitionBy);
        long p = ff.findFirst(path.$());
        if (p > 0L) {
            try {
                do {
                    if (!ff.isDirOrSoftLinkDirNoDots(path, plimit, ff.findName(p), ff.findType(p), fileNameSink)) continue;
                    O3PartitionPurgeJob.parsePartitionDateVersion(fileNameSink, partitionList, tableToken.getDirName(), partitionByFormat);
                    path.trimTo(plimit).$();
                } while (ff.findNext(p) > 0);
            }
            finally {
                ff.findClose(p);
            }
        }
        assert (partitionList.size() % 2L == 0L);
        Vect.sort128BitAscInPlace(partitionList.getAddress(), partitionList.size() / 2L);
        long partitionTimestamp = Long.MIN_VALUE;
        int lo = 0;
        int n = (int)partitionList.size();
        path.of(root).concat(tableToken);
        int tableRootLen = path.size();
        TxnScoreboard txnScoreboard = null;
        try {
            txnScoreboard = this.engine.getTxnScoreboard(tableToken);
            txReader.ofRO(path.trimTo(tableRootLen).concat("_txn").$(), partitionBy);
            TableUtils.safeReadTxn(txReader, this.configuration.getMillisecondClock(), this.configuration.getSpinLockTimeout());
            for (int i = 0; i < n; i += 2) {
                long currentPartitionTs = partitionList.get(i + 1);
                if (currentPartitionTs == partitionTimestamp) continue;
                if (i > lo + 2 || i > 0 && txReader.findAttachedPartitionRawIndexByLoTimestamp(partitionTimestamp) < 0) {
                    this.processPartition(tableToken, ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, i);
                }
                lo = i;
                partitionTimestamp = currentPartitionTs;
            }
            if (n > lo + 2 || txReader.getPartitionRowCountByTimestamp(partitionTimestamp) < 0L) {
                this.processPartition(tableToken, ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, n);
            }
        }
        catch (TableReferenceOutOfDateException e) {
            LOG.info().$("table reference out of date, aborting [table=").$(tableToken).I$();
        }
        catch (CairoException ex) {
            LOG.error().$("could not purge partition open [table=`").$(tableToken).$("`, msg=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            LOG.error().$safe(ex.getFlyweightMessage()).$();
        }
        finally {
            txReader.clear();
            Misc.free(txnScoreboard);
        }
        LOG.info().$("processed [table=").$(tableToken).I$();
    }

    private void processDetachedPartition(TableToken tableToken, FilesFacade ff, Path path, int tableRootLen, TxReader txReader, TxnScoreboard txnScoreboard, long partitionTimestamp, int partitionBy, DirectLongList partitionList, int lo, int hi) {
        long lastTxn = txReader.getTxn();
        int n = lo - 1;
        for (int i = hi - 2; i > n; i -= 2) {
            long nameTxn = partitionList.get(i);
            boolean rangeUnlocked = nameTxn < lastTxn && txnScoreboard.isRangeAvailable(nameTxn, lastTxn);
            path.trimTo(tableRootLen);
            TableUtils.setPathForNativePartition(path, partitionBy, partitionTimestamp, nameTxn - 1L);
            path.$();
            if (!rangeUnlocked) {
                LOG.debug().$("cannot purge partition directory, locked for reading [path=").$substr(tableRootLen - tableToken.getDirNameUtf8().size() - 1, path).I$();
                break;
            }
            this.purgePartition(tableToken, ff, path, tableRootLen - tableToken.getDirNameUtf8().size() - 1, "purging dropped partition directory [path=");
            lastTxn = nameTxn;
        }
    }

    private void processPartition(TableToken tableToken, FilesFacade ff, Path path, int tableRootLen, TxReader txReader, TxnScoreboard txnScoreboard, long partitionTimestamp, int partitionBy, DirectLongList partitionList, int lo, int hi) {
        boolean partitionInTxnFile;
        boolean bl = partitionInTxnFile = txReader.findAttachedPartitionRawIndexByLoTimestamp(partitionTimestamp) >= 0;
        if (partitionInTxnFile) {
            this.processPartition0(tableToken, ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, hi);
        } else {
            this.processDetachedPartition(tableToken, ff, path, tableRootLen, txReader, txnScoreboard, partitionTimestamp, partitionBy, partitionList, lo, hi);
        }
    }

    private void processPartition0(TableToken tableToken, FilesFacade ff, Path path, int tableRootLen, TxReader txReader, TxnScoreboard txnScoreboard, long partitionTimestamp, int partitionBy, DirectLongList partitionList, int lo, int hi) {
        long lastCommittedPartitionName = txReader.getPartitionNameTxnByPartitionTimestamp(partitionTimestamp);
        if (lastCommittedPartitionName > -1L) {
            assert ((long)hi <= partitionList.size());
            for (int i = lo + 2; i < hi; i += 2) {
                long nextNameVersion = Math.min(lastCommittedPartitionName + 1L, partitionList.get(i));
                long previousNameVersion = partitionList.get(i - 2);
                boolean rangeUnlocked = previousNameVersion < nextNameVersion && txnScoreboard.isRangeAvailable(previousNameVersion, nextNameVersion);
                path.trimTo(tableRootLen);
                TableUtils.setPathForNativePartition(path, partitionBy, partitionTimestamp, previousNameVersion - 1L);
                path.$();
                if (rangeUnlocked) {
                    this.engine.getPartitionOverwriteControl().notifyPartitionMutates(tableToken, partitionTimestamp, previousNameVersion - 1L, 0L);
                    this.purgePartition(tableToken, ff, path, tableRootLen - tableToken.getDirNameUtf8().size() - 1, "purging overwritten partition directory [path=");
                    continue;
                }
                LOG.info().$("cannot purge overwritten partition directory, locked for reading path=").$substr(tableRootLen - tableToken.getDirNameUtf8().size() - 1, path).I$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgePartition(TableToken tableToken, FilesFacade ff, Path path, int pathFrom, String message) {
        block5: {
            if (this.engine.lockTableCreate(tableToken)) {
                try {
                    TableToken lastToken = this.engine.getUpdatedTableToken(tableToken);
                    if (lastToken == tableToken) {
                        LOG.info().$(message).$substr(pathFrom, path).I$();
                        ff.unlinkOrRemove(path, LOG);
                        break block5;
                    }
                    throw new TableReferenceOutOfDateException();
                }
                finally {
                    this.engine.unlockTableCreate(tableToken);
                }
            }
            throw new TableReferenceOutOfDateException();
        }
    }

    @Override
    protected boolean canRun() {
        return !this.engine.getCheckpointStatus().partitionsLocked();
    }

    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        O3PartitionPurgeTask task = (O3PartitionPurgeTask)this.queue.get(cursor);
        this.discoverPartitions(this.configuration.getFilesFacade(), this.fileNameSinks[workerId], this.partitionList.get(workerId), this.configuration.getDbRoot(), task.getTableToken(), this.txnReaders.get(workerId), task.getPartitionBy());
        this.subSeq.done(cursor);
        return true;
    }
}

