/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.ArrayWriteState;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.arr.NoopArrayWriteState;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryOM;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.FilesFacade;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayTypeDriver
implements ColumnTypeDriver {
    public static final int ARRAY_AUX_WIDTH_BYTES = 16;
    public static final ArrayTypeDriver INSTANCE = new ArrayTypeDriver();
    public static final long OFFSET_MAX = 0xFFFFFFFFFFFFL;
    private static final ArrayValueAppender VALUE_APPENDER_DOUBLE = ArrayTypeDriver::appendDoubleFromArrayToSink;
    private static final ArrayValueAppender VALUE_APPENDER_LONG = ArrayTypeDriver::appendLongFromArrayToSink;

    public static void appendDoubleFromArrayToSink(@NotNull ArrayView array, int index, @NotNull CharSink<?> sink, @NotNull String nullLiteral) {
        double d = array.getDouble(index);
        if (Numbers.isFinite(d)) {
            sink.put(d);
        } else {
            sink.put(nullLiteral);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long appendPlainValue(long appendAddress, ArrayView value) {
        long startAddress = appendAddress;
        if (value == null || value.isNull()) {
            Unsafe.getUnsafe().putLong(appendAddress, -1L);
            return 8L;
        }
        Unsafe.getUnsafe().putLong(appendAddress, value.getVanillaMemoryLayoutSize());
        Unsafe.getUnsafe().putInt(appendAddress += 8L, value.getType());
        appendAddress += 4L;
        int nDims = value.getDimCount();
        for (int i = 0; i < nDims; ++i) {
            Unsafe.getUnsafe().putInt(appendAddress, value.getDimLen(i));
            appendAddress += 4L;
        }
        if (value.isVanilla()) {
            short elemType = value.getElemType();
            if (elemType != 10) throw new UnsupportedOperationException("Unsupported array element type: " + elemType);
            appendAddress = value.flatView().appendPlainDoubleValue(appendAddress, value.getFlatViewOffset(), value.getFlatViewLength());
        } else {
            appendAddress = ArrayTypeDriver.appendToMemRecursive(value, 0, 0, appendAddress);
        }
        long bytesWritten = appendAddress - startAddress;
        assert (bytesWritten > 0L);
        return bytesWritten;
    }

    public static void appendValue(@NotNull MemoryA auxMem, @NotNull MemoryA dataMem, @NotNull ArrayView array) {
        if (array.isNull()) {
            ArrayTypeDriver.appendNullImpl(auxMem, dataMem);
            return;
        }
        long beginOffset = dataMem.getAppendOffset();
        ArrayTypeDriver.writeDataEntry(dataMem, array);
        long endOffset = dataMem.getAppendOffset();
        int size = (int)(endOffset - beginOffset);
        ArrayTypeDriver.writeAuxEntry(auxMem, beginOffset, size);
    }

    public static void arrayToJson(@NotNull ArrayView array, @NotNull CharSink<?> sink, @NotNull ArrayValueAppender appender, ArrayWriteState arrayState) {
        ArrayTypeDriver.arrayToText(array, sink, appender, '[', ']', "null", arrayState);
    }

    public static void arrayToJson(@Nullable ArrayView arrayView, @NotNull CharSink<?> sink, @NotNull ArrayWriteState arrayState) {
        if (arrayView == null) {
            sink.put("null");
        } else {
            ArrayTypeDriver.arrayToJson(arrayView, sink, ArrayTypeDriver.resolveAppender(arrayView), arrayState);
        }
    }

    public static void arrayToPgWire(@NotNull ArrayView arrayView, @NotNull CharSink<?> sink) {
        ArrayTypeDriver.arrayToText(arrayView, sink, ArrayTypeDriver.resolveAppender(arrayView), '{', '}', "NULL", NoopArrayWriteState.INSTANCE);
    }

    public static void arrayToText(@NotNull ArrayView array, @NotNull CharSink<?> sink, @NotNull ArrayValueAppender appender, char openChar, char closeChar, @NotNull String nullLiteral, ArrayWriteState arrayState) {
        if (array.isNull()) {
            sink.putAscii(nullLiteral);
            return;
        }
        if (array.isEmpty()) {
            sink.put(openChar).put(closeChar);
            return;
        }
        ArrayTypeDriver.arrayToText(array, 0, 0, sink, appender, openChar, closeChar, nullLiteral, arrayState);
    }

    public static int bytesToSkipForAlignment(long unaligned, int byteAlignment) {
        int pastBy = (int)(unaligned % (long)byteAlignment);
        if (pastBy == 0) {
            return 0;
        }
        return byteAlignment - pastBy;
    }

    public static long getAuxVectorOffsetStatic(long row) {
        return 16L * row;
    }

    public static BorrowedArray getPlainValue(long addr, @NotNull BorrowedArray value) {
        long totalSize = Unsafe.getUnsafe().getLong(addr);
        addr += 8L;
        if (totalSize <= 0L) {
            value.ofNull();
            return value;
        }
        int type = Unsafe.getUnsafe().getInt(addr);
        int nDims = ColumnType.decodeArrayDimensionality(type);
        int shapeLen = nDims * 4;
        int headerLen = 4 + shapeLen;
        value.of(type, addr += 4L, addr + (long)shapeLen, (int)(totalSize - (long)headerLen));
        return value;
    }

    public static long getPlainValueSize(long arrayAddress) {
        return 8L + Unsafe.getUnsafe().getLong(arrayAddress);
    }

    public static long getPlainValueSize(@NotNull ArrayView value) {
        return 8L + value.getVanillaMemoryLayoutSize();
    }

    @Override
    public void appendNull(MemoryA auxMem, MemoryA dataMem) {
        ArrayTypeDriver.appendNullImpl(auxMem, dataMem);
    }

    @Override
    public long auxRowsToBytes(long rowCount) {
        return 16L * rowCount;
    }

    @Override
    public void configureAuxMemMA(MemoryMA auxMem) {
    }

    @Override
    public void configureAuxMemMA(FilesFacade ff, MemoryMA auxMem, LPSZ fileName, long dataAppendPageSize, int memoryTag, int opts, int madviseOpts) {
        auxMem.of(ff, fileName, dataAppendPageSize, -1L, 12, opts, madviseOpts);
    }

    @Override
    public void configureAuxMemO3RSS(MemoryARW auxMem) {
    }

    @Override
    public void configureAuxMemOM(FilesFacade ff, MemoryOM auxMem, long fd, LPSZ fileName, long rowLo, long rowHi, int memoryTag, int opts) {
        auxMem.ofOffset(ff, fd, false, fileName, 16L * rowLo, 16L * rowHi, memoryTag, opts);
    }

    @Override
    public void configureDataMemOM(FilesFacade ff, MemoryR auxMem, MemoryOM dataMem, long dataFd, LPSZ fileName, long rowLo, long rowHi, int memoryTag, int opts) {
        long lo = rowLo > 0L ? ArrayTypeDriver.readDataOffset(auxMem, 16L * rowLo) : 0L;
        long hi = rowHi > 0L ? this.calcDataOffsetEnd(auxMem, 16L * (rowHi - 1L)) : 0L;
        dataMem.ofOffset(ff, dataFd, false, fileName, lo, hi, memoryTag, opts);
    }

    @Override
    public long dedupMergeVarColumnSize(long mergeIndexAddr, long mergeIndexCount, long srcDataFixAddr, long srcOooFixAddr) {
        return Vect.dedupMergeArrayColumnSize(mergeIndexAddr, mergeIndexCount, srcDataFixAddr, srcOooFixAddr);
    }

    @Override
    public long getAuxVectorOffset(long row) {
        return ArrayTypeDriver.getAuxVectorOffsetStatic(row);
    }

    @Override
    public long getAuxVectorSize(long storageRowCount) {
        return 16L * storageRowCount;
    }

    @Override
    public long getDataVectorMinEntrySize() {
        return 0L;
    }

    @Override
    public long getDataVectorOffset(long auxMemAddr, long row) {
        long auxEntry = auxMemAddr + 16L * row;
        return ArrayTypeDriver.readDataOffset(auxEntry);
    }

    @Override
    public long getDataVectorSize(long auxMemAddr, long rowLo, long rowHi) {
        if (rowLo > rowHi) {
            return 0L;
        }
        if (rowLo > 0L) {
            return this.getDataVectorSizeAt(auxMemAddr, rowHi) - this.getDataVectorOffset(auxMemAddr, rowLo);
        }
        return this.getDataVectorSizeAt(auxMemAddr, rowHi);
    }

    @Override
    public long getDataVectorSizeAt(long auxMemAddr, long row) {
        return this.calcDataOffsetEnd(auxMemAddr + 16L * row);
    }

    @Override
    public long getDataVectorSizeAtFromFd(FilesFacade ff, long auxFd, long row) {
        if (row < 0L) {
            return 0L;
        }
        long auxFileOffset = 16L * row;
        long offset = ArrayTypeDriver.readLong(ff, auxFd, auxFileOffset) & 0xFFFFFFFFFFFFL;
        int size = ArrayTypeDriver.readInt(ff, auxFd, auxFileOffset + 8L);
        return offset + (long)size;
    }

    @Override
    public long getMinAuxVectorSize() {
        return 0L;
    }

    @Override
    public boolean isSparseDataVector(long auxMemAddr, long dataMemAddr, long rowCount) {
        long lastSizeInDataVector = 0L;
        int row = 0;
        while ((long)row < rowCount) {
            long offset = this.getDataVectorOffset(auxMemAddr, row);
            if (offset != lastSizeInDataVector) {
                return true;
            }
            lastSizeInDataVector = this.getDataVectorSizeAt(auxMemAddr, row);
            ++row;
        }
        return false;
    }

    @Override
    public long mergeShuffleColumnFromManyAddresses(long indexFormat, long primaryAddressList, long secondaryAddressList, long outPrimaryAddress, long outSecondaryAddress, long mergeIndex, long destDataOffset, long destDataSize) {
        return Vect.mergeShuffleArrayColumnFromManyAddresses(indexFormat, primaryAddressList, secondaryAddressList, outPrimaryAddress, outSecondaryAddress, mergeIndex, destDataOffset, destDataSize);
    }

    @Override
    public void o3ColumnMerge(long timestampMergeIndexAddr, long timestampMergeIndexCount, long srcAuxAddr1, long srcDataAddr1, long srcAuxAddr2, long srcDataAddr2, long dstAuxAddr, long dstDataAddr, long dstDataOffset) {
        Vect.oooMergeCopyArrayColumn(timestampMergeIndexAddr, timestampMergeIndexCount, srcAuxAddr1, srcDataAddr1, srcAuxAddr2, srcDataAddr2, dstAuxAddr, dstDataAddr, dstDataOffset);
    }

    @Override
    public void o3copyAuxVector(FilesFacade ff, long srcAddr, long srcLo, long srcHi, long dstAddr, long dstFileOffset, long dstFd, boolean mixedIOFlag) {
        O3Utils.o3Copy(ff, dstAddr, dstFileOffset, dstFd, srcAddr + srcLo * 16L, (srcHi - srcLo + 1L) * 16L, mixedIOFlag);
    }

    @Override
    public void o3sort(long sortedTimestampsAddr, long sortedTimestampsRowCount, MemoryCR srcDataMem, MemoryCR srcAuxMem, MemoryCARW dstDataMem, MemoryCARW dstAuxMem) {
        long srcDataAddr = srcDataMem.addressOf(0L);
        long srcAuxAddr = srcAuxMem.addressOf(0L);
        long tgtAuxAddr = dstAuxMem.resize(this.getAuxVectorSize(sortedTimestampsRowCount));
        long tgtDataAddr = dstDataMem.resize(this.getDataVectorSizeAt(srcAuxAddr, sortedTimestampsRowCount - 1L));
        assert (srcAuxAddr != 0L);
        assert (tgtAuxAddr != 0L);
        long offset = Vect.sortArrayColumn(sortedTimestampsAddr, sortedTimestampsRowCount, srcDataAddr, srcAuxAddr, tgtDataAddr, tgtAuxAddr);
        dstDataMem.jumpTo(offset);
        dstAuxMem.jumpTo(16L * sortedTimestampsRowCount);
    }

    @Override
    public long setAppendAuxMemAppendPosition(MemoryMA auxMem, MemoryMA dataMem, int columnType, long rowCount) {
        if (rowCount == 0L) {
            auxMem.jumpTo(0L);
            return 0L;
        }
        auxMem.jumpTo(16L * (rowCount - 1L));
        long nextDataMemOffset = this.calcDataOffsetEnd(auxMem.getAppendAddress());
        auxMem.jumpTo(16L * rowCount);
        return nextDataMemOffset;
    }

    @Override
    public long setAppendPosition(long pos, MemoryMA auxMem, MemoryMA dataMem) {
        if (pos > 0L) {
            long auxVectorOffset = this.getAuxVectorOffset(pos - 1L);
            auxMem.jumpTo(auxVectorOffset);
            long auxEntryPtr = auxMem.getAppendAddress();
            long dataVectorSize = this.calcDataOffsetEnd(auxEntryPtr);
            long auxVectorSize = this.getAuxVectorSize(pos);
            long totalDataSizeBytes = dataVectorSize + auxVectorSize;
            auxVectorOffset = this.getAuxVectorOffset(pos);
            auxMem.jumpTo(auxVectorOffset);
            dataMem.jumpTo(dataVectorSize);
            return totalDataSizeBytes;
        }
        dataMem.jumpTo(0L);
        auxMem.jumpTo(0L);
        return 0L;
    }

    @Override
    public void setDataVectorEntriesToNull(long dataMemAddr, long rowCount) {
    }

    @Override
    public void setFullAuxVectorNull(long auxMemAddr, long rowCount) {
        Vect.setArrayColumnNullRefs(auxMemAddr, 0L, rowCount);
    }

    @Override
    public void setPartAuxVectorNull(long auxMemAddr, long initialOffset, long columnTop) {
        Vect.setArrayColumnNullRefs(auxMemAddr, initialOffset, columnTop);
    }

    @Override
    public void shiftCopyAuxVector(long shift, long srcAddr, long srcLo, long srcHi, long dstAddr, long dstAddrSize) {
        assert ((srcHi - srcLo + 1L) * 16L <= dstAddrSize);
        Vect.shiftCopyArrayColumnAux(shift, srcAddr, srcLo, srcHi, dstAddr);
    }

    private static void appendNullImpl(MemoryA auxMem, long offset) {
        assert (auxMem != null);
        assert (offset >= 0L);
        assert (offset < 0xFFFFFFFFFFFFL);
        auxMem.putLong(offset);
        auxMem.putLong(0L);
    }

    private static void appendNullImpl(MemoryA auxMem, MemoryA dataMem) {
        long offset = dataMem.getAppendOffset();
        ArrayTypeDriver.appendNullImpl(auxMem, offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long appendToMemRecursive(@NotNull ArrayView value, int dim, int flatIndex, long appendAddress) {
        boolean atDeepestDim;
        short elemType = value.getElemType();
        assert (elemType == 10 || elemType == 6) : "implemented only for long and double";
        int count = value.getDimLen(dim);
        int stride = value.getStride(dim);
        boolean bl = atDeepestDim = dim == value.getDimCount() - 1;
        if (atDeepestDim) {
            if (elemType != 10) throw new UnsupportedOperationException("Unsupported array element type: " + elemType);
            for (int i = 0; i < count; ++i) {
                Unsafe.getUnsafe().putDouble(appendAddress, value.getDouble(flatIndex));
                appendAddress += 8L;
                flatIndex += stride;
            }
            return appendAddress;
        } else {
            for (int i = 0; i < count; ++i) {
                appendAddress = ArrayTypeDriver.appendToMemRecursive(value, dim + 1, flatIndex, appendAddress);
                flatIndex += stride;
            }
        }
        return appendAddress;
    }

    private static void arrayToText(@NotNull ArrayView array, int dim, int flatIndex, @NotNull CharSink<?> sink, @NotNull ArrayValueAppender appender, char openChar, char closeChar, @NotNull String nullLiteral, ArrayWriteState writeState) {
        int count = array.getDimLen(dim);
        int stride = array.getStride(dim);
        boolean atDeepestDim = dim == array.getDimCount() - 1;
        writeState.putCharIfNew(sink, openChar);
        if (atDeepestDim) {
            for (int i = 0; i < count; ++i) {
                if (i != 0) {
                    writeState.putCharIfNew(sink, ',');
                }
                if (writeState.incAndSayIfNewOp()) {
                    appender.appendItemAtFlatIndex(array, flatIndex, sink, nullLiteral);
                    flatIndex += stride;
                    writeState.performedOp();
                    continue;
                }
                flatIndex += stride;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (i != 0) {
                    writeState.putCharIfNew(sink, ',');
                }
                ArrayTypeDriver.arrayToText(array, dim + 1, flatIndex, sink, appender, openChar, closeChar, nullLiteral, writeState);
                flatIndex += stride;
            }
        }
        writeState.putCharIfNew(sink, closeChar);
    }

    private static void padTo(@NotNull MemoryA dataMem, int byteAlignment) {
        dataMem.zeroMem(ArrayTypeDriver.bytesToSkipForAlignment(dataMem.getAppendOffset(), byteAlignment));
    }

    private static long readDataOffset(MemoryR auxMem, long offset) {
        return auxMem.getLong(offset) & 0xFFFFFFFFFFFFL;
    }

    private static long readDataOffset(long auxEntryAddress) {
        return Unsafe.getUnsafe().getLong(auxEntryAddress) & 0xFFFFFFFFFFFFL;
    }

    private static int readInt(FilesFacade ff, long fd, long offset) {
        long res = ff.readIntAsUnsignedLong(fd, offset);
        if (res < 0L) {
            throw CairoException.critical(ff.errno()).put("Invalid data read from array aux file [fd=").put(fd).put(", offset=").put(offset).put(", fileSize=").put(ff.length(fd)).put(", result=").put(res).put(']');
        }
        return Numbers.decodeLowInt(res);
    }

    private static long readLong(FilesFacade ff, long fd, long offset) {
        long res = ff.readNonNegativeLong(fd, offset);
        if (res < 0L) {
            throw CairoException.critical(ff.errno()).put("Invalid data read from array aux file [fd=").put(fd).put(", offset=").put(offset).put(", fileSize=").put(ff.length(fd)).put(", result=").put(res).put(']');
        }
        return res;
    }

    @NotNull
    private static ArrayValueAppender resolveAppender(@NotNull ArrayView array) {
        short elemType = array.getElemType();
        switch (elemType) {
            case 10: {
                return VALUE_APPENDER_DOUBLE;
            }
            case 6: 
            case 33: {
                return VALUE_APPENDER_LONG;
            }
        }
        if (array.isEmpty()) {
            return VALUE_APPENDER_LONG;
        }
        throw new AssertionError((Object)("No appender for ColumnType " + elemType));
    }

    private static void writeAuxEntry(MemoryA auxMem, long offset, int size) {
        assert (offset >= 0L);
        assert (offset <= 0xFFFFFFFFFFFFL);
        assert (size >= 0);
        auxMem.putLong(offset);
        auxMem.putLong(size);
    }

    private static void writeDataEntry(@NotNull MemoryA dataMem, @NotNull ArrayView array) {
        ArrayTypeDriver.writeShape(dataMem, array);
        int requiredByteAlignment = ColumnType.sizeOf(array.getElemType());
        ArrayTypeDriver.padTo(dataMem, requiredByteAlignment);
        array.appendDataToMem(dataMem);
        ArrayTypeDriver.padTo(dataMem, 4);
    }

    private static void writeShape(@NotNull MemoryA dataMem, @NotNull ArrayView array) {
        assert (dataMem.getAppendOffset() % 4L == 0L);
        array.appendShapeToMem(dataMem);
    }

    private long calcDataOffsetEnd(long auxAddr) {
        long offset = Unsafe.getUnsafe().getLong(auxAddr) & 0xFFFFFFFFFFFFL;
        int size = Unsafe.getUnsafe().getInt(auxAddr + 8L);
        return offset + (long)size;
    }

    private long calcDataOffsetEnd(@NotNull MemoryR mem, long auxOffset) {
        long offset = mem.getLong(auxOffset) & 0xFFFFFFFFFFFFL;
        int size = mem.getInt(auxOffset + 8L);
        return offset + (long)size;
    }

    static void appendLongFromArrayToSink(@NotNull ArrayView array, int index, @NotNull CharSink<?> sink, @NotNull String nullLiteral) {
        long d = array.getLong(index);
        if (d == Long.MIN_VALUE) {
            sink.put(nullLiteral);
        } else {
            sink.put(d);
        }
    }

    @FunctionalInterface
    public static interface ArrayValueAppender {
        public void appendItemAtFlatIndex(@NotNull ArrayView var1, int var2, @NotNull CharSink<?> var3, @NotNull String var4);
    }
}

