/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.metrics.Counter;
import io.questdb.metrics.LongGauge;
import io.questdb.metrics.MetricsRegistry;
import io.questdb.std.Mutable;
import java.util.concurrent.atomic.AtomicLong;

public class WalMetrics
implements Mutable {
    private final Counter applyPhysicallyWrittenRowsCounter;
    private final LongGauge applyRowsWriteRateGauge;
    private final Counter applyRowsWrittenCounter;
    private final Counter rowsWrittenCounter;
    private final LongGauge seqTxnGauge;
    private final AtomicLong totalRowsWritten = new AtomicLong();
    private final AtomicLong totalRowsWrittenTotalTime = new AtomicLong();
    private final LongGauge writerTxnGauge;

    public WalMetrics(MetricsRegistry metricsRegistry) {
        this.applyPhysicallyWrittenRowsCounter = metricsRegistry.newCounter("wal_apply_physically_written_rows");
        this.applyRowsWriteRateGauge = metricsRegistry.newLongGauge("wal_apply_rows_per_second");
        this.applyRowsWrittenCounter = metricsRegistry.newCounter("wal_apply_written_rows");
        this.rowsWrittenCounter = metricsRegistry.newCounter("wal_written_rows");
        this.seqTxnGauge = metricsRegistry.newAtomicLongGauge("wal_apply_seq_txn");
        this.writerTxnGauge = metricsRegistry.newAtomicLongGauge("wal_apply_writer_txn");
    }

    public void addApplyRowsWritten(long rows, long physicallyWrittenRows, long timeMicros) {
        this.applyRowsWrittenCounter.add(rows);
        this.applyPhysicallyWrittenRowsCounter.add(physicallyWrittenRows);
        long totalRows = this.totalRowsWritten.addAndGet(rows);
        long rowsAppendRate = totalRows * 1000000L / Math.max(1L, this.totalRowsWrittenTotalTime.addAndGet(timeMicros));
        this.applyRowsWriteRateGauge.setValue(rowsAppendRate);
    }

    public void addRowsWritten(long rows) {
        this.rowsWrittenCounter.add(rows);
    }

    public void addSeqTxn(long txnDelta) {
        this.seqTxnGauge.add(txnDelta);
    }

    public void addWriterTxn(long txnDelta) {
        this.writerTxnGauge.add(txnDelta);
    }

    @Override
    public void clear() {
        this.applyPhysicallyWrittenRowsCounter.reset();
        this.applyRowsWriteRateGauge.setValue(0L);
        this.applyRowsWrittenCounter.reset();
        this.rowsWrittenCounter.reset();
        this.seqTxnGauge.setValue(0L);
        this.totalRowsWritten.set(0L);
        this.totalRowsWrittenTotalTime.set(0L);
        this.writerTxnGauge.setValue(0L);
    }
}

