/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.client;

import io.questdb.HttpClientConfiguration;
import io.questdb.cutlass.http.client.HttpClient;
import io.questdb.network.FDSet;
import io.questdb.network.SelectFacade;
import io.questdb.network.SocketFactory;
import io.questdb.std.Misc;

public class HttpClientWindows
extends HttpClient {
    private final SelectFacade sf;
    private FDSet fdSet;

    public HttpClientWindows(HttpClientConfiguration configuration, SocketFactory socketFactory) {
        super(configuration, socketFactory);
        this.fdSet = new FDSet(configuration.getWaitQueueCapacity());
        this.sf = configuration.getSelectFacade();
    }

    @Override
    public void close() {
        super.close();
        this.fdSet = Misc.free(this.fdSet);
    }

    @Override
    protected void ioWait(int timeout, int op) {
        long writeAddr;
        long readAddr;
        this.fdSet.clear();
        this.fdSet.add(this.socket.getFd());
        this.fdSet.setCount(1);
        if (op == 1) {
            readAddr = this.fdSet.address();
            writeAddr = 0L;
        } else {
            readAddr = 0L;
            writeAddr = this.fdSet.address();
        }
        this.dieWaiting(this.sf.select(readAddr, writeAddr, 0L, timeout));
    }

    @Override
    protected void setupIoWait() {
    }
}

