/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line;

import io.questdb.client.Sender;
import io.questdb.cutlass.line.AbstractLineSender;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.cutlass.line.array.DoubleArray;
import io.questdb.cutlass.line.array.LongArray;
import io.questdb.cutlass.line.udp.UdpLineChannel;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.std.datetime.microtime.Timestamps;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.jetbrains.annotations.NotNull;

public class LineUdpSender
extends AbstractLineSender {
    public LineUdpSender(int interfaceIPv4Address, int sendToIPv4Address, int sendToPort, int bufferCapacity, int ttl) {
        this(NetworkFacadeImpl.INSTANCE, interfaceIPv4Address, sendToIPv4Address, sendToPort, bufferCapacity, ttl);
    }

    public LineUdpSender(NetworkFacade nf, int interfaceIPv4Address, int sendToIPv4Address, int sendToPort, int capacity, int ttl) {
        super(new UdpLineChannel(nf, interfaceIPv4Address, sendToIPv4Address, sendToPort, ttl), capacity, Integer.MAX_VALUE);
    }

    @Override
    public final void at(long timestamp, ChronoUnit unit) {
        this.putAsciiInternal(' ').put(timestamp * LineUdpSender.unitToNanos(unit));
        this.atNow();
    }

    @Override
    public final void at(Instant timestamp) {
        this.putAsciiInternal(' ').put(timestamp.getEpochSecond() * 1000000000L + (long)timestamp.getNano());
        this.atNow();
    }

    @Override
    public void cancelRow() {
        throw new LineSenderException((CharSequence)"cancelRow() not supported by UDP transport");
    }

    @Override
    public Sender doubleArray(@NotNull CharSequence name, double[] values) {
        throw new LineSenderException((CharSequence)"current protocol version does not support double-array");
    }

    @Override
    public Sender doubleArray(@NotNull CharSequence name, double[][] values) {
        throw new LineSenderException((CharSequence)"current protocol version does not support double-array");
    }

    @Override
    public Sender doubleArray(@NotNull CharSequence name, double[][][] values) {
        throw new LineSenderException((CharSequence)"current protocol version does not support double-array");
    }

    @Override
    public Sender doubleArray(CharSequence name, DoubleArray array) {
        throw new LineSenderException((CharSequence)"current protocol version does not support double-array");
    }

    @Override
    public Sender doubleColumn(CharSequence name, double value) {
        this.writeFieldName(name).put(value);
        return this;
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, long[] values) {
        throw new LineSenderException((CharSequence)"current protocol version does not support long-array");
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, long[][] values) {
        throw new LineSenderException((CharSequence)"current protocol version does not support long-array");
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, long[][][] values) {
        throw new LineSenderException((CharSequence)"current protocol version does not support long-array");
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, LongArray values) {
        throw new LineSenderException((CharSequence)"current protocol version does not support long-array");
    }

    @Override
    public final AbstractLineSender timestampColumn(CharSequence name, Instant value) {
        this.writeFieldName(name).put((value.getEpochSecond() * 1000000000L + (long)value.getNano()) / 1000L);
        return this;
    }

    @Override
    public final AbstractLineSender timestampColumn(CharSequence name, long value, ChronoUnit unit) {
        this.writeFieldName(name).put(Timestamps.toMicros(value, unit));
        return this;
    }
}

