/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.array;

import io.questdb.cutlass.line.LineSenderException;
import io.questdb.cutlass.line.array.ArrayBufferAppender;

public class FlattenArrayUtils {
    public static void putDataToBuf(ArrayBufferAppender mem, double[] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            mem.putDouble(array[i]);
        }
    }

    public static void putDataToBuf(ArrayBufferAppender mem, double[][] array) {
        if (array.length == 0) {
            return;
        }
        int dim1Len = array[0].length;
        for (double[] subArr : array) {
            if (subArr.length != dim1Len) {
                throw new LineSenderException((CharSequence)"irregular array shape");
            }
            FlattenArrayUtils.putDataToBuf(mem, subArr);
        }
    }

    public static void putDataToBuf(ArrayBufferAppender mem, double[][][] array) {
        if (array.length == 0) {
            return;
        }
        int dim1Len = array[0].length;
        for (double[][] v : array) {
            if (v.length != dim1Len) {
                throw new LineSenderException((CharSequence)"irregular array shape");
            }
            FlattenArrayUtils.putDataToBuf(mem, v);
        }
    }

    public static void putDataToBuf(ArrayBufferAppender mem, long[] array) {
        for (long v : array) {
            mem.putLong(v);
        }
    }

    public static void putDataToBuf(ArrayBufferAppender mem, long[][] array) {
        if (array.length == 0) {
            return;
        }
        int dim1Len = array[0].length;
        for (long[] v : array) {
            if (v.length != dim1Len) {
                throw new LineSenderException((CharSequence)"irregular array shape");
            }
            FlattenArrayUtils.putDataToBuf(mem, v);
        }
    }

    public static void putDataToBuf(ArrayBufferAppender mem, long[][][] array) {
        if (array.length == 0) {
            return;
        }
        int dim1Len = array[0].length;
        for (long[][] v : array) {
            if (v.length != dim1Len) {
                throw new LineSenderException((CharSequence)"irregular array shape");
            }
            FlattenArrayUtils.putDataToBuf(mem, v);
        }
    }

    public static void putShapeToBuf(ArrayBufferAppender mem, double[] array) {
        mem.putInt(array.length);
    }

    public static void putShapeToBuf(ArrayBufferAppender mem, double[][] array) {
        mem.putInt(array.length);
        if (array.length == 0) {
            mem.putInt(0);
        } else {
            FlattenArrayUtils.putShapeToBuf(mem, array[0]);
        }
    }

    public static void putShapeToBuf(ArrayBufferAppender mem, double[][][] array) {
        mem.putInt(array.length);
        if (array.length == 0) {
            mem.putInt(0);
            mem.putInt(0);
        } else {
            FlattenArrayUtils.putShapeToBuf(mem, array[0]);
        }
    }

    public static void putShapeToBuf(ArrayBufferAppender mem, long[] array) {
        mem.putInt(array.length);
    }

    public static void putShapeToBuf(ArrayBufferAppender mem, long[][] array) {
        mem.putInt(array.length);
        if (array.length == 0) {
            mem.putInt(0);
        } else {
            FlattenArrayUtils.putShapeToBuf(mem, array[0]);
        }
    }

    public static void putShapeToBuf(ArrayBufferAppender mem, long[][][] array) {
        mem.putInt(array.length);
        if (array.length == 0) {
            mem.putInt(0);
            mem.putInt(0);
        } else {
            FlattenArrayUtils.putShapeToBuf(mem, array[0]);
        }
    }
}

