/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.Metrics;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.security.DenyAllSecurityContext;
import io.questdb.cutlass.auth.AuthenticatorException;
import io.questdb.cutlass.auth.SocketAuthenticator;
import io.questdb.cutlass.line.tcp.AdaptiveRecvBuffer;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.network.IOContext;
import io.questdb.network.NetworkFacade;
import io.questdb.network.TlsSessionInitFailedException;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Utf8StringObjHashMap;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Utf8String;

public class LineTcpConnectionContext
extends IOContext<LineTcpConnectionContext> {
    private static final Log LOG = LogFactory.getLog(LineTcpConnectionContext.class);
    private static final long QUEUE_FULL_LOG_HYSTERESIS_IN_MS = 10000L;
    protected final NetworkFacade nf;
    private final SocketAuthenticator authenticator;
    private final DirectUtf8String byteCharSequence = new DirectUtf8String();
    private final long checkIdleInterval;
    private final long commitInterval;
    private final LineTcpReceiverConfiguration configuration;
    private final boolean disconnectOnError;
    private final long idleTimeout;
    private final boolean logMessageOnError;
    private final Metrics metrics;
    private final MillisecondClock milliClock;
    private final LineTcpParser parser;
    private final AdaptiveRecvBuffer recvBuffer;
    private final LineTcpMeasurementScheduler scheduler;
    private final Utf8StringObjHashMap<TableUpdateDetails> tableUpdateDetailsUtf8 = new Utf8StringObjHashMap();
    protected boolean peerDisconnected;
    protected SecurityContext securityContext = DenyAllSecurityContext.INSTANCE;
    private boolean goodMeasurement;
    private long lastQueueFullLogMillis = 0L;
    private long nextCheckIdleTime;
    private long nextCommitTime;

    public LineTcpConnectionContext(LineTcpReceiverConfiguration configuration, LineTcpMeasurementScheduler scheduler) {
        super(configuration.getFactoryProvider().getLineSocketFactory(), configuration.getNetworkFacade(), LOG);
        try {
            this.configuration = configuration;
            this.nf = configuration.getNetworkFacade();
            this.disconnectOnError = configuration.getDisconnectOnError();
            this.logMessageOnError = configuration.logMessageOnError();
            this.scheduler = scheduler;
            this.metrics = configuration.getMetrics();
            this.milliClock = configuration.getMillisecondClock();
            this.parser = new LineTcpParser(configuration.getCairoConfiguration());
            this.recvBuffer = new AdaptiveRecvBuffer(this.parser, 34);
            this.authenticator = configuration.getFactoryProvider().getLineAuthenticatorFactory().getLineTCPAuthenticator();
            this.clear();
            this.checkIdleInterval = configuration.getMaintenanceInterval();
            this.commitInterval = configuration.getCommitInterval();
            long now = this.milliClock.getTicks();
            this.nextCheckIdleTime = now + this.checkIdleInterval;
            this.nextCommitTime = now + this.commitInterval;
            this.idleTimeout = configuration.getWriterIdleTimeout();
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    public void checkIdle(long millis) {
        for (int n = this.tableUpdateDetailsUtf8.size() - 1; n >= 0; --n) {
            Utf8String tableNameUtf8 = this.tableUpdateDetailsUtf8.keys().get(n);
            TableUpdateDetails tud = this.tableUpdateDetailsUtf8.get(tableNameUtf8);
            if (millis - tud.getLastMeasurementMillis() < this.idleTimeout) continue;
            this.tableUpdateDetailsUtf8.remove(tableNameUtf8);
            tud.close();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.securityContext = DenyAllSecurityContext.INSTANCE;
        this.authenticator.clear();
        Misc.free(this.recvBuffer);
        this.peerDisconnected = false;
        this.goodMeasurement = true;
        ObjList<Utf8String> keys = this.tableUpdateDetailsUtf8.keys();
        for (int n = keys.size() - 1; n >= 0; --n) {
            Utf8String tableNameUtf8 = keys.get(n);
            TableUpdateDetails tud = this.tableUpdateDetailsUtf8.get(tableNameUtf8);
            tud.close();
            this.tableUpdateDetailsUtf8.remove(tableNameUtf8);
        }
    }

    @Override
    public void close() {
        this.clear();
        Misc.free(this.authenticator);
        Misc.free(this.parser);
    }

    public long commitWalTables(long wallClockMillis) {
        long minTableNextCommitTime = Long.MAX_VALUE;
        int sz = this.tableUpdateDetailsUtf8.size();
        for (int n = 0; n < sz; ++n) {
            Utf8String tableNameUtf8 = this.tableUpdateDetailsUtf8.keys().get(n);
            TableUpdateDetails tud = this.tableUpdateDetailsUtf8.get(tableNameUtf8);
            if (!tud.isWal()) continue;
            MillisecondClock millisecondClock = tud.getMillisecondClock();
            try {
                long tableNextCommitTime = tud.commitIfIntervalElapsed(wallClockMillis);
                wallClockMillis = millisecondClock.getTicks();
                if (tableNextCommitTime >= minTableNextCommitTime) continue;
                minTableNextCommitTime = tableNextCommitTime;
                continue;
            }
            catch (CommitFailedException ex) {
                if (ex.isTableDropped()) {
                    LOG.info().$("closing writer because table has been dropped (2) [table=").$safe(tud.getTableNameUtf16()).I$();
                    tud.setWriterInError();
                    tud.releaseWriter(false);
                    continue;
                }
                LOG.critical().$("commit failed [table=").$safe(tud.getTableNameUtf16()).$(",ex=").$(ex).I$();
                continue;
            }
            catch (Throwable ex) {
                LOG.critical().$("commit failed [table=").$safe(tud.getTableNameUtf16()).$(",ex=").$(ex).I$();
            }
        }
        return minTableNextCommitTime != Long.MAX_VALUE ? minTableNextCommitTime : wallClockMillis + this.commitInterval;
    }

    public void doMaintenance(long now) {
        if (now > this.nextCommitTime) {
            this.nextCommitTime = this.commitWalTables(now);
        }
        if (now > this.nextCheckIdleTime) {
            this.checkIdle(now);
            this.nextCheckIdleTime = now + this.checkIdleInterval;
        }
    }

    public TableUpdateDetails getTableUpdateDetails(DirectUtf8Sequence tableName) {
        return this.tableUpdateDetailsUtf8.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOContextResult handleIO(NetworkIOJob netIoJob) {
        if (this.authenticator.isAuthenticated()) {
            this.read();
            try {
                IOContextResult parseResult = this.parseMeasurements(netIoJob);
                this.doMaintenance(this.milliClock.getTicks());
                IOContextResult iOContextResult = parseResult;
                return iOContextResult;
            }
            finally {
                netIoJob.releaseWalTableDetails();
            }
        }
        return this.handleAuthentication(netIoJob);
    }

    private boolean checkQueueFullLogHysteresis() {
        long millis = this.milliClock.getTicks();
        if (millis - this.lastQueueFullLogMillis >= 10000L) {
            this.lastQueueFullLogMillis = millis;
            return true;
        }
        return false;
    }

    private void doHandleDisconnectEvent() {
        if (this.parser.getBufferAddress() == this.recvBuffer.getBufEnd()) {
            LOG.error().$('[').$(this.getFd()).$("] buffer overflow [line.tcp.max.recv.buffer.size=").$(this.recvBuffer.getBufEnd() - this.recvBuffer.getBufStart()).$(']').$();
            return;
        }
        if (this.peerDisconnected) {
            if (this.recvBuffer.getBufPos() != this.recvBuffer.getBufStart()) {
                LOG.info().$('[').$(this.getFd()).$("] peer disconnected with partial measurement, ").$(this.recvBuffer.getBufPos() - this.recvBuffer.getBufStart()).$(" unprocessed bytes").$();
            } else {
                LOG.info().$('[').$(this.getFd()).$("] peer disconnected").$();
            }
        }
    }

    private IOContextResult handleAuthentication(NetworkIOJob netIoJob) {
        try {
            int result = this.authenticator.handleIO();
            switch (result) {
                case 1: {
                    return IOContextResult.NEEDS_WRITE;
                }
                case -1: {
                    assert (this.authenticator.isAuthenticated());
                    assert (this.securityContext == DenyAllSecurityContext.INSTANCE);
                    this.securityContext = this.configuration.getFactoryProvider().getSecurityContextFactory().getInstance(this.authenticator.getPrincipal(), this.authenticator.getAuthType(), (byte)2);
                    try {
                        this.securityContext.checkEntityEnabled();
                    }
                    catch (CairoException e) {
                        LOG.error().$('[').$(this.getFd()).$("] ").$safe(e.getFlyweightMessage()).$();
                        return IOContextResult.NEEDS_DISCONNECT;
                    }
                    this.recvBuffer.setBufPos(this.authenticator.getRecvBufPos());
                    this.resetParser(this.authenticator.getRecvBufPseudoStart());
                    return this.parseMeasurements(netIoJob);
                }
                case 0: {
                    return IOContextResult.NEEDS_READ;
                }
                case 3: {
                    return IOContextResult.NEEDS_DISCONNECT;
                }
                case 2: {
                    return IOContextResult.QUEUE_FULL;
                }
            }
            LOG.error().$("unexpected authenticator result [result=").$(result).I$();
            return IOContextResult.NEEDS_DISCONNECT;
        }
        catch (AuthenticatorException e) {
            return IOContextResult.NEEDS_DISCONNECT;
        }
    }

    private void logParseError() {
        int position = (int)(this.parser.getBufferAddress() - this.recvBuffer.getBufStartOfMeasurement());
        assert (position >= 0);
        LogRecord errorRec = LOG.error().$('[').$(this.getFd()).$("] could not parse measurement, ").$((Object)this.parser.getErrorCode()).$(" at ").$(position);
        if (this.logMessageOnError) {
            errorRec.$(", line (may be mangled due to partial parsing): '").$safe(this.byteCharSequence.of(this.recvBuffer.getBufStartOfMeasurement(), this.parser.getBufferAddress(), false)).$("'");
        }
        errorRec.$();
    }

    private void resetParser(long pos) {
        this.parser.of(pos);
        this.goodMeasurement = true;
        this.recvBuffer.setBufStartOfMeasurement(pos);
    }

    void addTableUpdateDetails(Utf8String tableNameUtf8, TableUpdateDetails tableUpdateDetails) {
        this.tableUpdateDetailsUtf8.put(tableNameUtf8, tableUpdateDetails);
    }

    @Override
    protected void doInit() throws TlsSessionInitFailedException {
        if (this.recvBuffer.getBufStart() == 0L) {
            this.recvBuffer.of(this.configuration.getRecvBufferSize(), this.configuration.getMaxRecvBufferSize());
            this.goodMeasurement = true;
        }
        this.authenticator.init(this.socket, this.recvBuffer.getBufStart(), this.recvBuffer.getBufEnd(), 0L, 0L);
        if (this.authenticator.isAuthenticated() && this.securityContext == DenyAllSecurityContext.INSTANCE) {
            this.securityContext = this.configuration.getFactoryProvider().getSecurityContextFactory().getInstance(null, (byte)0, (byte)2);
            this.securityContext.authorizeLineTcp();
        }
        if (this.socket.supportsTls()) {
            this.socket.startTlsSession(null);
        }
    }

    protected SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    protected final IOContextResult parseMeasurements(NetworkIOJob netIoJob) {
        while (true) {
            try {
                block9: while (true) {
                    LineTcpParser.ParseResult rc = this.goodMeasurement ? this.parser.parseMeasurement(this.recvBuffer.getBufPos()) : this.parser.skipMeasurement(this.recvBuffer.getBufPos());
                    switch (rc) {
                        case MEASUREMENT_COMPLETE: {
                            if (this.goodMeasurement) {
                                if (this.scheduler.scheduleEvent(this.getSecurityContext(), netIoJob, this, this.parser)) {
                                    if (this.checkQueueFullLogHysteresis()) {
                                        LOG.debug().$('[').$(this.getFd()).$("] queue full").$();
                                    }
                                    return IOContextResult.QUEUE_FULL;
                                }
                            } else {
                                this.logParseError();
                                this.goodMeasurement = true;
                            }
                            this.recvBuffer.startNewMeasurement();
                            continue block9;
                        }
                        case ERROR: {
                            if (this.disconnectOnError) {
                                this.logParseError();
                                return IOContextResult.NEEDS_DISCONNECT;
                            }
                            this.goodMeasurement = false;
                            continue block9;
                        }
                        case BUFFER_UNDERFLOW: {
                            if (!this.recvBuffer.tryCompactOrGrowBuffer()) {
                                this.doHandleDisconnectEvent();
                                return IOContextResult.NEEDS_DISCONNECT;
                            }
                            if (this.peerDisconnected) {
                                return IOContextResult.NEEDS_DISCONNECT;
                            }
                            return IOContextResult.NEEDS_READ;
                        }
                    }
                }
            }
            catch (CairoException ex) {
                LogRecord error = ex.isCritical() ? LOG.critical() : LOG.error();
                error.$('[').$(this.getFd()).$("] could not process line data 1 [table=").$safe(this.parser.getMeasurementName()).$(", msg=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
                if (this.disconnectOnError) {
                    if (!ex.isAuthorizationError()) {
                        this.logParseError();
                    }
                    return IOContextResult.NEEDS_DISCONNECT;
                }
                this.goodMeasurement = false;
                continue;
            }
            catch (Throwable ex) {
                LOG.critical().$('[').$(this.getFd()).$("] could not process line data 2 [table=").$safe(this.parser.getMeasurementName()).$(", ex=").$(ex).I$();
                this.metrics.healthMetrics().incrementUnhandledErrors();
                return IOContextResult.NEEDS_DISCONNECT;
            }
            break;
        }
    }

    protected boolean read() {
        int bufferRemaining;
        long recvBufPos = this.recvBuffer.getBufPos();
        int orig = bufferRemaining = (int)(this.recvBuffer.getBufEnd() - recvBufPos);
        if (bufferRemaining > 0 && !this.peerDisconnected) {
            int bytesRead = this.socket.recv(recvBufPos, bufferRemaining);
            this.metrics.lineMetrics().totalIlpTcpBytesGauge().add(bytesRead);
            if (bytesRead > 0) {
                this.recvBuffer.setBufPos(recvBufPos + (long)bytesRead);
                bufferRemaining -= bytesRead;
            } else {
                this.peerDisconnected = bytesRead < 0;
            }
            return bufferRemaining < orig;
        }
        return !this.peerDisconnected;
    }

    TableUpdateDetails removeTableUpdateDetails(DirectUtf8Sequence tableNameUtf8) {
        int keyIndex = this.tableUpdateDetailsUtf8.keyIndex(tableNameUtf8);
        if (keyIndex < 0) {
            TableUpdateDetails tud = this.tableUpdateDetailsUtf8.valueAtQuick(keyIndex);
            this.tableUpdateDetailsUtf8.removeAt(keyIndex);
            return tud;
        }
        return null;
    }

    public static enum IOContextResult {
        NEEDS_READ,
        NEEDS_WRITE,
        QUEUE_FULL,
        NEEDS_DISCONNECT;

    }
}

