/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoError;
import io.questdb.griffin.FunctionFactory;
import io.questdb.log.Log;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.str.StringSink;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class FunctionFactoryScanner {
    public static void scan(ArrayList<FunctionFactory> functionFactories, String packageName, String functionListFileName, Class<?> clazz, String moduleName, @Nullable Log log) {
        try {
            int initialSize = functionFactories.size();
            ClassLoader classLoader = clazz.getClassLoader();
            FunctionFactoryScanner.findAllClassesFromModules(functionFactories, packageName, classLoader, moduleName, log);
            if (functionFactories.size() == initialSize) {
                URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
                if (url == null) {
                    throw new CairoError("no functions found in " + packageName + ", cannot determine location path");
                }
                String locationPath = url.toURI().getPath().replace("file:", "");
                if (log != null) {
                    log.advisory().$("loading functions from ").$(locationPath).$();
                }
                if (locationPath.endsWith(".jar")) {
                    FunctionFactoryScanner.scanJar(functionFactories, locationPath, packageName, classLoader, log);
                } else {
                    FunctionFactoryScanner.scanDirectory(functionFactories, locationPath, packageName, classLoader, log);
                }
            }
            if (functionFactories.size() == initialSize) {
                throw new CairoError("no functions found in " + packageName);
            }
            CharSequenceIntHashMap orderMap = new CharSequenceIntHashMap();
            FunctionFactoryScanner.loadFunctionOrderMap(functionListFileName, classLoader, orderMap);
            if (initialSize > 0) {
                functionFactories.subList(initialSize, functionFactories.size()).sort((f1, f2) -> FunctionFactoryScanner.compareFactories(f1, f2, orderMap));
            } else {
                functionFactories.sort((f1, f2) -> FunctionFactoryScanner.compareFactories(f1, f2, orderMap));
            }
            if (log != null) {
                log.advisory().$("loaded ").$(functionFactories.size() - initialSize).$(" functions").$();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int compareFactories(FunctionFactory f1, FunctionFactory f2, CharSequenceIntHashMap orderMap) {
        int o1 = FunctionFactoryScanner.getOrder(f1, orderMap);
        int o2 = FunctionFactoryScanner.getOrder(f2, orderMap);
        return Integer.compare(o1, o2);
    }

    private static void findAllClassesFromModules(ArrayList<FunctionFactory> factories, String packageName, ClassLoader classLoader, String moduleName, @Nullable Log log) {
        try (FileSystem fs = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap(), classLoader);){
            Path questdbPath = fs.getPath("modules", moduleName, moduleName.substring(0, moduleName.indexOf(46)));
            try (Stream<Path> questdbPathFiles = Files.list(questdbPath);){
                StringSink sink = new StringSink();
                questdbPathFiles.forEach(mdl -> {
                    String pathPattern = "modules/" + moduleName + "/" + packageName.replace('.', '/');
                    int replaceLen = "modules/".length() + moduleName.length() + 1;
                    if (log != null) {
                        log.advisory().$("loading functions from ").$(moduleName).$();
                    }
                    try (Stream<Path> walk = Files.walk(mdl, new FileVisitOption[0]);){
                        walk.forEach(classFile -> {
                            if (classFile.startsWith(pathPattern)) {
                                sink.clear();
                                String classNameStr = classFile.toString();
                                sink.put(classNameStr, replaceLen, classNameStr.length());
                                if (Chars.endsWith((CharSequence)sink, ".class")) {
                                    sink.trimTo(sink.length() - ".class".length());
                                }
                                sink.replace('/', '.');
                                FunctionFactory factory = FunctionFactoryScanner.getClass(sink, classLoader, log);
                                if (factory != null) {
                                    factories.add(factory);
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    private static FunctionFactory getClass(CharSequence className, ClassLoader classLoader, @Nullable Log log) {
        Class<?> clazz;
        try {
            clazz = classLoader.loadClass(className.toString());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (FunctionFactory.class.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers())) {
            try {
                return (FunctionFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                if (log != null) {
                    log.critical().$("error loading function: ").$(className).$(", error: ").$(e).$();
                }
                System.out.println("error loading function: " + String.valueOf(className) + ", error: " + String.valueOf(e));
                e.printStackTrace(System.out);
            }
        }
        return null;
    }

    private static int getOrder(FunctionFactory f1, CharSequenceIntHashMap orderMap) {
        int index = orderMap.keyIndex(f1.getClass().getName());
        if (index < 0) {
            return orderMap.valueAt(index);
        }
        return orderMap.size() + Math.abs(10000 - f1.getSignature().length());
    }

    private static void loadFunctionOrderMap(String functionListFileName, ClassLoader classLoader, CharSequenceIntHashMap map) {
        block10: {
            try (InputStream inputStream = classLoader.getResourceAsStream(functionListFileName);){
                if (inputStream != null) {
                    String[] lines = new String(inputStream.readAllBytes()).split("\n");
                    int order = 0;
                    for (String line : lines) {
                        String trimmed = line.trim();
                        if (trimmed.isBlank() || trimmed.startsWith("#")) continue;
                        map.put(line.trim(), order++);
                    }
                    break block10;
                }
                throw new CairoError("functions order file " + functionListFileName + " not found");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void scanDirectory(ArrayList<FunctionFactory> functionFactories, String dirPath, String packageName, ClassLoader classLoader, @Nullable Log log) {
        String packagePath = packageName.replace('.', '/');
        File dir = new File(dirPath + "/" + packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new UnsupportedOperationException("cannot load functions, directory not found: " + String.valueOf(dir));
        }
        StringSink packageNameSink = new StringSink();
        packageNameSink.put(packageName);
        FunctionFactoryScanner.scanDirectoryRecursively(functionFactories, dir, packageNameSink, classLoader, log);
    }

    private static void scanDirectoryRecursively(ArrayList<FunctionFactory> functionFactories, File dir, StringSink packageName, ClassLoader classLoader, @Nullable Log log) {
        File[] files = dir.listFiles();
        int len = packageName.length();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (fileName.endsWith(".class")) {
                    packageName.trimTo(len);
                    packageName.put('.').put(fileName, 0, fileName.length() - ".class".length());
                    FunctionFactory factory = FunctionFactoryScanner.getClass(packageName, classLoader, log);
                    if (factory == null) continue;
                    functionFactories.add(factory);
                    continue;
                }
                if (!file.isDirectory()) continue;
                packageName.trimTo(len);
                packageName.put('.').put(fileName);
                FunctionFactoryScanner.scanDirectoryRecursively(functionFactories, file, packageName, classLoader, log);
            }
        }
    }

    private static void scanJar(ArrayList<FunctionFactory> functionFactories, String jarPath, String packageName, ClassLoader classLoader, @Nullable Log log) {
        try {
            String pathFilterPrefix = packageName.replace('.', '/');
            StringSink sink = new StringSink();
            try (JarFile jarFile = new JarFile(new File(jarPath), false, 1);){
                jarFile.stream().filter(entry -> {
                    String entryName = entry.getName();
                    return entryName.startsWith(pathFilterPrefix) && entryName.endsWith(".class");
                }).forEach(entry -> {
                    String entryName = entry.getName();
                    sink.clear();
                    sink.put(entryName, 0, entryName.length() - ".class".length());
                    sink.replace('/', '.');
                    FunctionFactory factory = FunctionFactoryScanner.getClass(sink, classLoader, log);
                    if (factory != null) {
                        functionFactories.add(factory);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

