/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DoubleArrayParser;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.RecordToRowCopier;
import io.questdb.griffin.SqlUtil;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;

public class RecordToRowCopierUtils {
    private RecordToRowCopierUtils() {
    }

    public static RecordToRowCopier generateCopier(BytecodeAssembler asm, ColumnTypes from, RecordMetadata to, ColumnFilter toColumnFilter) {
        int timestampIndex = to.getTimestampIndex();
        asm.init(RecordToRowCopier.class);
        asm.setupPool();
        int thisClassIndex = asm.poolClass(asm.poolUtf8("io/questdb/griffin/rowcopier"));
        int interfaceClassIndex = asm.poolClass(RecordToRowCopier.class);
        int rGetInt = asm.poolInterfaceMethod(Record.class, "getInt", "(I)I");
        int rGetIPv4 = asm.poolInterfaceMethod(Record.class, "getIPv4", "(I)I");
        int rGetGeoInt = asm.poolInterfaceMethod(Record.class, "getGeoInt", "(I)I");
        int rGetLong = asm.poolInterfaceMethod(Record.class, "getLong", "(I)J");
        int rGetGeoLong = asm.poolInterfaceMethod(Record.class, "getGeoLong", "(I)J");
        int rGetLong256 = asm.poolInterfaceMethod(Record.class, "getLong256A", "(I)Lio/questdb/std/Long256;");
        int rGetLong128Lo = asm.poolInterfaceMethod(Record.class, "getLong128Lo", "(I)J");
        int rGetLong128Hi = asm.poolInterfaceMethod(Record.class, "getLong128Hi", "(I)J");
        int rGetDate = asm.poolInterfaceMethod(Record.class, "getDate", "(I)J");
        int rGetTimestamp = asm.poolInterfaceMethod(Record.class, "getTimestamp", "(I)J");
        int rGetByte = asm.poolInterfaceMethod(Record.class, "getByte", "(I)B");
        int rGetGeoByte = asm.poolInterfaceMethod(Record.class, "getGeoByte", "(I)B");
        int rGetShort = asm.poolInterfaceMethod(Record.class, "getShort", "(I)S");
        int rGetGeoShort = asm.poolInterfaceMethod(Record.class, "getGeoShort", "(I)S");
        int rGetChar = asm.poolInterfaceMethod(Record.class, "getChar", "(I)C");
        int rGetBool = asm.poolInterfaceMethod(Record.class, "getBool", "(I)Z");
        int rGetFloat = asm.poolInterfaceMethod(Record.class, "getFloat", "(I)F");
        int rGetDouble = asm.poolInterfaceMethod(Record.class, "getDouble", "(I)D");
        int rGetSym = asm.poolInterfaceMethod(Record.class, "getSymA", "(I)Ljava/lang/CharSequence;");
        int rGetStrA = asm.poolInterfaceMethod(Record.class, "getStrA", "(I)Ljava/lang/CharSequence;");
        int rGetBin = asm.poolInterfaceMethod(Record.class, "getBin", "(I)Lio/questdb/std/BinarySequence;");
        int rGetVarchar = asm.poolInterfaceMethod(Record.class, "getVarcharA", "(I)Lio/questdb/std/str/Utf8Sequence;");
        int rGetArray = asm.poolInterfaceMethod(Record.class, "getArray", "(II)Lio/questdb/cairo/arr/ArrayView;");
        int wPutInt = asm.poolInterfaceMethod(TableWriter.Row.class, "putInt", "(II)V");
        int wPutIPv4 = asm.poolInterfaceMethod(TableWriter.Row.class, "putIPv4", "(II)V");
        int wPutLong = asm.poolInterfaceMethod(TableWriter.Row.class, "putLong", "(IJ)V");
        int wPutLong256 = asm.poolInterfaceMethod(TableWriter.Row.class, "putLong256", "(ILio/questdb/std/Long256;)V");
        int wPutLong256Utf8 = asm.poolInterfaceMethod(TableWriter.Row.class, "putLong256Utf8", "(ILio/questdb/std/str/DirectUtf8Sequence;)V");
        int wPutLong128 = asm.poolInterfaceMethod(TableWriter.Row.class, "putLong128", "(IJJ)V");
        int wPutUuidStr = asm.poolInterfaceMethod(TableWriter.Row.class, "putUuid", "(ILjava/lang/CharSequence;)V");
        int wPutUuidUtf8 = asm.poolInterfaceMethod(TableWriter.Row.class, "putUuidUtf8", "(ILio/questdb/std/str/Utf8Sequence;)V");
        int wPutDate = asm.poolInterfaceMethod(TableWriter.Row.class, "putDate", "(IJ)V");
        int wPutTimestamp = asm.poolInterfaceMethod(TableWriter.Row.class, "putTimestamp", "(IJ)V");
        int wPutByte = asm.poolInterfaceMethod(TableWriter.Row.class, "putByte", "(IB)V");
        int wPutShort = asm.poolInterfaceMethod(TableWriter.Row.class, "putShort", "(IS)V");
        int wPutBool = asm.poolInterfaceMethod(TableWriter.Row.class, "putBool", "(IZ)V");
        int wPutFloat = asm.poolInterfaceMethod(TableWriter.Row.class, "putFloat", "(IF)V");
        int wPutDouble = asm.poolInterfaceMethod(TableWriter.Row.class, "putDouble", "(ID)V");
        int wPutSym = asm.poolInterfaceMethod(TableWriter.Row.class, "putSym", "(ILjava/lang/CharSequence;)V");
        int wPutSymChar = asm.poolInterfaceMethod(TableWriter.Row.class, "putSym", "(IC)V");
        int wPutStr = asm.poolInterfaceMethod(TableWriter.Row.class, "putStr", "(ILjava/lang/CharSequence;)V");
        int wPutGeoStr = asm.poolInterfaceMethod(TableWriter.Row.class, "putGeoStr", "(ILjava/lang/CharSequence;)V");
        int wPutGeoVarchar = asm.poolInterfaceMethod(TableWriter.Row.class, "putGeoVarchar", "(ILio/questdb/std/str/Utf8Sequence;)V");
        int wPutVarchar = asm.poolInterfaceMethod(TableWriter.Row.class, "putVarchar", "(ILio/questdb/std/str/Utf8Sequence;)V");
        int wPutArray = asm.poolInterfaceMethod(TableWriter.Row.class, "putArray", "(ILio/questdb/cairo/arr/ArrayView;)V");
        int implicitCastCharAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastCharAsByte", (CharSequence)"(CI)B");
        int implicitCastCharAsGeoHash = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastCharAsGeoHash", (CharSequence)"(CI)B");
        int implicitCastStrAsFloat = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsFloat", (CharSequence)"(Ljava/lang/CharSequence;)F");
        int implicitCastStrAsDouble = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsDouble", (CharSequence)"(Ljava/lang/CharSequence;)D");
        int implicitCastStrAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsByte", (CharSequence)"(Ljava/lang/CharSequence;)B");
        int implicitCastStrAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsShort", (CharSequence)"(Ljava/lang/CharSequence;)S");
        int implicitCastStrAsChar = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsChar", (CharSequence)"(Ljava/lang/CharSequence;)C");
        int implicitCastStrAsInt = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsInt", (CharSequence)"(Ljava/lang/CharSequence;)I");
        int implicitCastStrAsIPv4 = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsIPv4", (CharSequence)"(Ljava/lang/CharSequence;)I");
        int implicitCastUtf8StrAsIPv4 = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsIPv4", (CharSequence)"(Lio/questdb/std/str/Utf8Sequence;)I");
        int implicitCastStrAsLong = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsLong", (CharSequence)"(Ljava/lang/CharSequence;)J");
        int implicitCastStrAsLong256 = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsLong256", (CharSequence)"(Ljava/lang/CharSequence;)Lio/questdb/griffin/engine/functions/constants/Long256Constant;");
        int implicitCastStrAsDate = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsDate", (CharSequence)"(Ljava/lang/CharSequence;)J");
        int implicitCastStrAsTimestamp = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsTimestamp", (CharSequence)"(Ljava/lang/CharSequence;)J");
        int implicitCastDateAsTimestamp = asm.poolMethod(SqlUtil.class, (CharSequence)"dateToTimestamp", (CharSequence)"(J)J");
        int implicitCastShortAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastShortAsByte", (CharSequence)"(S)B");
        int implicitCastIntAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastIntAsByte", (CharSequence)"(I)B");
        int implicitCastLongAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastLongAsByte", (CharSequence)"(J)B");
        int implicitCastFloatAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastFloatAsByte", (CharSequence)"(F)B");
        int implicitCastDoubleAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastDoubleAsByte", (CharSequence)"(D)B");
        int implicitCastVarcharAsLong = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastVarcharAsLong", (CharSequence)"(Lio/questdb/std/str/Utf8Sequence;)J");
        int implicitCastVarcharAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastVarcharAsShort", (CharSequence)"(Lio/questdb/std/str/Utf8Sequence;)S");
        int implicitCastVarcharAsInt = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastVarcharAsInt", (CharSequence)"(Lio/questdb/std/str/Utf8Sequence;)I");
        int implicitCastVarcharAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastVarcharAsByte", (CharSequence)"(Lio/questdb/std/str/Utf8Sequence;)B");
        int implicitCastVarcharAsChar = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastVarcharAsChar", (CharSequence)"(Lio/questdb/std/str/Utf8Sequence;)C");
        int implicitCastVarcharAsFloat = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastVarcharAsFloat", (CharSequence)"(Lio/questdb/std/str/Utf8Sequence;)F");
        int implicitCastVarcharAsDouble = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastVarcharAsDouble", (CharSequence)"(Lio/questdb/std/str/Utf8Sequence;)D");
        int implicitCastIntAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastIntAsShort", (CharSequence)"(I)S");
        int implicitCastLongAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastLongAsShort", (CharSequence)"(J)S");
        int implicitCastFloatAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastFloatAsShort", (CharSequence)"(F)S");
        int implicitCastDoubleAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastDoubleAsShort", (CharSequence)"(D)S");
        int implicitCastLongAsInt = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastLongAsInt", (CharSequence)"(J)I");
        int implicitCastFloatAsInt = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastFloatAsInt", (CharSequence)"(F)I");
        int implicitCastDoubleAsInt = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastDoubleAsInt", (CharSequence)"(D)I");
        int implicitCastFloatAsLong = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastFloatAsLong", (CharSequence)"(F)J");
        int implicitCastDoubleAsLong = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastDoubleAsLong", (CharSequence)"(D)J");
        int implicitCastDoubleAsFloat = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastDoubleAsFloat", (CharSequence)"(D)F");
        int wPutStrChar = asm.poolInterfaceMethod(TableWriter.Row.class, "putStr", "(IC)V");
        int wPutVarcharChar = asm.poolInterfaceMethod(TableWriter.Row.class, "putVarchar", "(IC)V");
        int wPutChar = asm.poolInterfaceMethod(TableWriter.Row.class, "putChar", "(IC)V");
        int wPutBin = asm.poolInterfaceMethod(TableWriter.Row.class, "putBin", "(ILio/questdb/std/BinarySequence;)V");
        int implicitCastGeoHashAsGeoHash = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastGeoHashAsGeoHash", (CharSequence)"(JII)J");
        int transferUuidToStrCol = asm.poolMethod(RecordToRowCopierUtils.class, (CharSequence)"transferUuidToStrCol", (CharSequence)"(Lio/questdb/cairo/TableWriter$Row;IJJ)V");
        int transferUuidToVarcharCol = asm.poolMethod(RecordToRowCopierUtils.class, (CharSequence)"transferUuidToVarcharCol", (CharSequence)"(Lio/questdb/cairo/TableWriter$Row;IJJ)V");
        int transferVarcharToStrCol = asm.poolInterfaceMethod(TableWriter.Row.class, "putStrUtf8", "(ILio/questdb/std/str/DirectUtf8Sequence;)V");
        int transferVarcharToSymbolCol = asm.poolMethod(RecordToRowCopierUtils.class, (CharSequence)"transferVarcharToSymbolCol", (CharSequence)"(Lio/questdb/cairo/TableWriter$Row;ILio/questdb/std/str/Utf8Sequence;)V");
        int transferVarcharToTimestampCol = asm.poolMethod(RecordToRowCopierUtils.class, (CharSequence)"transferVarcharToTimestampCol", (CharSequence)"(Lio/questdb/cairo/TableWriter$Row;ILio/questdb/std/str/Utf8Sequence;)V");
        int transferVarcharToDateCol = asm.poolMethod(RecordToRowCopierUtils.class, (CharSequence)"transferVarcharToDateCol", (CharSequence)"(Lio/questdb/cairo/TableWriter$Row;ILio/questdb/std/str/Utf8Sequence;)V");
        int transferStrToVarcharCol = asm.poolMethod(RecordToRowCopierUtils.class, (CharSequence)"transferStrToVarcharCol", (CharSequence)"(Lio/questdb/cairo/TableWriter$Row;ILjava/lang/CharSequence;)V");
        int validateArrayDimensionsAndTransferCol = asm.poolMethod(RecordToRowCopierUtils.class, (CharSequence)"validateArrayDimensionsAndTransferCol", (CharSequence)"(Lio/questdb/cairo/TableWriter$Row;ILio/questdb/cairo/arr/DoubleArrayParser;Ljava/lang/CharSequence;I)V");
        int n = toColumnFilter.getColumnCount();
        int toColumnType_0 = asm.getPoolCount();
        int fromColumnType_0 = toColumnType_0 + 1;
        for (int i = 0; i < n; ++i) {
            asm.poolIntConst(to.getColumnType(toColumnFilter.getColumnIndexFactored(i)));
            asm.poolIntConst(from.getColumnType(i));
        }
        int copyNameIndex = asm.poolUtf8("copy");
        int copySigIndex = asm.poolUtf8("(Lio/questdb/cairo/sql/Record;Lio/questdb/cairo/TableWriter$Row;)V");
        int parserFieldIndex = 0;
        int parserDescIndex = 0;
        int constructorNameIndex = 0;
        int constructorDescIndex = 0;
        int doubleArrayParserClassIndex = 0;
        int doubleArrayParserCtorIndex = 0;
        int parserFieldRef = 0;
        int objectCtorIndex = 0;
        boolean needsArrayParser = RecordToRowCopierUtils.isArrayParserRequired(from, to, toColumnFilter, n);
        if (needsArrayParser) {
            parserFieldIndex = asm.poolUtf8("parser");
            parserDescIndex = asm.poolUtf8("Lio/questdb/cairo/arr/DoubleArrayParser;");
            constructorNameIndex = asm.poolUtf8("<init>");
            constructorDescIndex = asm.poolUtf8("()V");
            doubleArrayParserClassIndex = asm.poolClass(DoubleArrayParser.class);
            doubleArrayParserCtorIndex = asm.poolMethod(doubleArrayParserClassIndex, (CharSequence)"<init>", (CharSequence)"()V");
            int parserFieldNameAndType = asm.poolNameAndType(parserFieldIndex, parserDescIndex);
            parserFieldRef = asm.poolField(thisClassIndex, parserFieldNameAndType);
            objectCtorIndex = asm.poolMethod(Object.class, (CharSequence)"<init>", (CharSequence)"()V");
        }
        asm.finishPool();
        asm.defineClass(thisClassIndex);
        asm.interfaceCount(1);
        asm.putShort(interfaceClassIndex);
        if (needsArrayParser) {
            asm.fieldCount(1);
            asm.defineField(parserFieldIndex, parserDescIndex);
        } else {
            asm.fieldCount(0);
        }
        asm.methodCount(2);
        if (needsArrayParser) {
            asm.startMethod(constructorNameIndex, constructorDescIndex, 3, 1);
            asm.aload(0);
            asm.invokespecial(objectCtorIndex);
            asm.aload(0);
            asm.new_(doubleArrayParserClassIndex);
            asm.dup();
            asm.invokespecial(doubleArrayParserCtorIndex);
            asm.putfield(parserFieldRef);
            asm.return_();
            asm.endMethodCode();
            asm.putShort(0);
            asm.putShort(0);
            asm.endMethod();
        } else {
            asm.defineDefaultConstructor();
        }
        asm.startMethod(copyNameIndex, copySigIndex, 15, 5);
        block178: for (int i = 0; i < n; ++i) {
            int toColumnIndex = toColumnFilter.getColumnIndexFactored(i);
            if (toColumnIndex == timestampIndex) continue;
            int toColumnType = to.getColumnType(toColumnIndex);
            int fromColumnType = from.getColumnType(i);
            short toColumnTypeTag = ColumnType.tagOf(toColumnType);
            int toColumnWriterIndex = to.getWriterIndex(toColumnIndex);
            if (toColumnTypeTag == 27 && ColumnType.tagOf(fromColumnType) == 11) {
                asm.aload(2);
                asm.iconst(toColumnWriterIndex);
                asm.aload(0);
                asm.getfield(parserFieldRef);
                asm.aload(1);
                asm.iconst(i);
            } else {
                asm.aload(2);
                asm.iconst(toColumnWriterIndex);
                asm.aload(1);
                asm.iconst(i);
            }
            short fromColumnTypeTag = ColumnType.tagOf(fromColumnType);
            if (fromColumnTypeTag == 33) {
                fromColumnTypeTag = toColumnTypeTag;
            }
            switch (fromColumnTypeTag) {
                case 5: {
                    asm.invokeInterface(rGetInt);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastIntAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastIntAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeInterface(wPutDate, 3);
                            continue block178;
                        }
                        case 8: {
                            asm.i2l();
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                        case 9: {
                            asm.i2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.i2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 25: {
                    assert (toColumnTypeTag == 25);
                    asm.invokeInterface(rGetIPv4);
                    asm.invokeInterface(wPutIPv4, 2);
                    continue block178;
                }
                case 6: {
                    asm.invokeInterface(rGetLong);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastLongAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastLongAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastLongAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 7: {
                            asm.invokeInterface(wPutDate, 3);
                            continue block178;
                        }
                        case 8: {
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                        case 9: {
                            asm.l2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.l2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 7: {
                    asm.invokeInterface(rGetDate);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastLongAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastLongAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastLongAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 7: {
                            asm.invokeInterface(wPutDate, 3);
                            continue block178;
                        }
                        case 8: {
                            asm.invokeStatic(implicitCastDateAsTimestamp);
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                        case 9: {
                            asm.l2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.l2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 8: {
                    asm.invokeInterface(rGetTimestamp);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastLongAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastLongAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastLongAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 9: {
                            asm.l2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.l2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                        case 7: {
                            asm.invokeInterface(wPutDate, 3);
                            continue block178;
                        }
                        case 8: {
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 2: {
                    asm.invokeInterface(rGetByte);
                    switch (toColumnTypeTag) {
                        case 1: 
                        case 2: {
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 3: {
                            asm.i2s();
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeInterface(wPutDate, 3);
                            continue block178;
                        }
                        case 8: {
                            asm.i2l();
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                        case 9: {
                            asm.i2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.i2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 3: {
                    asm.invokeInterface(rGetShort);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastShortAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 3: {
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeInterface(wPutDate, 3);
                            continue block178;
                        }
                        case 8: {
                            asm.i2l();
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                        case 9: {
                            asm.i2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.i2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 1: {
                    assert (toColumnType == 1);
                    asm.invokeInterface(rGetBool);
                    asm.invokeInterface(wPutBool, 2);
                    continue block178;
                }
                case 9: {
                    asm.invokeInterface(rGetFloat);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastFloatAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastFloatAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastFloatAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.invokeStatic(implicitCastFloatAsLong);
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 7: {
                            asm.invokeStatic(implicitCastFloatAsLong);
                            asm.invokeInterface(wPutDate, 3);
                            continue block178;
                        }
                        case 8: {
                            asm.invokeStatic(implicitCastFloatAsLong);
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                        case 9: {
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.f2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 10: {
                    asm.invokeInterface(rGetDouble);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastDoubleAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastDoubleAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastDoubleAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.invokeStatic(implicitCastDoubleAsLong);
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 7: {
                            asm.invokeStatic(implicitCastDoubleAsLong);
                            asm.invokeInterface(wPutDate, 3);
                            continue block178;
                        }
                        case 8: {
                            asm.invokeStatic(implicitCastDoubleAsLong);
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                        case 9: {
                            asm.invokeStatic(implicitCastDoubleAsFloat);
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 4: {
                    asm.invokeInterface(rGetChar);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 3: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2s();
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 4: {
                            asm.invokeInterface(wPutChar, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2l();
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 7: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2l();
                            asm.invokeInterface(wPutDate, 3);
                            continue block178;
                        }
                        case 8: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2l();
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                        case 9: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                        case 11: {
                            asm.invokeInterface(wPutStrChar, 2);
                            continue block178;
                        }
                        case 26: {
                            asm.invokeInterface(wPutVarcharChar, 2);
                            continue block178;
                        }
                        case 12: {
                            asm.invokeInterface(wPutSymChar, 2);
                            continue block178;
                        }
                        case 14: {
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastCharAsGeoHash);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 12: {
                    asm.invokeInterface(rGetSym);
                    switch (toColumnTypeTag) {
                        case 12: {
                            asm.invokeInterface(wPutSym, 2);
                            continue block178;
                        }
                        case 11: {
                            asm.invokeInterface(wPutStr, 2);
                            continue block178;
                        }
                        case 26: {
                            asm.invokeStatic(transferStrToVarcharCol);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 26: {
                    switch (toColumnTypeTag) {
                        case 26: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeInterface(wPutVarchar, 2);
                            continue block178;
                        }
                        case 11: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeInterface(transferVarcharToStrCol, 2);
                            continue block178;
                        }
                        case 25: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(implicitCastUtf8StrAsIPv4);
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(implicitCastVarcharAsLong);
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 3: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(implicitCastVarcharAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(implicitCastVarcharAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 2: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(implicitCastVarcharAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 4: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(implicitCastVarcharAsChar);
                            asm.invokeInterface(wPutChar, 2);
                            continue block178;
                        }
                        case 9: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(implicitCastVarcharAsFloat);
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(implicitCastVarcharAsDouble);
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                        case 19: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeInterface(wPutUuidUtf8, 2);
                            continue block178;
                        }
                        case 8: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(transferVarcharToTimestampCol);
                            continue block178;
                        }
                        case 12: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(transferVarcharToSymbolCol);
                            continue block178;
                        }
                        case 7: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeStatic(transferVarcharToDateCol);
                            continue block178;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeInterface(wPutGeoVarchar, 2);
                            continue block178;
                        }
                        case 13: {
                            asm.invokeInterface(rGetVarchar);
                            asm.invokeInterface(wPutLong256Utf8, 2);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 11: {
                    switch (toColumnTypeTag) {
                        case 27: {
                            asm.invokeInterface(rGetStrA);
                            asm.iconst(toColumnType);
                            asm.invokeStatic(validateArrayDimensionsAndTransferCol);
                            continue block178;
                        }
                        case 2: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 3: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 4: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsChar);
                            asm.invokeInterface(wPutChar, 2);
                            continue block178;
                        }
                        case 5: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 25: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsIPv4);
                            asm.invokeInterface(wPutIPv4, 2);
                            continue block178;
                        }
                        case 6: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsLong);
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                        case 9: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsFloat);
                            asm.invokeInterface(wPutFloat, 2);
                            continue block178;
                        }
                        case 10: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsDouble);
                            asm.invokeInterface(wPutDouble, 3);
                            continue block178;
                        }
                        case 12: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeInterface(wPutSym, 2);
                            continue block178;
                        }
                        case 7: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsDate);
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                        case 8: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsTimestamp);
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block178;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeInterface(wPutGeoStr, 2);
                            continue block178;
                        }
                        case 11: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeInterface(wPutStr, 2);
                            continue block178;
                        }
                        case 26: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(transferStrToVarcharCol);
                            continue block178;
                        }
                        case 19: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeInterface(wPutUuidStr, 2);
                            continue block178;
                        }
                        case 13: {
                            asm.invokeInterface(rGetStrA);
                            asm.invokeStatic(implicitCastStrAsLong256);
                            asm.invokeInterface(wPutLong256, 2);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 18: {
                    assert (toColumnTypeTag == 18);
                    asm.invokeInterface(rGetBin);
                    asm.invokeInterface(wPutBin, 2);
                    continue block178;
                }
                case 13: {
                    assert (toColumnTypeTag == 13);
                    asm.invokeInterface(rGetLong256);
                    asm.invokeInterface(wPutLong256, 2);
                    continue block178;
                }
                case 14: {
                    asm.invokeInterface(rGetGeoByte, 1);
                    if (fromColumnType != toColumnType && fromColumnType != 33 && fromColumnType != 14) {
                        asm.i2l();
                        asm.ldc(fromColumnType_0 + i * 2);
                        asm.ldc(toColumnType_0 + i * 2);
                        asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                        asm.l2i();
                        asm.i2b();
                    }
                    asm.invokeInterface(wPutByte, 2);
                    continue block178;
                }
                case 15: {
                    asm.invokeInterface(rGetGeoShort, 1);
                    if (ColumnType.tagOf(toColumnType) == 14) {
                        asm.i2l();
                        asm.ldc(fromColumnType_0 + i * 2);
                        asm.ldc(toColumnType_0 + i * 2);
                        asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                        asm.l2i();
                        asm.i2b();
                        asm.invokeInterface(wPutByte, 2);
                        continue block178;
                    }
                    if (fromColumnType != toColumnType && fromColumnType != 33 && fromColumnType != 15) {
                        asm.i2l();
                        asm.ldc(fromColumnType_0 + i * 2);
                        asm.ldc(toColumnType_0 + i * 2);
                        asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                        asm.l2i();
                        asm.i2s();
                        asm.invokeInterface(wPutShort, 2);
                        continue block178;
                    }
                    asm.invokeInterface(wPutShort, 2);
                    continue block178;
                }
                case 16: {
                    asm.invokeInterface(rGetGeoInt, 1);
                    switch (ColumnType.tagOf(toColumnType)) {
                        case 14: {
                            asm.i2l();
                            asm.ldc(fromColumnType_0 + i * 2);
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            asm.l2i();
                            asm.i2b();
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 15: {
                            asm.i2l();
                            asm.ldc(fromColumnType_0 + i * 2);
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            asm.l2i();
                            asm.i2s();
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 16: {
                            if (fromColumnType != toColumnType && fromColumnType != 33 && fromColumnType != 16) {
                                asm.i2l();
                                asm.ldc(fromColumnType_0 + i * 2);
                                asm.ldc(toColumnType_0 + i * 2);
                                asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                                asm.l2i();
                            }
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 17: {
                    asm.invokeInterface(rGetGeoLong, 1);
                    switch (ColumnType.tagOf(toColumnType)) {
                        case 14: {
                            asm.ldc(fromColumnType_0 + i * 2);
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            asm.l2i();
                            asm.i2b();
                            asm.invokeInterface(wPutByte, 2);
                            continue block178;
                        }
                        case 15: {
                            asm.ldc(fromColumnType_0 + i * 2);
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            asm.l2i();
                            asm.i2s();
                            asm.invokeInterface(wPutShort, 2);
                            continue block178;
                        }
                        case 16: {
                            asm.ldc(fromColumnType_0 + i * 2);
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            asm.l2i();
                            asm.invokeInterface(wPutInt, 2);
                            continue block178;
                        }
                        case 17: {
                            if (fromColumnType != toColumnType && fromColumnType != 33 && fromColumnType != 17) {
                                asm.ldc(fromColumnType_0 + i * 2);
                                asm.ldc(toColumnType_0 + i * 2);
                                asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            }
                            asm.invokeInterface(wPutLong, 3);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 19: 
                case 24: {
                    switch (ColumnType.tagOf(toColumnType)) {
                        case 19: 
                        case 24: {
                            asm.invokeInterface(rGetLong128Lo, 1);
                            asm.aload(1);
                            asm.iconst(i);
                            asm.invokeInterface(rGetLong128Hi, 1);
                            asm.invokeInterface(wPutLong128, 5);
                            continue block178;
                        }
                        case 11: {
                            assert (fromColumnType == 19);
                            asm.invokeInterface(rGetLong128Lo, 1);
                            asm.aload(1);
                            asm.iconst(i);
                            asm.invokeInterface(rGetLong128Hi, 1);
                            asm.invokeStatic(transferUuidToStrCol);
                            continue block178;
                        }
                        case 26: {
                            asm.invokeInterface(rGetLong128Lo, 1);
                            asm.aload(1);
                            asm.iconst(i);
                            asm.invokeInterface(rGetLong128Hi, 1);
                            asm.invokeStatic(transferUuidToVarcharCol);
                            continue block178;
                        }
                    }
                    assert (false);
                    continue block178;
                }
                case 27: {
                    if (ColumnType.tagOf(toColumnType) == 27) {
                        asm.ldc(fromColumnType_0 + i * 2);
                        asm.invokeInterface(rGetArray, 2);
                        asm.invokeInterface(wPutArray, 2);
                        continue block178;
                    }
                    assert (false);
                    continue block178;
                }
                default: {
                    assert (fromColumnType == 33);
                    continue block178;
                }
            }
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
        asm.putShort(0);
        return (RecordToRowCopier)asm.newInstance();
    }

    public static void transferStrToVarcharCol(TableWriter.Row row, int col, CharSequence str) {
        if (str == null) {
            return;
        }
        Utf8StringSink sink = Misc.getThreadLocalUtf8Sink();
        sink.put(str);
        row.putVarchar(col, sink);
    }

    public static void transferUuidToStrCol(TableWriter.Row row, int col, long lo, long hi) {
        StringSink threadLocalBuilder = Misc.getThreadLocalSink();
        if (SqlUtil.implicitCastUuidAsStr(lo, hi, threadLocalBuilder)) {
            row.putStr(col, threadLocalBuilder);
        }
    }

    public static void transferUuidToVarcharCol(TableWriter.Row row, int col, long lo, long hi) {
        Utf8StringSink sink = Misc.getThreadLocalUtf8Sink();
        if (SqlUtil.implicitCastUuidAsStr(lo, hi, sink)) {
            row.putVarchar(col, sink);
        }
    }

    public static void transferVarcharToDateCol(TableWriter.Row row, int col, Utf8Sequence seq) {
        if (seq == null) {
            return;
        }
        StringSink sink = Misc.getThreadLocalSink();
        sink.put(seq);
        long date = SqlUtil.implicitCastVarcharAsDate(sink);
        row.putDate(col, date);
    }

    public static void transferVarcharToSymbolCol(TableWriter.Row row, int col, Utf8Sequence seq) {
        if (seq == null) {
            return;
        }
        StringSink threadLocalBuilder = Misc.getThreadLocalSink();
        threadLocalBuilder.put(seq);
        row.putSym(col, threadLocalBuilder);
    }

    public static void transferVarcharToTimestampCol(TableWriter.Row row, int col, Utf8Sequence seq) {
        if (seq == null) {
            return;
        }
        StringSink sink = Misc.getThreadLocalSink();
        sink.put(seq);
        long ts = SqlUtil.implicitCastVarcharAsTimestamp(sink);
        row.putTimestamp(col, ts);
    }

    public static void validateArrayDimensionsAndTransferCol(TableWriter.Row row, int col, DoubleArrayParser parser, CharSequence str, int expectedType) {
        if (str == null) {
            return;
        }
        ArrayView view = SqlUtil.implicitCastStringAsDoubleArray(str, parser, expectedType);
        row.putArray(col, view);
    }

    private static boolean isArrayParserRequired(ColumnTypes from, RecordMetadata to, ColumnFilter toColumnFilter, int n) {
        for (int i = 0; i < n; ++i) {
            int toColumnIndex = toColumnFilter.getColumnIndexFactored(i);
            int toColumnType = to.getColumnType(toColumnIndex);
            int fromColumnType = from.getColumnType(i);
            if (ColumnType.tagOf(toColumnType) != 27 || ColumnType.tagOf(fromColumnType) != 11) continue;
            return true;
        }
        return false;
    }
}

