/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.std.BinarySequence;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import org.jetbrains.annotations.NotNull;

public abstract class CharFunction
implements Function {
    private final StringSink utf16SinkA = new StringSink();
    private final StringSink utf16SinkB = new StringSink();
    private final Utf8StringSink utf8SinkA = new Utf8StringSink();
    private final Utf8StringSink utf8SinkB = new Utf8StringSink();

    @Override
    public ArrayView getArray(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final BinarySequence getBin(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBinLen(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean getBool(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte getByte(Record rec) {
        return this.castCharToNumber(rec, 2);
    }

    @Override
    public final long getDate(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(Record rec) {
        return this.castCharToNumber(rec, 10);
    }

    @Override
    public float getFloat(Record rec) {
        return this.castCharToNumber(rec, 9);
    }

    @Override
    public byte getGeoByte(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGeoInt(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getGeoLong(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getGeoShort(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getIPv4(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(Record rec) {
        return this.castCharToNumber(rec, 5);
    }

    @Override
    @NotNull
    public Interval getInterval(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(Record rec) {
        return this.castCharToNumber(rec, 6);
    }

    @Override
    public long getLong128Hi(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong128Lo(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getLong256(Record rec, CharSink<?> sink) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long256 getLong256A(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long256 getLong256B(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RecordCursorFactory getRecordCursorFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(Record rec) {
        return this.castCharToNumber(rec, 3);
    }

    @Override
    public final CharSequence getStrA(Record rec) {
        char value = this.getChar(rec);
        if (value == '\u0000') {
            return null;
        }
        this.utf16SinkA.clear();
        this.utf16SinkA.put(value);
        return this.utf16SinkA;
    }

    @Override
    public final CharSequence getStrB(Record rec) {
        char value = this.getChar(rec);
        if (value == '\u0000') {
            return null;
        }
        this.utf16SinkB.clear();
        this.utf16SinkB.put(value);
        return this.utf16SinkB;
    }

    @Override
    public final int getStrLen(Record rec) {
        char value = this.getChar(rec);
        if (value == '\u0000') {
            return -1;
        }
        return 1;
    }

    @Override
    public final CharSequence getSymbol(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final CharSequence getSymbolB(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTimestamp(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getType() {
        return 4;
    }

    @Override
    public Utf8Sequence getVarcharA(Record rec) {
        char value = this.getChar(rec);
        if (value != '\u0000') {
            this.utf8SinkA.clear();
            this.utf8SinkA.put(this.getChar(rec));
            return this.utf8SinkA;
        }
        return null;
    }

    @Override
    public Utf8Sequence getVarcharB(Record rec) {
        char value = this.getChar(rec);
        if (value != '\u0000') {
            this.utf8SinkB.clear();
            this.utf8SinkB.put(this.getChar(rec));
            return this.utf8SinkB;
        }
        return null;
    }

    @Override
    public final int getVarcharSize(Record rec) {
        char value = this.getChar(rec);
        if (value == '\u0000') {
            return -1;
        }
        this.utf8SinkA.clear();
        this.utf8SinkA.put(this.getChar(rec));
        return this.utf8SinkA.size();
    }

    private byte castCharToNumber(Record rec, int toType) {
        char c = this.getChar(rec);
        byte v = (byte)(c - 48);
        if (v > -1 && v < 10) {
            return v;
        }
        throw ImplicitCastException.inconvertibleValue(c, 4, toType);
    }
}

