/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class DoubleArrayCountFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "array_count";

    @Override
    public String getSignature() {
        return "array_count(D[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0));
    }

    static class Func
    extends IntFunction
    implements UnaryFunction {
        private final Function arrayArg;

        Func(Function arrayArg) {
            this.arrayArg = arrayArg;
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public int getInt(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                return 0;
            }
            if (arr.isVanilla()) {
                return arr.flatView().countDouble(arr.getFlatViewOffset(), arr.getFlatViewLength());
            }
            return Func.calculateRecursive(arr, 0, 0, 0);
        }

        @Override
        public String getName() {
            return DoubleArrayCountFunctionFactory.FUNCTION_NAME;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private static int calculateRecursive(ArrayView view, int dim, int flatIndex, int count) {
            boolean atDeepestDim;
            int len = view.getDimLen(dim);
            int stride = view.getStride(dim);
            boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < len; ++i) {
                    double v = view.getDouble(flatIndex);
                    if (Numbers.isFinite(v)) {
                        ++count;
                    }
                    flatIndex += stride;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    count = Func.calculateRecursive(view, dim + 1, flatIndex, count);
                    flatIndex += stride;
                }
            }
            return count;
        }
    }
}

