/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class CastCharToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(As)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function func = args.getQuick(0);
        if (func.isConstant()) {
            char value = func.getChar(null);
            if (value == '\u0000') {
                return StrConstant.NULL;
            }
            return new StrConstant(String.valueOf(value));
        }
        return new Func(func);
    }

    private static class Func
    extends AbstractCastToStrFunction {
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public CharSequence getStrA(Record rec) {
            char value = this.arg.getChar(rec);
            if (value == '\u0000') {
                return null;
            }
            this.sinkA.clear();
            this.sinkA.put(value);
            return this.sinkA;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            char value = this.arg.getChar(rec);
            if (value == '\u0000') {
                return null;
            }
            this.sinkB.clear();
            this.sinkB.put(value);
            return this.sinkB;
        }
    }
}

