/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToBooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class CastDoubleToBooleanFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Dt)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToBooleanFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public boolean getBool(Record rec) {
            double dbl = this.arg.getDouble(rec);
            return !Numbers.isNull(dbl) && Math.signum(dbl) != 0.0;
        }
    }
}

