/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.pgwire.PGOids;

class PgProcCatalogueCursor
implements NoRandomAccessRecordCursor {
    static final RecordMetadata METADATA;
    private static final int rowCount;
    private final PgProdCatalogueRecord record = new PgProdCatalogueRecord();
    private int row = -1;

    PgProcCatalogueCursor() {
    }

    @Override
    public void close() {
        this.row = -1;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        return ++this.row < rowCount;
    }

    @Override
    public long size() {
        return rowCount;
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public void toTop() {
        this.row = -1;
    }

    static {
        rowCount = PGOids.PG_TYPE_TO_PROC_NAME.length;
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("oid", 5));
        metadata.add(new TableColumnMetadata("typname", 11));
        metadata.add(new TableColumnMetadata("typbasetype", 5));
        metadata.add(new TableColumnMetadata("typarray", 5));
        metadata.add(new TableColumnMetadata("typnamespace", 5));
        metadata.add(new TableColumnMetadata("typnotnull", 1));
        metadata.add(new TableColumnMetadata("typtypmod", 5));
        metadata.add(new TableColumnMetadata("typtype", 4));
        metadata.add(new TableColumnMetadata("typcategory", 4));
        metadata.add(new TableColumnMetadata("typrelid", 5));
        metadata.add(new TableColumnMetadata("typelem", 5));
        metadata.add(new TableColumnMetadata("typreceive", 5));
        metadata.add(new TableColumnMetadata("typdelim", 5));
        metadata.add(new TableColumnMetadata("typinput", 5));
        metadata.add(new TableColumnMetadata("typowner", 5));
        metadata.add(new TableColumnMetadata("typlen", 3));
        metadata.add(new TableColumnMetadata("typbyval", 1));
        metadata.add(new TableColumnMetadata("typispreferred", 1));
        metadata.add(new TableColumnMetadata("typisdefined", 1));
        metadata.add(new TableColumnMetadata("typalign", 4));
        metadata.add(new TableColumnMetadata("typstorage", 4));
        metadata.add(new TableColumnMetadata("typndims", 5));
        metadata.add(new TableColumnMetadata("typcollation", 5));
        metadata.add(new TableColumnMetadata("typdefault", 11));
        METADATA = metadata;
    }

    class PgProdCatalogueRecord
    implements Record {
        PgProdCatalogueRecord() {
        }

        @Override
        public boolean getBool(int col) {
            switch (col) {
                case 10: {
                    return false;
                }
                case 11: {
                    return false;
                }
                case 12: {
                    return true;
                }
                case 13: {
                    return false;
                }
            }
            throw new UnsupportedOperationException("not a bool col: " + col);
        }

        @Override
        public char getChar(int col) {
            switch (col) {
                case 9: {
                    return 'f';
                }
                case 14: {
                    return 'i';
                }
                case 15: {
                    return 's';
                }
            }
            throw new UnsupportedOperationException("not a char col: " + col);
        }

        @Override
        public float getFloat(int col) {
            return 0.0f;
        }

        @Override
        public int getInt(int col) {
            switch (col) {
                case 0: {
                    return PGOids.PG_TYPE_PROC_OIDS.get(PgProcCatalogueCursor.this.row);
                }
                case 2: {
                    return 2200;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 7: {
                    return 0;
                }
                case 8: {
                    return 0;
                }
                case 18: {
                    return PGOids.PG_TYPE_OIDS.get(PgProcCatalogueCursor.this.row);
                }
            }
            throw new UnsupportedOperationException("not a int col: " + col);
        }

        @Override
        public short getShort(int col) {
            switch (col) {
                case 16: {
                    return 1;
                }
                case 17: {
                    return 0;
                }
            }
            throw new UnsupportedOperationException("not a short col: " + col);
        }

        @Override
        public CharSequence getStrA(int col) {
            switch (col) {
                case 1: {
                    return PGOids.PG_TYPE_TO_PROC_NAME[PgProcCatalogueCursor.this.row];
                }
                case 19: {
                    return PGOids.PG_TYPE_TO_PROC_SRC[PgProcCatalogueCursor.this.row];
                }
                case 20: {
                    return null;
                }
            }
            throw new UnsupportedOperationException("not a string col: " + col);
        }

        @Override
        public CharSequence getStrB(int col) {
            return this.getStrA(col);
        }

        @Override
        public int getStrLen(int col) {
            return TableUtils.lengthOf(this.getStrA(col));
        }
    }
}

