/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.Long128Function;
import io.questdb.std.ObjList;

public class Long128Column
extends Long128Function
implements Function {
    private static final ObjList<Long128Column> COLUMNS = new ObjList(32);
    private final int columnIndex;

    private Long128Column(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static Long128Column newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new Long128Column(columnIndex);
    }

    @Override
    public long getLong128Hi(Record rec) {
        return rec.getLong128Hi(this.columnIndex);
    }

    @Override
    public long getLong128Lo(Record rec) {
        return rec.getLong128Lo(this.columnIndex);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new Long128Column(i));
        }
    }
}

