/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.conditional.CaseCommon;
import io.questdb.griffin.engine.functions.conditional.CaseFunctionPicker;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.IntList;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.ObjList;

public class SwitchFunctionFactory
implements FunctionFactory {
    private static final IntMethod GET_BYTE = SwitchFunctionFactory::getByte;
    private static final IntMethod GET_CHAR = SwitchFunctionFactory::getChar;
    private static final LongMethod GET_DATE = SwitchFunctionFactory::getDate;
    private static final IntMethod GET_INT = SwitchFunctionFactory::getInt;
    private static final LongMethod GET_LONG = SwitchFunctionFactory::getLong;
    private static final IntMethod GET_SHORT = SwitchFunctionFactory::getShort;
    private static final LongMethod GET_TIMESTAMP = SwitchFunctionFactory::getTimestamp;

    @Override
    public String getSignature() {
        return "switch(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int i;
        int elseBranchPosition;
        Function elseBranch;
        int n = args.size();
        Function keyFunction = args.getQuick(0);
        int keyType = keyFunction.getType();
        if (keyType == 0) {
            throw SqlException.$(argPositions.getQuick(0), "bind variable is not supported here, please use column instead");
        }
        int returnType = -1;
        if (n % 2 == 0) {
            elseBranch = args.getLast();
            elseBranchPosition = argPositions.getLast();
            returnType = elseBranch.getType();
            --n;
        } else {
            elseBranch = null;
            elseBranchPosition = -1;
        }
        for (i = 1; i < n; i += 2) {
            Function keyFunc = args.getQuick(i);
            int keyArgType = keyFunc.getType();
            if (!keyFunc.isConstant()) {
                throw SqlException.$(argPositions.getQuick(i), "constant expected");
            }
            if (!ColumnType.isAssignableFrom(keyArgType, keyType)) {
                throw SqlException.position(argPositions.getQuick(i)).put("type mismatch [expected=").put(ColumnType.nameOf(keyType)).put(", actual=").put(ColumnType.nameOf(keyArgType)).put(']');
            }
            returnType = CaseCommon.getCommonType(returnType, args.getQuick(i + 1).getType(), argPositions.getQuick(i + 1), "CASE values cannot be bind variables");
        }
        for (i = 2; i < n; i += 2) {
            args.setQuick(i, CaseCommon.getCastFunction(args.getQuick(i), argPositions.getQuick(i), returnType, configuration, sqlExecutionContext));
        }
        if (elseBranch != null) {
            elseBranch = CaseCommon.getCastFunction(elseBranch, elseBranchPosition, returnType, configuration, sqlExecutionContext);
        }
        switch (ColumnType.tagOf(keyType)) {
            case 4: {
                return this.getIntKeyedFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch, GET_CHAR);
            }
            case 5: 
            case 25: {
                return this.getIntKeyedFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch, GET_INT);
            }
            case 2: {
                return this.getIntKeyedFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch, GET_BYTE);
            }
            case 3: {
                return this.getIntKeyedFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch, GET_SHORT);
            }
            case 6: {
                return this.getLongKeyedFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch, GET_LONG);
            }
            case 9: {
                return this.getFloatKeyedFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch);
            }
            case 10: {
                return this.getDoubleKeyedFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch);
            }
            case 7: {
                return this.getLongKeyedFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch, GET_DATE);
            }
            case 8: {
                return this.getLongKeyedFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch, GET_TIMESTAMP);
            }
            case 1: {
                return this.getIfElseFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch);
            }
            case 11: 
            case 12: 
            case 26: {
                return this.getCharSequenceKeyedFunction(args, argPositions, position, n, keyFunction, returnType, elseBranch);
            }
        }
        throw SqlException.$(argPositions.getQuick(0), "type ").put(ColumnType.nameOf(keyType)).put(" is not supported in 'switch' type of 'case' statement");
    }

    @Override
    public int resolvePreferredVariadicType(int sqlPos, int argPos, ObjList<Function> args) throws SqlException {
        if (argPos == 0) {
            throw SqlException.$(sqlPos, "bind variable is not supported here, please use column instead");
        }
        throw SqlException.$(sqlPos, "CASE values cannot be bind variables");
    }

    private static byte getByte(Function function, Record record) {
        return function.getByte(record);
    }

    private static char getChar(Function function, Record record) {
        return function.getChar(record);
    }

    private static long getDate(Function function, Record record) {
        return function.getDate(record);
    }

    private static double getDouble(Function function, Record record) {
        return function.getDouble(record);
    }

    private static float getFloat(Function function, Record record) {
        return function.getFloat(record);
    }

    private static int getInt(Function function, Record record) {
        return function.getInt(record);
    }

    private static long getLong(Function function, Record record) {
        return function.getLong(record);
    }

    private static short getShort(Function function, Record record) {
        return function.getShort(record);
    }

    private static CharSequence getString(Function function, Record record) {
        return function.getStrA(record);
    }

    private static long getTimestamp(Function function, Record record) {
        return function.getTimestamp(record);
    }

    private Function getCharSequenceKeyedFunction(ObjList<Function> args, IntList argPositions, int position, int n, Function keyFunction, int valueType, Function elseBranch) throws SqlException {
        CaseFunctionPicker picker;
        CharSequenceObjHashMap<Function> map = new CharSequenceObjHashMap<Function>();
        ObjList<Function> argsToPoke = new ObjList<Function>();
        Function nullFunc = null;
        for (int i = 1; i < n; i += 2) {
            Function fun = args.getQuick(i);
            CharSequence key = SwitchFunctionFactory.getString(fun, null);
            if (key == null) {
                nullFunc = args.getQuick(i + 1);
                continue;
            }
            int index = map.keyIndex(key);
            if (index < 0) {
                throw SqlException.$(argPositions.getQuick(i), "duplicate branch");
            }
            map.putAt(index, key, args.getQuick(i + 1));
            argsToPoke.add(args.getQuick(i + 1));
        }
        Function elseB = this.getElseFunction(valueType, elseBranch);
        if (nullFunc == null) {
            picker = record -> {
                int index;
                CharSequence value = SwitchFunctionFactory.getString(keyFunction, record);
                if (value != null && (index = map.keyIndex(value)) < 0) {
                    return (Function)map.valueAtQuick(index);
                }
                return elseB;
            };
        } else {
            Function nullFuncRef = nullFunc;
            picker = record -> {
                CharSequence value = SwitchFunctionFactory.getString(keyFunction, record);
                if (value == null) {
                    return nullFuncRef;
                }
                int index = map.keyIndex(value);
                if (index < 0) {
                    return (Function)map.valueAtQuick(index);
                }
                return elseB;
            };
            argsToPoke.add(nullFunc);
        }
        argsToPoke.add(elseB);
        argsToPoke.add(keyFunction);
        return CaseCommon.getCaseFunction(position, valueType, picker, argsToPoke);
    }

    private Function getDoubleKeyedFunction(ObjList<Function> args, IntList argPositions, int position, int n, Function keyFunction, int valueType, Function elseBranch) throws SqlException {
        LongObjHashMap<Function> map = new LongObjHashMap<Function>();
        ObjList<Function> argsToPoke = new ObjList<Function>();
        for (int i = 1; i < n; i += 2) {
            Function fun = args.getQuick(i);
            long key = Double.doubleToLongBits(SwitchFunctionFactory.getDouble(fun, null));
            int index = map.keyIndex(key);
            if (index < 0) {
                throw SqlException.$(argPositions.getQuick(i), "duplicate branch");
            }
            map.putAt(index, key, args.getQuick(i + 1));
            argsToPoke.add(args.getQuick(i + 1));
        }
        Function elseB = this.getElseFunction(valueType, elseBranch);
        CaseFunctionPicker picker = record -> {
            int index = map.keyIndex(Double.doubleToLongBits(SwitchFunctionFactory.getDouble(keyFunction, record)));
            if (index < 0) {
                return (Function)map.valueAtQuick(index);
            }
            return elseB;
        };
        argsToPoke.add(elseB);
        argsToPoke.add(keyFunction);
        return CaseCommon.getCaseFunction(position, valueType, picker, argsToPoke);
    }

    private Function getElseFunction(int valueType, Function elseBranch) {
        return elseBranch != null ? elseBranch : Constants.getNullConstant(valueType);
    }

    private Function getFloatKeyedFunction(ObjList<Function> args, IntList argPositions, int position, int n, Function keyFunction, int valueType, Function elseBranch) throws SqlException {
        IntObjHashMap<Function> map = new IntObjHashMap<Function>();
        ObjList<Function> argsToPoke = new ObjList<Function>();
        for (int i = 1; i < n; i += 2) {
            Function fun = args.getQuick(i);
            int key = Float.floatToIntBits(SwitchFunctionFactory.getFloat(fun, null));
            int index = map.keyIndex(key);
            if (index < 0) {
                throw SqlException.$(argPositions.getQuick(i), "duplicate branch");
            }
            map.putAt(index, key, args.getQuick(i + 1));
            argsToPoke.add(args.getQuick(i + 1));
        }
        Function elseB = this.getElseFunction(valueType, elseBranch);
        CaseFunctionPicker picker = record -> {
            int index = map.keyIndex(Float.floatToIntBits(SwitchFunctionFactory.getFloat(keyFunction, record)));
            if (index < 0) {
                return (Function)map.valueAtQuick(index);
            }
            return elseB;
        };
        argsToPoke.add(elseB);
        argsToPoke.add(keyFunction);
        return CaseCommon.getCaseFunction(position, valueType, picker, argsToPoke);
    }

    private Function getIfElseFunction(ObjList<Function> args, IntList argPositions, int position, int n, Function keyFunction, int returnType, Function elseBranch) throws SqlException {
        ObjList<Function> argsToPoke;
        CaseFunctionPicker picker;
        if (n == 3) {
            boolean value = args.getQuick(1).getBool(null);
            Function branch = args.getQuick(2);
            Function elseB = this.getElseFunction(returnType, elseBranch);
            picker = value ? record -> keyFunction.getBool(record) ? branch : elseB : record -> keyFunction.getBool(record) ? elseB : branch;
            argsToPoke = new ObjList<Function>();
            argsToPoke.add(keyFunction);
            argsToPoke.add(elseB);
            argsToPoke.add(branch);
        } else if (n == 5) {
            boolean a = args.getQuick(1).getBool(null);
            Function branchA = args.getQuick(2);
            boolean b = args.getQuick(3).getBool(null);
            Function branchB = args.getQuick(4);
            if (a && b || !a && !b) {
                throw SqlException.$(argPositions.getQuick(3), "duplicate branch");
            }
            picker = a ? record -> keyFunction.getBool(record) ? branchA : branchB : record -> keyFunction.getBool(record) ? branchB : branchA;
            argsToPoke = new ObjList();
            argsToPoke.add(keyFunction);
            argsToPoke.add(branchA);
            argsToPoke.add(branchB);
        } else {
            throw SqlException.$(argPositions.getQuick(5), "too many branches");
        }
        return CaseCommon.getCaseFunction(position, returnType, picker, argsToPoke);
    }

    private Function getIntKeyedFunction(ObjList<Function> args, IntList argPositions, int position, int n, Function keyFunction, int valueType, Function elseBranch, IntMethod intMethod) throws SqlException {
        IntObjHashMap<Function> map = new IntObjHashMap<Function>();
        ObjList<Function> argsToPoke = new ObjList<Function>();
        for (int i = 1; i < n; i += 2) {
            Function fun = args.getQuick(i);
            int key = intMethod.getKey(fun, null);
            int index = map.keyIndex(key);
            if (index < 0) {
                throw SqlException.$(argPositions.getQuick(i), "duplicate branch");
            }
            map.putAt(index, key, args.getQuick(i + 1));
            argsToPoke.add(args.getQuick(i + 1));
        }
        Function elseB = this.getElseFunction(valueType, elseBranch);
        CaseFunctionPicker picker = record -> {
            int index = map.keyIndex(intMethod.getKey(keyFunction, record));
            if (index < 0) {
                return (Function)map.valueAtQuick(index);
            }
            return elseB;
        };
        argsToPoke.add(elseB);
        argsToPoke.add(keyFunction);
        return CaseCommon.getCaseFunction(position, valueType, picker, argsToPoke);
    }

    private Function getLongKeyedFunction(ObjList<Function> args, IntList argPositions, int position, int n, Function keyFunction, int valueType, Function elseBranch, LongMethod longMethod) throws SqlException {
        LongObjHashMap<Function> map = new LongObjHashMap<Function>();
        ObjList<Function> argsToPoke = new ObjList<Function>();
        for (int i = 1; i < n; i += 2) {
            Function fun = args.getQuick(i);
            long key = longMethod.getKey(fun, null);
            int index = map.keyIndex(key);
            if (index < 0) {
                throw SqlException.$(argPositions.getQuick(i), "duplicate branch");
            }
            map.putAt(index, key, args.getQuick(i + 1));
            argsToPoke.add(args.getQuick(i + 1));
        }
        Function elseB = this.getElseFunction(valueType, elseBranch);
        CaseFunctionPicker picker = record -> {
            int index = map.keyIndex(longMethod.getKey(keyFunction, record));
            if (index < 0) {
                return (Function)map.valueAtQuick(index);
            }
            return elseB;
        };
        argsToPoke.add(elseB);
        argsToPoke.add(keyFunction);
        return CaseCommon.getCaseFunction(position, valueType, picker, argsToPoke);
    }

    @FunctionalInterface
    private static interface IntMethod {
        public int getKey(Function var1, Record var2);
    }

    @FunctionalInterface
    private static interface LongMethod {
        public long getKey(Function var1, Record var2);
    }
}

