/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class SumFloatGroupByFunction
extends FloatFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public SumFloatGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        float value = this.arg.getFloat(record);
        if (Float.isFinite(value)) {
            mapValue.putFloat(this.valueIndex, value);
            mapValue.putLong(this.valueIndex + 1, 1L);
        } else {
            mapValue.putFloat(this.valueIndex, 0.0f);
            mapValue.putLong(this.valueIndex + 1, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        float value = this.arg.getFloat(record);
        if (Float.isFinite(value)) {
            mapValue.addFloat(this.valueIndex, value);
            mapValue.addLong(this.valueIndex + 1, 1L);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public float getFloat(Record rec) {
        long valueCount = rec.getLong(this.valueIndex + 1);
        if (valueCount > 0L) {
            return rec.getFloat(this.valueIndex);
        }
        return Float.NaN;
    }

    @Override
    public String getName() {
        return "sum";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(9);
        columnTypes.add(6);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        float srcSum = srcValue.getFloat(this.valueIndex);
        long srcCount = srcValue.getLong(this.valueIndex + 1);
        destValue.addFloat(this.valueIndex, srcSum);
        destValue.addLong(this.valueIndex + 1, srcCount);
    }

    @Override
    public void setFloat(MapValue mapValue, float value) {
        mapValue.putFloat(this.valueIndex, value);
        mapValue.putLong(this.valueIndex + 1, 1L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putFloat(this.valueIndex, Float.NaN);
        mapValue.putLong(this.valueIndex + 1, 0L);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

