/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.Nullable;

public class QuoteIdentVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "quote_ident(\u00d8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            Utf8Sequence val = arg.getVarcharA(null);
            if (val == null) {
                return VarcharConstant.NULL;
            }
            Utf8StringSink quotedVal = QuoteIdentVarcharFunction.quote(Misc.getThreadLocalUtf8Sink(), val);
            return new VarcharConstant(quotedVal);
        }
        return new QuoteIdentVarcharFunction(arg);
    }

    static class QuoteIdentVarcharFunction
    extends VarcharFunction
    implements UnaryFunction {
        private final Function arg;
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();

        public QuoteIdentVarcharFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public String getName() {
            return "quote_ident";
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharA(Record rec) {
            return QuoteIdentVarcharFunction.quote(this.sinkA, this.arg.getVarcharA(rec));
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharB(Record rec) {
            return QuoteIdentVarcharFunction.quote(this.sinkB, this.arg.getVarcharB(rec));
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private static Utf8StringSink quote(Utf8StringSink sink, Utf8Sequence utf8Str) {
            char c;
            int pc;
            int i;
            short n;
            if (utf8Str == null) {
                return null;
            }
            sink.clear();
            boolean needsQuoting = false;
            int len = Utf8s.length(utf8Str);
            for (i = 0; i < len; i += n) {
                pc = Utf8s.utf8CharDecode(utf8Str, i);
                n = Numbers.decodeLowShort(pc);
                c = (char)Numbers.decodeHighShort(pc);
                if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '$') continue;
                needsQuoting = true;
                break;
            }
            if (!needsQuoting) {
                sink.put(utf8Str);
            } else {
                sink.put('\"');
                for (i = 0; i < len; i += n) {
                    pc = Utf8s.utf8CharDecode(utf8Str, i);
                    n = Numbers.decodeLowShort(pc);
                    c = (char)Numbers.decodeHighShort(pc);
                    if (c != '\"') {
                        sink.put(c);
                        continue;
                    }
                    sink.put('\"').put('\"');
                }
                sink.put('\"');
            }
            return sink;
        }
    }
}

