/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;

public class StartsWithVarcharFunctionFactory
implements FunctionFactory {
    public static final String NAME = "starts_with";

    @Override
    public String getSignature() {
        return "starts_with(\u00d8\u00d8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function varcharFunc = args.get(0);
        Function prefixFunc = args.get(1);
        if (prefixFunc.isConstant()) {
            return new ConstFunc(varcharFunc, prefixFunc.getVarcharA(null));
        }
        return new Func(varcharFunc, prefixFunc);
    }

    public static class ConstFunc
    extends BooleanFunction
    implements UnaryFunction {
        protected final Utf8String startsWith;
        protected final Function value;
        private final long startsWithSixPrefix;

        public ConstFunc(Function value, Utf8Sequence startsWith) {
            this.value = value;
            if (startsWith != null) {
                this.startsWith = Utf8String.newInstance(startsWith);
                this.startsWithSixPrefix = startsWith.zeroPaddedSixPrefix();
            } else {
                this.startsWith = null;
                this.startsWithSixPrefix = 0L;
            }
        }

        public ConstFunc(Function value, CharSequence startsWith) {
            this.value = value;
            this.startsWith = new Utf8String(startsWith);
            this.startsWithSixPrefix = this.startsWith.zeroPaddedSixPrefix();
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            if (this.startsWith == null) {
                return false;
            }
            Utf8Sequence us = this.value.getVarcharA(rec);
            return us != null && Utf8s.startsWith(us, us.zeroPaddedSixPrefix(), this.startsWith, this.startsWithSixPrefix);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(StartsWithVarcharFunctionFactory.NAME).val('(');
            sink.val(this.value).val(", ");
            sink.val(this.startsWith).val(')');
        }
    }

    private static class Func
    extends BooleanFunction
    implements BinaryFunction {
        private final Function startsWith;
        private final Function value;

        public Func(Function value, Function startsWith) {
            this.value = value;
            this.startsWith = startsWith;
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence varchar = this.value.getVarcharA(rec);
            Utf8Sequence prefix = this.startsWith.getVarcharA(rec);
            if (varchar == null || prefix == null) {
                return false;
            }
            return Utf8s.startsWith(varchar, prefix);
        }

        @Override
        public Function getLeft() {
            return this.value;
        }

        @Override
        public String getName() {
            return StartsWithVarcharFunctionFactory.NAME;
        }

        @Override
        public Function getRight() {
            return this.startsWith;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(StartsWithVarcharFunctionFactory.NAME).val('(');
            sink.val(this.value).val(", ");
            sink.val(this.startsWith).val(')');
        }
    }
}

