/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicInteger;

public class TestOwnerCountingFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;
    private static final String SIGNATURE = "test_owner_counter()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new OwnerCountingCursorFactory(METADATA));
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("owners", 5));
        METADATA = metadata;
    }

    private static class OwnerCountingCursorFactory
    extends AbstractRecordCursorFactory {
        private final OwnerCountingRecordCursor cursor = new OwnerCountingRecordCursor();

        public OwnerCountingCursorFactory(RecordMetadata metadata) {
            super(metadata);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            return this.cursor.init();
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(TestOwnerCountingFunctionFactory.SIGNATURE);
        }
    }

    private static class OwnerCountingRecordCursor
    implements RecordCursor {
        private final OwnerCountingRecord record = new OwnerCountingRecord();
        private int remaining = 1;

        private OwnerCountingRecordCursor() {
        }

        @Override
        public void close() {
            this.record.release();
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public Record getRecordB() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.remaining-- > 0;
        }

        public RecordCursor init() {
            this.remaining = 1;
            this.record.acquire();
            return this;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void toTop() {
            this.remaining = 1;
        }
    }

    private static class OwnerCountingRecord
    implements Record {
        private final AtomicInteger counter = new AtomicInteger();

        private OwnerCountingRecord() {
        }

        public void acquire() {
            this.counter.incrementAndGet();
        }

        @Override
        public int getInt(int col) {
            return this.counter.get();
        }

        public void release() {
            this.counter.decrementAndGet();
        }
    }
}

