/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.AvgDoubleWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.BasePartitionedWindowFunction;
import io.questdb.griffin.engine.functions.window.BaseWindowFunction;
import io.questdb.griffin.engine.functions.window.WindowDoubleFunction;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class SumDoubleWindowFunctionFactory
extends AbstractWindowFunctionFactory {
    private static final String NAME = "sum";
    private static final String SIGNATURE = "sum(D)";
    private static final ArrayColumnTypes SUM_COLUMN_TYPES = new ArrayColumnTypes();

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        windowContext.validate(position, this.supportNullsDesc());
        int framingMode = windowContext.getFramingMode();
        RecordSink partitionBySink = windowContext.getPartitionBySink();
        ColumnTypes partitionByKeyTypes = windowContext.getPartitionByKeyTypes();
        VirtualRecord partitionByRecord = windowContext.getPartitionByRecord();
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (rowsHi < rowsLo) {
            return new AbstractWindowFunctionFactory.DoubleNullFunction(args.get(0), NAME, rowsLo, rowsHi, framingMode == 1, partitionByRecord);
        }
        if (partitionByRecord != null) {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, SUM_COLUMN_TYPES);
                    return new SumOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, SUM_COLUMN_TYPES);
                    return new SumOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                ArrayColumnTypes columnTypes = new ArrayColumnTypes();
                columnTypes.add(10);
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                Map map = null;
                MemoryCARW mem = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, columnTypes);
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    return new SumOverPartitionRangeFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, configuration.getSqlWindowInitialRangeBufferSize(), timestampIndex);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    Misc.free(mem);
                    throw th;
                }
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, SUM_COLUMN_TYPES);
                    return new SumOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new SumOverCurrentRowFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, SUM_COLUMN_TYPES);
                    return new SumOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                ArrayColumnTypes columnTypes = new ArrayColumnTypes();
                columnTypes.add(10);
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                Map map = null;
                MemoryCARW mem = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, columnTypes);
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    return new SumOverPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    Misc.free(mem);
                    throw th;
                }
            }
        } else {
            if (framingMode == 1) {
                if (!windowContext.isOrdered() && windowContext.isDefaultFrame()) {
                    return new SumOverWholeResultSetFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new SumOverUnboundedRowsFrameFunction(args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                return new SumOverRangeFrameFunction(rowsLo, rowsHi, args.get(0), configuration, timestampIndex);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new SumOverUnboundedRowsFrameFunction(args.get(0));
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new SumOverCurrentRowFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    return new SumOverWholeResultSetFunction(args.get(0));
                }
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new SumOverRowsFrameFunction(args.get(0), rowsLo, rowsHi, mem);
            }
        }
        throw SqlException.$(position, "function not implemented for given window parameters");
    }

    static {
        SUM_COLUMN_TYPES.add(10);
        SUM_COLUMN_TYPES.add(6);
    }

    static class SumOverPartitionFunction
    extends AvgDoubleWindowFunctionFactory.AvgOverPartitionFunction {
        public SumOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public String getName() {
            return SumDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public void preparePass2() {
            MapRecordCursor cursor = this.map.getCursor();
            MapRecord record = this.map.getRecord();
            while (cursor.hasNext()) {
                MapValue value = record.getValue();
                long count = value.getLong(1);
                if (count <= 0L) continue;
                double sum = value.getDouble(0);
                value.putDouble(0, sum);
            }
        }
    }

    static class SumOverUnboundedPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private double sum;

        public SumOverUnboundedPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public void computeNext(Record record) {
            long count;
            double sum;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            if (value.isNew()) {
                sum = 0.0;
                count = 0L;
            } else {
                sum = value.getDouble(0);
                count = value.getLong(1);
            }
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                sum += d;
                ++count;
            }
            value.putDouble(0, sum);
            value.putLong(1, count);
            this.sum = count != 0L ? sum : Double.NaN;
        }

        @Override
        public double getDouble(Record rec) {
            return this.sum;
        }

        @Override
        public String getName() {
            return SumDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.sum);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(SumDoubleWindowFunctionFactory.NAME);
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between unbounded preceding and current row)");
        }
    }

    public static class SumOverPartitionRangeFrameFunction
    extends AvgDoubleWindowFunctionFactory.AvgOverPartitionRangeFrameFunction {
        public SumOverPartitionRangeFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rangeLo, long rangeHi, Function arg, MemoryARW memory, int initialBufferSize, int timestampIdx) {
            super(map, partitionByRecord, partitionBySink, rangeLo, rangeHi, arg, memory, initialBufferSize, timestampIdx);
        }

        @Override
        public double getDouble(Record rec) {
            return this.sum;
        }

        @Override
        public String getName() {
            return SumDoubleWindowFunctionFactory.NAME;
        }
    }

    static class SumOverCurrentRowFunction
    extends AvgDoubleWindowFunctionFactory.AvgOverCurrentRowFunction {
        SumOverCurrentRowFunction(Function arg) {
            super(arg);
        }

        @Override
        public String getName() {
            return SumDoubleWindowFunctionFactory.NAME;
        }
    }

    public static class SumOverPartitionRowsFrameFunction
    extends AvgDoubleWindowFunctionFactory.AvgOverPartitionRowsFrameFunction {
        public SumOverPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rowsLo, long rowsHi, Function arg, MemoryARW memory) {
            super(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, arg, memory);
        }

        @Override
        public double getDouble(Record rec) {
            return this.sum;
        }

        @Override
        public String getName() {
            return SumDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.sum);
        }
    }

    static class SumOverWholeResultSetFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private long count;
        private double externalSum;
        private double sum;

        public SumOverWholeResultSetFunction(Function arg) {
            super(arg);
        }

        @Override
        public String getName() {
            return SumDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                this.sum += d;
                ++this.count;
            }
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.externalSum);
        }

        @Override
        public void preparePass2() {
            this.externalSum = this.count > 0L ? this.sum : Double.NaN;
        }

        @Override
        public void reset() {
            super.reset();
            this.externalSum = Double.NaN;
            this.count = 0L;
            this.sum = 0.0;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.externalSum = Double.NaN;
            this.count = 0L;
            this.sum = 0.0;
        }
    }

    public static class SumOverUnboundedRowsFrameFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private long count = 0L;
        private double externalSum;
        private double sum = 0.0;

        public SumOverUnboundedRowsFrameFunction(Function arg) {
            super(arg);
        }

        @Override
        public void computeNext(Record record) {
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                this.sum += d;
                ++this.count;
            }
            this.externalSum = this.count != 0L ? this.sum : Double.NaN;
        }

        @Override
        public double getDouble(Record rec) {
            return this.externalSum;
        }

        @Override
        public String getName() {
            return SumDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.externalSum);
        }

        @Override
        public void reset() {
            super.reset();
            this.externalSum = Double.NaN;
            this.count = 0L;
            this.sum = 0.0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(SumDoubleWindowFunctionFactory.NAME);
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (rows between unbounded preceding and current row)");
        }

        @Override
        public void toTop() {
            super.toTop();
            this.externalSum = Double.NaN;
            this.count = 0L;
            this.sum = 0.0;
        }
    }

    public static class SumOverRangeFrameFunction
    extends AvgDoubleWindowFunctionFactory.AvgOverRangeFrameFunction {
        public SumOverRangeFrameFunction(long rangeLo, long rangeHi, Function arg, CairoConfiguration configuration, int timestampIdx) {
            super(rangeLo, rangeHi, arg, configuration, timestampIdx);
        }

        public SumOverRangeFrameFunction(long rangeLo, long rangeHi, Function arg, long initialCapacity, MemoryARW memory, int timestampIdx) {
            super(rangeLo, rangeHi, arg, initialCapacity, memory, timestampIdx);
        }

        @Override
        public double getDouble(Record rec) {
            return this.externalSum;
        }

        @Override
        public String getName() {
            return SumDoubleWindowFunctionFactory.NAME;
        }
    }

    public static class SumOverRowsFrameFunction
    extends AvgDoubleWindowFunctionFactory.AvgOverRowsFrameFunction {
        public SumOverRowsFrameFunction(Function arg, long rowsLo, long rowsHi, MemoryARW memory) {
            super(arg, rowsLo, rowsHi, memory);
        }

        @Override
        public double getDouble(Record rec) {
            return this.externalSum;
        }

        @Override
        public String getName() {
            return SumDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.externalSum);
        }

        @Override
        public void toTop() {
            super.toTop();
            this.externalSum = 0.0;
        }
    }
}

