/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.constants.ByteConstant;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.constants.FloatConstant;
import io.questdb.griffin.engine.functions.constants.IPv4Constant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.ShortConstant;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.engine.functions.groupby.InterpolationGroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByFillRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdaterFactory;
import io.questdb.griffin.engine.groupby.GroupByRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueRecordCursor;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillValueRecordCursorFactory
extends AbstractSampleByFillRecordCursorFactory {
    private final SampleByFillValueRecordCursor cursor;

    public SampleByFillValueRecordCursorFactory(@NotNull BytecodeAssembler asm, CairoConfiguration configuration, RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, @NotNull ListColumnFilter listColumnFilter, @NotNull ObjList<ExpressionNode> fillValues, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, IntList recordFunctionPositions, int timestampIndex, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos, Function sampleFromFunc, int sampleFromFuncPos, Function sampleToFunc, int sampleToFuncPos) throws SqlException {
        super(asm, configuration, base, listColumnFilter, keyTypes, valueTypes, groupByMetadata, groupByFunctions, recordFunctions);
        try {
            ObjList<Function> placeholderFunctions = SampleByFillValueRecordCursorFactory.createPlaceholderFunctions(groupByFunctions, recordFunctions, recordFunctionPositions, fillValues, false);
            GroupByFunctionsUpdater updater = GroupByFunctionsUpdaterFactory.getInstance(asm, groupByFunctions);
            this.cursor = new SampleByFillValueRecordCursor(configuration, this.map, this.mapSink, groupByFunctions, updater, recordFunctions, placeholderFunctions, timestampIndex, timestampSampler, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
        }
        catch (Throwable e) {
            Misc.freeObjList(recordFunctions);
            Misc.free(this.map);
            throw e;
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Sample By");
        sink.attr("fill").val("value");
        sink.optAttr((CharSequence)"keys", GroupByRecordCursorFactory.getKeys(this.recordFunctions, this.getMetadata()));
        sink.optAttr((CharSequence)"values", this.cursor.groupByFunctions, true);
        sink.child(this.base);
    }

    static Function createPlaceHolderFunction(IntList recordFunctionPositions, int index, int type, ExpressionNode fillNode) throws SqlException {
        try {
            switch (ColumnType.tagOf(type)) {
                case 5: {
                    return IntConstant.newInstance(Numbers.parseInt(fillNode.token));
                }
                case 25: {
                    return IPv4Constant.newInstance(Numbers.parseIPv4(fillNode.token));
                }
                case 6: {
                    return LongConstant.newInstance(Numbers.parseLong(fillNode.token));
                }
                case 9: {
                    return FloatConstant.newInstance(Numbers.parseFloat(fillNode.token));
                }
                case 10: {
                    return DoubleConstant.newInstance(Numbers.parseDouble(fillNode.token));
                }
                case 3: {
                    return ShortConstant.newInstance((short)Numbers.parseInt(fillNode.token));
                }
                case 2: {
                    return ByteConstant.newInstance((byte)Numbers.parseInt(fillNode.token));
                }
                case 8: {
                    if (!Chars.isQuoted(fillNode.token)) {
                        throw SqlException.position(fillNode.position).put("Invalid fill value: '").put(fillNode.token).put("'. Timestamp fill value must be in quotes. Example: '2019-01-01T00:00:00.000Z'");
                    }
                    long ts = IntervalUtils.parseFloorPartialTimestamp(fillNode.token, 1, fillNode.token.length() - 1);
                    return TimestampConstant.newInstance(ts);
                }
            }
            throw SqlException.$(recordFunctionPositions.getQuick(index), "Unsupported type: ").put(ColumnType.nameOf(type));
        }
        catch (NumericException e) {
            throw SqlException.position(fillNode.position).put("invalid fill value: ").put(fillNode.token);
        }
    }

    @NotNull
    static ObjList<Function> createPlaceholderFunctions(ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, IntList recordFunctionPositions, @NotNull ObjList<ExpressionNode> fillValues, boolean linearSupported) throws SqlException {
        ObjList<Function> placeholderFunctions = new ObjList<Function>();
        int fillIndex = 0;
        int fillValueCount = fillValues.size();
        int n = recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            Function function = recordFunctions.getQuick(i);
            if (function instanceof GroupByFunction) {
                if (fillIndex == fillValueCount) {
                    throw SqlException.position(fillValues.getQuick((int)(fillIndex - 1)).position).put("insufficient fill values for SAMPLE BY FILL: expected ").put(groupByFunctions.size()).put(" values but only ").put(fillValueCount).put(" provided");
                }
                ExpressionNode fillNode = fillValues.getQuick(fillIndex++);
                if (SqlKeywords.isNullKeyword(fillNode.token)) {
                    placeholderFunctions.add(SampleByFillNullRecordCursorFactory.createPlaceHolderFunction(recordFunctionPositions, i, function.getType()));
                    continue;
                }
                if (SqlKeywords.isPrevKeyword(fillNode.token)) {
                    placeholderFunctions.add(function);
                    continue;
                }
                if (SqlKeywords.isLinearKeyword(fillNode.token)) {
                    if (!linearSupported) {
                        throw SqlException.position(0).put("linear interpolation is not supported when using fill values for keyed sample by expression");
                    }
                    InterpolationGroupByFunction interpolation = InterpolationGroupByFunction.newInstance((GroupByFunction)function);
                    placeholderFunctions.add(interpolation);
                    groupByFunctions.set(fillIndex - 1, interpolation);
                    recordFunctions.set(i, interpolation);
                    continue;
                }
                placeholderFunctions.add(SampleByFillValueRecordCursorFactory.createPlaceHolderFunction(recordFunctionPositions, i, function.getType(), fillNode));
                continue;
            }
            placeholderFunctions.add(function);
        }
        return placeholderFunctions;
    }

    @Override
    protected AbstractNoRecordSampleByCursor getRawCursor() {
        return this.cursor;
    }
}

