/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.griffin.engine.join.SymbolShortCircuit;

public final class SingleStringSymbolShortCircuit
implements SymbolShortCircuit {
    private final int masterStringIndex;
    private final int slaveSymbolIndex;
    private StaticSymbolTable slaveSymbolTable;

    public SingleStringSymbolShortCircuit(int masterStringIndex, int slaveSymbolIndex) {
        this.masterStringIndex = masterStringIndex;
        this.slaveSymbolIndex = slaveSymbolIndex;
    }

    @Override
    public boolean isShortCircuit(Record masterRecord) {
        CharSequence strA = masterRecord.getStrA(this.masterStringIndex);
        if (strA == null) {
            return this.slaveSymbolTable.containsNullValue();
        }
        int key = this.slaveSymbolTable.keyOf(strA);
        return key == -2;
    }

    @Override
    public void of(TimeFrameRecordCursor slaveCursor) {
        this.slaveSymbolTable = slaveCursor.getSymbolTable(this.slaveSymbolIndex);
    }
}

