/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import io.questdb.griffin.engine.ops.CreateMatViewOperation;
import io.questdb.griffin.engine.ops.CreateTableOperation;
import io.questdb.griffin.engine.ops.CreateTableOperationImpl;
import io.questdb.griffin.model.CreateTableColumnModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.mp.SCSequence;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMatViewOperationImpl
implements CreateMatViewOperation {
    private final String baseTableName;
    private final int baseTableNamePosition;
    private final LowerCaseCharSequenceObjHashMap<CreateTableColumnModel> createColumnModelMap = new LowerCaseCharSequenceObjHashMap();
    private final boolean deferred;
    private final int periodDelay;
    private final char periodDelayUnit;
    private final int periodLength;
    private final char periodLengthUnit;
    private final int refreshType;
    private final ArrayDeque<ExpressionNode> sqlNodeStack = new ArrayDeque();
    private final String sqlText;
    private final String timeZone;
    private final String timeZoneOffset;
    private final int timerInterval;
    private final long timerStart;
    private final String timerTimeZone;
    private final char timerUnit;
    private final IntList tmpColumnIndexes = new IntList();
    private final LowerCaseCharSequenceHashSet tmpLiterals = new LowerCaseCharSequenceHashSet();
    private final MatViewDefinition viewDefinition = new MatViewDefinition();
    private CreateTableOperationImpl createTableOperation;
    private long samplingInterval;
    private char samplingIntervalUnit;

    public CreateMatViewOperationImpl(@NotNull String sqlText, @NotNull CreateTableOperationImpl createTableOperation, int refreshType, boolean deferred, @NotNull String baseTableName, int baseTableNamePosition, @Nullable String timeZone, @Nullable String timeZoneOffset, int timerInterval, char timerUnit, long timerStart, @Nullable String timerTimeZone, int periodLength, char periodLengthUnit, int periodDelay, char periodDelayUnit) {
        this.sqlText = sqlText;
        this.createTableOperation = createTableOperation;
        this.refreshType = refreshType;
        this.deferred = deferred;
        this.baseTableName = baseTableName;
        this.baseTableNamePosition = baseTableNamePosition;
        this.timeZone = timeZone;
        this.timeZoneOffset = timeZoneOffset;
        this.timerInterval = timerInterval;
        this.timerUnit = timerUnit;
        this.timerStart = timerStart;
        this.timerTimeZone = timerTimeZone;
        this.periodLength = periodLength;
        this.periodLengthUnit = periodLengthUnit;
        this.periodDelay = periodDelay;
        this.periodDelayUnit = periodDelayUnit;
    }

    @Override
    public void close() {
        this.createTableOperation = Misc.free(this.createTableOperation);
    }

    @Override
    public OperationFuture execute(SqlExecutionContext sqlExecutionContext, @Nullable SCSequence eventSubSeq) throws SqlException {
        try (SqlCompiler compiler = sqlExecutionContext.getCairoEngine().getSqlCompiler();){
            compiler.execute(this, sqlExecutionContext);
        }
        return this.getOperationFuture();
    }

    @Override
    public CharSequence getBaseTableName() {
        return this.baseTableName;
    }

    @Override
    public int getColumnCount() {
        return this.createTableOperation.getColumnCount();
    }

    @Override
    public CharSequence getColumnName(int columnIndex) {
        return this.createTableOperation.getColumnName(columnIndex);
    }

    @Override
    public int getColumnType(int columnIndex) {
        return this.createTableOperation.getColumnType(columnIndex);
    }

    @Override
    public CreateTableOperation getCreateTableOperation() {
        return this.createTableOperation;
    }

    @Override
    public int getIndexBlockCapacity(int columnIndex) {
        return this.createTableOperation.getIndexBlockCapacity(columnIndex);
    }

    @Override
    public MatViewDefinition getMatViewDefinition() {
        return this.viewDefinition;
    }

    @Override
    public int getMaxUncommittedRows() {
        return this.createTableOperation.getMaxUncommittedRows();
    }

    @Override
    public long getO3MaxLag() {
        return this.createTableOperation.getO3MaxLag();
    }

    @Override
    public int getOperationCode() {
        return 4;
    }

    @Override
    public OperationFuture getOperationFuture() {
        return this.createTableOperation.getOperationFuture();
    }

    @Override
    public int getPartitionBy() {
        return this.createTableOperation.getPartitionBy();
    }

    @Override
    public int getRefreshType() {
        return this.refreshType;
    }

    @Override
    public CharSequence getSqlText() {
        return this.sqlText;
    }

    @Override
    public boolean getSymbolCacheFlag(int index) {
        return this.createTableOperation.getSymbolCacheFlag(index);
    }

    @Override
    public int getSymbolCapacity(int index) {
        return this.createTableOperation.getSymbolCapacity(index);
    }

    @Override
    public CharSequence getTableName() {
        return this.createTableOperation.getTableName();
    }

    @Override
    public int getTableNamePosition() {
        return this.createTableOperation.getTableNamePosition();
    }

    @Override
    public int getTimestampIndex() {
        return this.createTableOperation.getTimestampIndex();
    }

    @Override
    public int getTtlHoursOrMonths() {
        return this.createTableOperation.getTtlHoursOrMonths();
    }

    @Override
    public CharSequence getVolumeAlias() {
        return this.createTableOperation.getVolumeAlias();
    }

    @Override
    public int getVolumePosition() {
        return this.createTableOperation.getVolumePosition();
    }

    @Override
    public boolean ignoreIfExists() {
        return this.createTableOperation.ignoreIfExists();
    }

    @Override
    public void init(TableToken matViewToken) {
        this.viewDefinition.init(this.refreshType, this.deferred, matViewToken, Chars.toString(this.createTableOperation.getSelectText()), this.baseTableName, this.samplingInterval, this.samplingIntervalUnit, this.timeZone, this.timeZoneOffset, 0, this.timerInterval, this.timerUnit, this.timerStart, this.timerTimeZone, this.periodLength, this.periodLengthUnit, this.periodDelay, this.periodDelayUnit);
    }

    @Override
    public boolean isDedupKey(int index) {
        return this.createTableOperation.isDedupKey(index);
    }

    @Override
    public boolean isDeferred() {
        return this.deferred;
    }

    @Override
    public boolean isIndexed(int index) {
        return this.createTableOperation.isIndexed(index);
    }

    @Override
    public boolean isMatView() {
        return true;
    }

    @Override
    public boolean isWalEnabled() {
        assert (this.createTableOperation.isWalEnabled());
        return true;
    }

    @Override
    public void updateOperationFutureTableToken(TableToken tableToken) {
        this.createTableOperation.updateOperationFutureTableToken(tableToken);
    }

    @Override
    public void validateAndUpdateMetadataFromModel(@NotNull SqlExecutionContext sqlExecutionContext, @NotNull FunctionFactoryCache functionFactoryCache, @NotNull QueryModel queryModel) throws SqlException {
        QueryColumn queryColumn;
        ObjList<QueryColumn> columns = queryModel.getBottomUpColumns();
        assert (columns.size() > 0);
        this.createColumnModelMap.clear();
        LowerCaseCharSequenceObjHashMap<TableColumnMetadata> augColumnMetadataMap = this.createTableOperation.getAugmentedColumnMetadata();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn qc = columns.getQuick(i);
            CharSequence columnName = qc.getName();
            CreateTableColumnModel model = CreateTableColumnModel.FACTORY.newInstance();
            model.setColumnNamePos(qc.getAst().position);
            model.setColumnType(0);
            TableColumnMetadata augColumnMetadata = augColumnMetadataMap.get(columnName);
            if (augColumnMetadata != null && augColumnMetadata.isSymbolIndexFlag()) {
                model.setIndexed(true, qc.getAst().position, augColumnMetadata.getIndexValueBlockCapacity());
            }
            this.createColumnModelMap.put(columnName, model);
        }
        String timestamp = this.createTableOperation.getTimestampColumnName();
        int timestampPos = this.createTableOperation.getTimestampColumnNamePosition();
        if (timestamp != null) {
            CreateTableColumnModel timestampModel = this.createColumnModelMap.get(timestamp);
            if (timestampModel == null) {
                throw SqlException.position(timestampPos).put("TIMESTAMP column does not exist [name=").put(timestamp).put(']');
            }
            int timestampType = timestampModel.getColumnType();
            if (timestampType != 8 && timestampType != 0) {
                throw SqlException.position(timestampPos).put("TIMESTAMP column expected [actual=").put(ColumnType.nameOf(timestampType)).put(']');
            }
        }
        int selectTextPosition = this.createTableOperation.getSelectTextPosition();
        TableToken baseTableToken = sqlExecutionContext.getTableTokenIfExists(this.baseTableName);
        if (baseTableToken == null) {
            throw SqlException.tableDoesNotExist(this.baseTableNamePosition, this.baseTableName);
        }
        if (!baseTableToken.isWal()) {
            throw SqlException.$(this.baseTableNamePosition, "base table has to be WAL enabled");
        }
        CharSequence intervalExpr = null;
        int intervalPos = 0;
        ExpressionNode sampleBy = CreateMatViewOperationImpl.findSampleByNode(queryModel);
        if (sampleBy != null && sampleBy.type == 4) {
            intervalExpr = sampleBy.token;
            intervalPos = sampleBy.position;
        }
        if (intervalExpr == null && (queryColumn = CreateMatViewOperationImpl.findTimestampFloorColumn(queryModel)) != null) {
            ExpressionNode ast = queryColumn.getAst();
            if (ast.paramCount == 3 || ast.paramCount == 5) {
                int idx = ast.paramCount - 1;
                intervalExpr = ast.args.getQuick((int)idx).token;
                intervalPos = ast.args.getQuick((int)idx).position;
            } else {
                intervalExpr = ast.lhs.token;
                intervalPos = ast.lhs.position;
            }
            if (timestamp == null) {
                this.createTableOperation.setTimestampColumnName(Chars.toString(queryColumn.getName()));
                this.createTableOperation.setTimestampColumnNamePosition(ast.position);
                CreateTableColumnModel timestampModel = this.createColumnModelMap.get(queryColumn.getName());
                if (timestampModel == null) {
                    throw SqlException.position(selectTextPosition).put("TIMESTAMP column does not exist or not present in select list [name=").put(queryColumn.getName()).put(']');
                }
            }
        }
        if (intervalExpr == null) {
            throw SqlException.$(selectTextPosition, "TIMESTAMP column is not present in select list");
        }
        CharSequence interval = GenericLexer.unquote(intervalExpr);
        int samplingIntervalEnd = TimestampSamplerFactory.findIntervalEndIndex(interval, intervalPos, "sample");
        assert (samplingIntervalEnd < interval.length());
        this.samplingInterval = TimestampSamplerFactory.parseInterval(interval, samplingIntervalEnd, intervalPos, "sample", Integer.MIN_VALUE, ' ');
        assert (this.samplingInterval > 0L);
        this.samplingIntervalUnit = interval.charAt(samplingIntervalEnd);
        if (this.createTableOperation.getPartitionBy() == 3) {
            TimestampSampler timestampSampler = TimestampSamplerFactory.getInstance(this.samplingInterval, this.samplingIntervalUnit, 0);
            long approxBucketMicros = timestampSampler.getApproxBucketSize();
            int partitionBy = approxBucketMicros > 3600000000L ? 2 : (approxBucketMicros > 60000000L ? 1 : 0);
            this.createTableOperation.setPartitionBy(partitionBy);
            int ttlHoursOrMonths = this.createTableOperation.getTtlHoursOrMonths();
            if (ttlHoursOrMonths > 0) {
                PartitionBy.validateTtlGranularity(partitionBy, ttlHoursOrMonths, this.createTableOperation.getTtlPosition());
            }
        }
        CairoEngine engine = sqlExecutionContext.getCairoEngine();
        try (TableMetadata baseTableMetadata = engine.getTableMetadata(baseTableToken);){
            int n2 = columns.size();
            for (int i = 0; i < n2; ++i) {
                QueryColumn column = columns.getQuick(i);
                if (!this.hasNoAggregates(functionFactoryCache, queryModel, i)) continue;
                CreateTableColumnModel columnModel = this.createColumnModelMap.get(column.getName());
                if (columnModel == null) {
                    throw SqlException.$(0, "missing column [name=").put(column.getName()).put(']');
                }
                CreateMatViewOperationImpl.copyBaseTableSymbolColumnCapacity(column.getAst(), queryModel, columnModel, this.baseTableName, baseTableMetadata);
            }
        }
        this.createTableOperation.initColumnMetadata(this.createColumnModelMap);
    }

    @Override
    public void validateAndUpdateMetadataFromSelect(@NotNull RecordMetadata selectMetadata, @NotNull TableReaderMetadata baseTableMetadata) throws SqlException {
        int selectTextPosition = this.createTableOperation.getSelectTextPosition();
        if (this.createTableOperation.getTimestampColumnName() == null && selectMetadata.getTimestampIndex() == -1) {
            throw SqlException.position(selectTextPosition).put("materialized view query is required to have designated timestamp");
        }
        this.createTableOperation.validateAndUpdateMetadataFromSelect(selectMetadata);
    }

    private static void copyBaseTableSymbolColumnCapacity(@Nullable ExpressionNode columnNode, @Nullable QueryModel queryModel, @NotNull CreateTableColumnModel columnModel, @NotNull CharSequence baseTableName, @NotNull TableMetadata baseTableMetadata) {
        if (columnNode != null && queryModel != null) {
            if (columnNode.type == 7) {
                if (queryModel.getTableName() != null) {
                    TableColumnMetadata baseTableColumnMetadata;
                    int columnIndex;
                    CharSequence columnName;
                    if (Chars.equalsIgnoreCase(queryModel.getTableName(), baseTableName) && (columnName = CreateMatViewOperationImpl.resolveColumnName(columnNode, queryModel)) != null && (columnIndex = baseTableMetadata.getColumnIndexQuiet(columnName)) > -1 && (baseTableColumnMetadata = baseTableMetadata.getColumnMetadata(columnIndex)).getColumnType() == 12) {
                        columnModel.setSymbolCapacity(baseTableColumnMetadata.getSymbolCapacity());
                    }
                } else {
                    QueryColumn column = queryModel.getAliasToColumnMap().get(columnNode.token);
                    CreateMatViewOperationImpl.copyBaseTableSymbolColumnCapacity(column != null ? column.getAst() : columnNode, queryModel.getNestedModel(), columnModel, baseTableName, baseTableMetadata);
                }
            }
            int n = queryModel.getJoinModels().size();
            for (int i = 1; i < n; ++i) {
                CreateMatViewOperationImpl.copyBaseTableSymbolColumnCapacity(columnNode, queryModel.getJoinModels().getQuick(i), columnModel, baseTableName, baseTableMetadata);
            }
            CreateMatViewOperationImpl.copyBaseTableSymbolColumnCapacity(columnNode, queryModel.getUnionModel(), columnModel, baseTableName, baseTableMetadata);
        }
    }

    private static ExpressionNode findSampleByNode(QueryModel model) {
        while (model != null && !SqlUtil.isNotPlainSelectModel(model)) {
            ExpressionNode sampleBy = model.getSampleBy();
            if (sampleBy != null && sampleBy.type == 4) {
                return sampleBy;
            }
            model = model.getNestedModel();
        }
        return null;
    }

    private static QueryColumn findTimestampFloorColumn(QueryModel model) {
        while (model != null && !SqlUtil.isNotPlainSelectModel(model)) {
            ObjList<QueryColumn> queryColumns = model.getBottomUpColumns();
            int n = queryColumns.size();
            for (int i = 0; i < n; ++i) {
                QueryColumn queryColumn = queryColumns.getQuick(i);
                ExpressionNode ast = queryColumn.getAst();
                if (ast.type != 6 || !Chars.equalsIgnoreCase("timestamp_floor", ast.token)) continue;
                return queryColumn;
            }
            model = model.getNestedModel();
        }
        return null;
    }

    @Nullable
    private static CharSequence resolveColumnName(ExpressionNode columnNode, QueryModel queryModel) {
        int dotIndex = Chars.indexOfLastUnquoted(columnNode.token, '.');
        if (dotIndex > -1) {
            if (Chars.equalsIgnoreCase(queryModel.getName(), columnNode.token, 0, dotIndex)) {
                return columnNode.token.subSequence(dotIndex + 1, columnNode.token.length());
            }
        } else {
            return columnNode.token;
        }
        return null;
    }

    private boolean hasNoAggregates(FunctionFactoryCache functionFactoryCache, QueryModel queryModel, int columnIndex) {
        this.tmpColumnIndexes.clear();
        this.tmpColumnIndexes.add(columnIndex);
        block4: while (true) {
            int i;
            this.tmpLiterals.clear();
            int n = this.tmpColumnIndexes.size();
            for (i = 0; i < n; ++i) {
                int idx = this.tmpColumnIndexes.getQuick(i);
                ExpressionNode node = queryModel.getBottomUpColumns().getQuick(idx).getAst();
                this.sqlNodeStack.clear();
                block6: while (!this.sqlNodeStack.isEmpty() || node != null) {
                    if (node != null) {
                        switch (node.type) {
                            case 7: {
                                this.tmpLiterals.add(node.token);
                                node = null;
                                continue block6;
                            }
                            case 6: {
                                if (!functionFactoryCache.isGroupBy(node.token)) break;
                                return false;
                            }
                            default: {
                                int m = node.args.size();
                                for (int j = 0; j < m; ++j) {
                                    this.sqlNodeStack.add(node.args.getQuick(j));
                                }
                                if (node.rhs == null) break;
                                this.sqlNodeStack.push(node.rhs);
                            }
                        }
                        node = node.lhs;
                        continue;
                    }
                    node = this.sqlNodeStack.poll();
                }
            }
            if (queryModel.getNestedModel() == null || SqlUtil.isNotPlainSelectModel(queryModel)) {
                return true;
            }
            queryModel = queryModel.getNestedModel();
            this.tmpColumnIndexes.clear();
            i = 0;
            n = queryModel.getBottomUpColumns().size();
            while (true) {
                if (i >= n) continue block4;
                QueryColumn column = queryModel.getBottomUpColumns().getQuick(i);
                if (this.tmpLiterals.contains(column.getAlias())) {
                    this.tmpColumnIndexes.add(i);
                }
                ++i;
            }
            break;
        }
    }
}

