/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.RecordTreeChain;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.SortedRecordCursor;
import org.jetbrains.annotations.NotNull;

public class SortedRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final SortedRecordCursor cursor;
    private final ListColumnFilter sortColumnFilter;

    public SortedRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull RecordCursorFactory base, @NotNull RecordSink recordSink, @NotNull RecordComparator comparator, @NotNull ListColumnFilter sortColumnFilter) {
        super(metadata);
        RecordTreeChain chain = new RecordTreeChain(metadata, recordSink, comparator, configuration.getSqlSortKeyPageSize(), configuration.getSqlSortKeyMaxPages(), configuration.getSqlSortValuePageSize(), configuration.getSqlSortValueMaxPages());
        this.base = base;
        this.cursor = new SortedRecordCursor(chain);
        this.sortColumnFilter = sortColumnFilter;
    }

    public static int getScanDirection(ListColumnFilter sortColumnFilter) {
        assert (sortColumnFilter.size() > 0);
        return SortedRecordCursorFactory.toOrder(sortColumnFilter.get(0));
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable th) {
            this.cursor.close();
            throw th;
        }
    }

    @Override
    public int getScanDirection() {
        return SortedRecordCursorFactory.getScanDirection(this.sortColumnFilter);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Sort");
        SortedLightRecordCursorFactory.addSortKeys(sink, this.sortColumnFilter);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    private static int toOrder(int filter) {
        if (filter >= 0) {
            return 1;
        }
        return 2;
    }

    @Override
    protected void _close() {
        this.base.close();
        this.cursor.close();
    }
}

