/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class LatestByLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final int ROW_ID_VALUE_IDX = 0;
    private static final int TIMESTAMP_VALUE_IDX = 1;
    private final RecordCursorFactory base;
    private final LatestByLightRecordCursor cursor;
    private final boolean orderedByTimestampAsc;
    private final RecordSink recordSink;
    private final int timestampIndex;

    public LatestByLightRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordCursorFactory base, @NotNull RecordSink recordSink, @NotNull ColumnTypes columnTypes, int timestampIndex, boolean orderedByTimestampAsc) {
        super(base.getMetadata());
        assert (base.recordCursorSupportsRandomAccess());
        this.base = base;
        this.recordSink = recordSink;
        ArrayColumnTypes mapValueTypes = new ArrayColumnTypes();
        mapValueTypes.add(0, 6);
        if (!orderedByTimestampAsc) {
            mapValueTypes.add(1, 8);
        }
        Map latestByMap = MapFactory.createOrderedMap(configuration, columnTypes, mapValueTypes);
        this.cursor = new LatestByLightRecordCursor(latestByMap);
        this.timestampIndex = timestampIndex;
        this.orderedByTimestampAsc = orderedByTimestampAsc;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        this.cursor.of(baseCursor, circuitBreaker);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestBy light");
        sink.meta("order_by_timestamp").val(this.orderedByTimestampAsc);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        this.base.close();
        this.cursor.close();
    }

    private class LatestByLightRecordCursor
    implements RecordCursor {
        private final Map latestByMap;
        private RecordCursor baseCursor;
        private Record baseRecord;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isMapBuilt;
        private boolean isOpen;
        private RecordCursor mapCursor;
        private MapRecord mapRecord;

        public LatestByLightRecordCursor(Map latestByMap) {
            this.latestByMap = latestByMap;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                Misc.free(this.baseCursor);
                Misc.free(this.mapCursor);
                Misc.free(this.latestByMap);
            }
        }

        @Override
        public Record getRecord() {
            return this.baseRecord;
        }

        @Override
        public Record getRecordB() {
            return this.baseCursor.getRecordB();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            if (!this.isMapBuilt) {
                this.buildMap();
                this.toTop();
                this.isMapBuilt = true;
            }
            if (!this.mapCursor.hasNext()) {
                return false;
            }
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            MapValue value = this.mapRecord.getValue();
            long rowId = value.getLong(0);
            this.baseCursor.recordAt(this.baseRecord, rowId);
            return true;
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(columnIndex);
        }

        public void of(RecordCursor baseCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.latestByMap.reopen();
            }
            this.baseCursor = baseCursor;
            this.baseRecord = baseCursor.getRecord();
            this.circuitBreaker = circuitBreaker;
            this.isMapBuilt = false;
        }

        @Override
        public long preComputedStateSize() {
            return this.isMapBuilt ? 1L : 0L;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.baseCursor.recordAt(record, atRowId);
        }

        @Override
        public long size() {
            return this.isMapBuilt ? this.mapCursor.size() : -1L;
        }

        @Override
        public void toTop() {
            if (this.mapCursor != null) {
                this.mapCursor.toTop();
            }
        }

        private void buildMap() {
            if (LatestByLightRecordCursorFactory.this.orderedByTimestampAsc) {
                this.buildMapForOrderedSubQuery();
            } else {
                this.buildMapForUnorderedSubQuery();
            }
            this.mapCursor = this.latestByMap.getCursor();
            this.mapRecord = (MapRecord)this.mapCursor.getRecord();
        }

        private void buildMapForOrderedSubQuery() {
            while (this.baseCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.latestByMap.withKey();
                LatestByLightRecordCursorFactory.this.recordSink.copy(this.baseRecord, key);
                MapValue value = key.createValue();
                value.putLong(0, this.baseRecord.getRowId());
            }
        }

        private void buildMapForUnorderedSubQuery() {
            while (this.baseCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.latestByMap.withKey();
                LatestByLightRecordCursorFactory.this.recordSink.copy(this.baseRecord, key);
                MapValue value = key.createValue();
                if (value.isNew()) {
                    value.putLong(0, this.baseRecord.getRowId());
                    value.putTimestamp(1, this.baseRecord.getTimestamp(LatestByLightRecordCursorFactory.this.timestampIndex));
                    continue;
                }
                long prevTimestamp = value.getTimestamp(1);
                long newTimestamp = this.baseRecord.getTimestamp(LatestByLightRecordCursorFactory.this.timestampIndex);
                if (newTimestamp < prevTimestamp) continue;
                value.putLong(0, this.baseRecord.getRowId());
                value.putTimestamp(1, newTimestamp);
            }
        }
    }
}

