/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.PageFrameRecordCursorImpl;
import io.questdb.griffin.engine.table.SortedSymbolIndexRowCursorFactory;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class SortedSymbolIndexRecordCursorFactory
extends AbstractPageFrameRecordCursorFactory {
    private final PageFrameRecordCursorImpl cursor;

    public SortedSymbolIndexRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, int columnIndex, boolean columnOrderAsc, int indexDirection, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        this.cursor = new PageFrameRecordCursorImpl(configuration, metadata, new SortedSymbolIndexRowCursorFactory(columnIndex, columnOrderAsc, indexDirection), true, null);
    }

    @Override
    public boolean followedOrderByAdvice() {
        return true;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("SortedSymbolIndex");
        sink.child(this.cursor.getRowCursorFactory());
        sink.child(this.partitionFrameCursorFactory);
    }

    @Override
    public boolean usesIndex() {
        return true;
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.cursor);
    }

    @Override
    protected RecordCursor initRecordCursor(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.cursor.of(pageFrameCursor, executionContext);
        return this.cursor;
    }
}

