/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table.parquet;

import io.questdb.cairo.Reopenable;
import io.questdb.std.Os;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;

public class RowGroupStatBuffers
implements QuietCloseable,
Reopenable {
    private static final long CHUNK_STATS_MAX_VALUE_PTR_OFFSET;
    private static final long CHUNK_STATS_MAX_VALUE_SIZE_OFFSET;
    private static final long CHUNK_STATS_MIN_VALUE_PTR_OFFSET;
    private static final long CHUNK_STATS_MIN_VALUE_SIZE_OFFSET;
    private static final long CHUNK_STATS_PTR_OFFSET;
    private static final long CHUNK_STATS_STRUCT_SIZE;
    private final int memoryTag;
    private long ptr;

    public RowGroupStatBuffers(int memoryTag) {
        this.ptr = RowGroupStatBuffers.create(Unsafe.getNativeAllocator(memoryTag));
        this.memoryTag = memoryTag;
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            RowGroupStatBuffers.destroy(this.ptr);
            this.ptr = 0L;
        }
    }

    public long getMaxValueLong(int columnIndex) {
        long size = this.getMaxValueSize(columnIndex);
        assert (size == 8L);
        long ptr = this.getMaxValuePtr(columnIndex);
        assert (ptr != 0L);
        return Unsafe.getUnsafe().getLong(ptr);
    }

    public long getMaxValuePtr(int columnIndex) {
        long statBuffersPtr = Unsafe.getUnsafe().getLong(this.ptr + CHUNK_STATS_PTR_OFFSET);
        return Unsafe.getUnsafe().getLong(statBuffersPtr + (long)columnIndex * CHUNK_STATS_STRUCT_SIZE + CHUNK_STATS_MAX_VALUE_PTR_OFFSET);
    }

    public long getMaxValueSize(int columnIndex) {
        long statBuffersPtr = Unsafe.getUnsafe().getLong(this.ptr + CHUNK_STATS_PTR_OFFSET);
        return Unsafe.getUnsafe().getLong(statBuffersPtr + (long)columnIndex * CHUNK_STATS_STRUCT_SIZE + CHUNK_STATS_MAX_VALUE_SIZE_OFFSET);
    }

    public long getMinValueLong(int columnIndex) {
        long size = this.getMinValueSize(columnIndex);
        assert (size == 8L);
        long ptr = this.getMinValuePtr(columnIndex);
        assert (ptr != 0L);
        return Unsafe.getUnsafe().getLong(ptr);
    }

    public long getMinValuePtr(int columnIndex) {
        long statBuffersPtr = Unsafe.getUnsafe().getLong(this.ptr + CHUNK_STATS_PTR_OFFSET);
        return Unsafe.getUnsafe().getLong(statBuffersPtr + (long)columnIndex * CHUNK_STATS_STRUCT_SIZE + CHUNK_STATS_MIN_VALUE_PTR_OFFSET);
    }

    public long getMinValueSize(int columnIndex) {
        long statBuffersPtr = Unsafe.getUnsafe().getLong(this.ptr + CHUNK_STATS_PTR_OFFSET);
        return Unsafe.getUnsafe().getLong(statBuffersPtr + (long)columnIndex * CHUNK_STATS_STRUCT_SIZE + CHUNK_STATS_MIN_VALUE_SIZE_OFFSET);
    }

    public long ptr() {
        return this.ptr;
    }

    @Override
    public void reopen() {
        if (this.ptr == 0L) {
            this.ptr = RowGroupStatBuffers.create(Unsafe.getNativeAllocator(this.memoryTag));
        }
    }

    private static native long buffersPtrOffset();

    private static native long buffersSize();

    private static native long create(long var0);

    private static native void destroy(long var0);

    private static native long maxValuePtrOffset();

    private static native long maxValueSizeOffset();

    private static native long minValuePtrOffset();

    private static native long minValueSizeOffset();

    static {
        Os.init();
        CHUNK_STATS_PTR_OFFSET = RowGroupStatBuffers.buffersPtrOffset();
        CHUNK_STATS_STRUCT_SIZE = RowGroupStatBuffers.buffersSize();
        CHUNK_STATS_MIN_VALUE_PTR_OFFSET = RowGroupStatBuffers.minValuePtrOffset();
        CHUNK_STATS_MIN_VALUE_SIZE_OFFSET = RowGroupStatBuffers.minValueSizeOffset();
        CHUNK_STATS_MAX_VALUE_PTR_OFFSET = RowGroupStatBuffers.maxValuePtrOffset();
        CHUNK_STATS_MAX_VALUE_SIZE_OFFSET = RowGroupStatBuffers.maxValueSizeOffset();
    }
}

