/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.union.AbstractSetRecordCursor;
import io.questdb.griffin.engine.union.AbstractUnionRecord;
import io.questdb.griffin.engine.union.UnionCastRecord;
import io.questdb.griffin.engine.union.UnionRecord;
import io.questdb.std.ObjList;

class UnionRecordCursor
extends AbstractSetRecordCursor
implements NoRandomAccessRecordCursor {
    private final Map map;
    private final NextMethod nextB = this::nextB;
    private final AbstractUnionRecord record;
    private final RecordSink recordSink;
    private boolean isOpen;
    private NextMethod nextMethod;
    private final NextMethod nextA = this::nextA;

    public UnionRecordCursor(Map map, RecordSink recordSink, ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB) {
        if (castFunctionsA != null && castFunctionsB != null) {
            this.record = new UnionCastRecord(castFunctionsA, castFunctionsB);
        } else {
            assert (castFunctionsA == null && castFunctionsB == null);
            this.record = new UnionRecord();
        }
        this.map = map;
        this.isOpen = true;
        this.recordSink = recordSink;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.map.close();
            super.close();
        }
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        boolean next;
        while (next = this.nextMethod.next()) {
            MapKey key = this.map.withKey();
            key.put(this.record, this.recordSink);
            if (key.create()) {
                return true;
            }
            this.circuitBreaker.statefulThrowExceptionIfTripped();
        }
        return false;
    }

    @Override
    public long preComputedStateSize() {
        return this.cursorA.preComputedStateSize() + this.cursorB.preComputedStateSize();
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toTop() {
        this.map.clear();
        this.record.setAb(true);
        this.nextMethod = this.nextA;
        this.cursorA.toTop();
        this.cursorB.toTop();
    }

    private boolean nextA() {
        if (this.cursorA.hasNext()) {
            return true;
        }
        return this.switchToCursorB();
    }

    private boolean nextB() {
        return this.cursorB.hasNext();
    }

    private boolean switchToCursorB() {
        this.record.setAb(false);
        this.nextMethod = this.nextB;
        return this.nextMethod.next();
    }

    @Override
    void of(RecordCursor cursorA, RecordCursor cursorB, SqlExecutionCircuitBreaker circuitBreaker) throws SqlException {
        if (!this.isOpen) {
            this.isOpen = true;
            this.map.reopen();
        }
        super.of(cursorA, cursorB, circuitBreaker);
        this.record.of(cursorA.getRecord(), cursorB.getRecord());
        this.toTop();
    }

    static interface NextMethod {
        public boolean next();
    }
}

