/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.log.Log;
import io.questdb.network.NetworkFacade;
import io.questdb.network.Socket;
import io.questdb.network.TlsSessionInitFailedException;

public class PlainSocket
implements Socket {
    private final Log log;
    private final NetworkFacade nf;
    private long fd = -1L;

    public PlainSocket(NetworkFacade nf, Log log) {
        this.nf = nf;
        this.log = log;
    }

    @Override
    public void close() {
        if (this.fd != -1L) {
            this.nf.close(this.fd, this.log);
            this.fd = -1L;
        }
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public boolean isClosed() {
        return this.fd == -1L;
    }

    @Override
    public boolean isMorePlaintextBuffered() {
        return false;
    }

    @Override
    public boolean isTlsSessionStarted() {
        return false;
    }

    @Override
    public void of(long fd) {
        assert (this.fd == -1L);
        this.fd = fd;
    }

    @Override
    public int recv(long bufferPtr, int bufferLen) {
        return this.nf.recvRaw(this.fd, bufferPtr, bufferLen);
    }

    @Override
    public int send(long bufferPtr, int bufferLen) {
        return this.nf.sendRaw(this.fd, bufferPtr, bufferLen);
    }

    @Override
    public int shutdown(int how) {
        return this.nf.shutdown(this.fd, how);
    }

    @Override
    public void startTlsSession(CharSequence peerName) throws TlsSessionInitFailedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsTls() {
        return false;
    }

    @Override
    public int tlsIO(int readinessFlags) {
        return 0;
    }

    @Override
    public boolean wantsTlsRead() {
        return false;
    }

    @Override
    public boolean wantsTlsWrite() {
        return false;
    }
}

