/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.str.StringSink;
import java.util.Arrays;

public class AtomicIntList {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private static final int NO_ENTRY_VALUE = -1;
    private volatile int[] data;
    private volatile int pos;

    public AtomicIntList() {
        this(16);
    }

    public AtomicIntList(int capacity) {
        int[] data = new int[capacity];
        Arrays.fill(data, 0, data.length, -1);
        this.data = data;
    }

    public void add(int value) {
        int pos = this.pos;
        int[] data = this.data;
        if (pos >= data.length) {
            int[] dataCopy = new int[2 * data.length];
            System.arraycopy(data, 0, dataCopy, 0, data.length);
            dataCopy[pos] = value;
            this.data = dataCopy;
        } else {
            Unsafe.arrayPutOrdered(data, pos, value);
        }
        this.pos = pos + 1;
    }

    public int capacity() {
        int[] data = this.data;
        return data.length;
    }

    public void extendAndSet(int index, int value) {
        int[] data = this.data;
        int pos = this.pos;
        if (index >= data.length) {
            int[] dataCopy = new int[2 * (index + 1)];
            System.arraycopy(data, 0, dataCopy, 0, data.length);
            Arrays.fill(dataCopy, data.length, dataCopy.length, -1);
            dataCopy[index] = value;
            this.data = dataCopy;
        } else {
            Unsafe.arrayPutOrdered(data, index, value);
        }
        if (pos <= index) {
            this.pos = index + 1;
        }
    }

    public int get(int index) {
        int pos = this.pos;
        int[] data = this.data;
        if (index >= pos) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        return Unsafe.arrayGetVolatile(data, index);
    }

    public void set(int index, int value) {
        int[] data = this.data;
        int pos = this.pos;
        if (index < pos) {
            Unsafe.arrayPutOrdered(data, index, value);
            return;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public int size() {
        return this.pos;
    }

    public String toString() {
        StringSink b = Misc.getThreadLocalSink();
        int[] data = this.data;
        int pos = this.pos;
        b.put('[');
        for (int i = 0; i < pos; ++i) {
            if (i > 0) {
                b.put(',');
            }
            b.put(data[i]);
        }
        b.put(']');
        return ((Object)b).toString();
    }
}

