/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.CairoException;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.str.TrimType;
import io.questdb.std.BinarySequence;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sink;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Chars {
    static final String[] CHAR_STRINGS;
    static final char[] base64;
    static final int[] base64Inverted;
    static final char[] base64Url;
    static final int[] base64UrlInverted;

    private Chars() {
    }

    public static byte[] asciiToByteArray(@NotNull CharSequence ascii) {
        byte[] dst = new byte[ascii.length()];
        int n = ascii.length();
        for (int i = 0; i < n; ++i) {
            assert (ascii.charAt(i) < '\u0080');
            dst[i] = (byte)ascii.charAt(i);
        }
        return dst;
    }

    public static void base64Decode(CharSequence encoded, @NotNull Utf8Sink target) {
        Chars.base64Decode(encoded, target, base64Inverted);
    }

    public static void base64Decode(CharSequence encoded, @NotNull ByteBuffer target) {
        Chars.base64Decode(encoded, target, base64Inverted);
    }

    public static void base64Encode(@Nullable BinarySequence sequence, int maxLength, @NotNull CharSink<?> buffer) {
        int pad = Chars.base64Encode(sequence, maxLength, buffer, base64);
        for (int j = 0; j < pad; ++j) {
            buffer.putAscii("=");
        }
    }

    public static void base64UrlDecode(@Nullable CharSequence encoded, @NotNull Utf8Sink target) {
        Chars.base64Decode(encoded, target, base64UrlInverted);
    }

    public static void base64UrlDecode(CharSequence encoded, ByteBuffer target) {
        Chars.base64Decode(encoded, target, base64UrlInverted);
    }

    public static void base64UrlEncode(BinarySequence sequence, int maxLength, CharSink<?> buffer) {
        Chars.base64Encode(sequence, maxLength, buffer, base64Url);
    }

    public static int charBytes(char c) {
        if (c < '\u0080') {
            return 1;
        }
        if (c < '\u0800') {
            return 2;
        }
        if (Character.isSurrogate(c)) {
            return 1;
        }
        return 3;
    }

    public static int compare(CharSequence l, CharSequence r) {
        if (l == r) {
            return 0;
        }
        if (l == null) {
            return -1;
        }
        if (r == null) {
            return 1;
        }
        int ll = l.length();
        int rl = r.length();
        int min = Math.min(ll, rl);
        for (int i = 0; i < min; ++i) {
            int k = l.charAt(i) - r.charAt(i);
            if (k == 0) continue;
            return k;
        }
        return Integer.compare(ll, rl);
    }

    public static int compareDescending(CharSequence l, CharSequence r) {
        return Chars.compare(r, l);
    }

    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence term) {
        return Chars.indexOf(sequence, 0, sequence.length(), term) != -1;
    }

    public static boolean containsLowerCase(@NotNull CharSequence sequence, @NotNull CharSequence termLC) {
        return Chars.indexOfLowerCase(sequence, 0, sequence.length(), termLC) != -1;
    }

    public static boolean containsWordIgnoreCase(CharSequence seq, CharSequence term, char separator) {
        if (Chars.isBlank(seq)) {
            return false;
        }
        if (Chars.isBlank(term)) {
            return false;
        }
        int seqLen = seq.length();
        int i = Chars.indexOfIgnoreCase(seq, 0, seqLen, term);
        if (i < 0) {
            return false;
        }
        if (i > 0 && seq.charAt(i - 1) != separator) {
            return false;
        }
        int termLen = term.length();
        if (i + termLen < seqLen) {
            return seq.charAt(i + termLen) == separator;
        }
        return true;
    }

    public static void copyStrChars(CharSequence value, int pos, int len, long address) {
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i + pos);
            Unsafe.getUnsafe().putChar(address + 2L * (long)i, c);
        }
    }

    public static boolean empty(@Nullable CharSequence value) {
        return value == null || value.length() < 1;
    }

    public static boolean endsWith(CharSequence cs, CharSequence ends) {
        if (ends == null || cs == null) {
            return false;
        }
        int l = ends.length();
        if (l == 0) {
            return true;
        }
        int csl = cs.length();
        return csl != 0 && csl >= l && Chars.equals(ends, cs, csl - l, csl);
    }

    public static boolean endsWith(@Nullable CharSequence cs, char c) {
        if (cs == null) {
            return false;
        }
        int csl = cs.length();
        return csl != 0 && c == cs.charAt(csl - 1);
    }

    public static boolean endsWithLowerCase(@Nullable CharSequence cs, @Nullable CharSequence endsLC) {
        if (endsLC == null || cs == null) {
            return false;
        }
        int l = endsLC.length();
        if (l == 0) {
            return true;
        }
        int csl = cs.length();
        return csl != 0 && csl >= l && Chars.equalsLowerCase(endsLC, cs, csl - l, csl);
    }

    public static boolean equals(@NotNull CharSequence l, @NotNull CharSequence r) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        return Chars.equalsChars(l, r, ll);
    }

    public static boolean equals(@NotNull String l, @NotNull String r) {
        return l.equals(r);
    }

    public static boolean equals(@NotNull CharSequence l, @NotNull CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (l.charAt(i) == r.charAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull CharSequence l, int lLo, int lHi, @NotNull CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (l.charAt(i + lLo) == r.charAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull CharSequence l, char r) {
        return l.length() == 1 && l.charAt(0) == r;
    }

    public static boolean equalsIgnoreCase(@NotNull CharSequence l, @NotNull CharSequence r) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        return Chars.equalsCharsIgnoreCase(l, r, ll);
    }

    public static boolean equalsIgnoreCase(@NotNull CharSequence l, @NotNull CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != rHi - rLo) {
            return false;
        }
        return Chars.equalsCharsIgnoreCase(l, r, ll, rLo, rHi);
    }

    public static boolean equalsIgnoreCaseNc(@NotNull CharSequence l, @Nullable CharSequence r) {
        return r != null && Chars.equalsIgnoreCase(l, r);
    }

    public static boolean equalsLowerCase(@NotNull CharSequence lLC, @NotNull CharSequence r, int rLo, int rHi) {
        if (lLC == r) {
            return true;
        }
        int ll = lLC.length();
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (lLC.charAt(i) == Character.toLowerCase(r.charAt(i + rLo))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsLowerCase(@NotNull CharSequence l, int lLo, int lHi, @NotNull CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Character.toLowerCase(l.charAt(i + lLo)) == Character.toLowerCase(r.charAt(i + rLo))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsLowerCaseAscii(@NotNull CharSequence l, int lLo, int lHi, @NotNull CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Chars.toLowerCaseAscii(l.charAt(i + lLo)) == Chars.toLowerCaseAscii(r.charAt(i + rLo))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsLowerCaseAscii(@NotNull CharSequence l, @NotNull CharSequence r) {
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Chars.toLowerCaseAscii(l.charAt(i)) == Chars.toLowerCaseAscii(r.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsLowerCaseAsciiNc(@NotNull CharSequence l, @Nullable CharSequence r) {
        return r != null && Chars.equalsLowerCaseAscii(l, r);
    }

    public static boolean equalsNc(@Nullable CharSequence l, char r) {
        return l == null && r == CharConstant.ZERO.getChar(null) || l != null && Chars.equals(l, r);
    }

    public static boolean equalsNc(@NotNull CharSequence l, @Nullable CharSequence r) {
        return r != null && Chars.equals(l, r);
    }

    public static boolean equalsNc(CharSequence l, CharSequence r, int rLo, int rHi) {
        return l != null && Chars.equals(l, r, rLo, rHi);
    }

    public static boolean equalsNullable(@Nullable CharSequence l, @Nullable CharSequence r) {
        if (l == null && r == null) {
            return true;
        }
        if (l == null || r == null) {
            return false;
        }
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        return Chars.equalsChars(l, r, ll);
    }

    public static boolean greaterThan(@Nullable CharSequence l, @Nullable CharSequence r) {
        if (l == null || r == null) {
            return false;
        }
        int ll = l.length();
        int rl = r.length();
        int min = Math.min(ll, rl);
        for (int i = 0; i < min; ++i) {
            int k = l.charAt(i) - r.charAt(i);
            if (k == 0) continue;
            return k > 0;
        }
        return ll > rl;
    }

    public static int hashCode(@NotNull CharSequence value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + value.charAt(p);
        }
        return h;
    }

    public static int hashCode(char @NotNull [] value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + value[p];
        }
        return h;
    }

    public static int hashCode(@NotNull CharSequence value) {
        if (value instanceof String) {
            return value.hashCode();
        }
        int len = value.length();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < len; ++p) {
            h = 31 * h + value.charAt(p);
        }
        return h;
    }

    public static int hashCode(@NotNull String value) {
        return value.hashCode();
    }

    public static int indexOf(@NotNull CharSequence seq, int seqLo, int seqHi, @NotNull CharSequence term) {
        int termLen = term.length();
        if (termLen == 0) {
            return 0;
        }
        char first = term.charAt(0);
        int max = seqHi - termLen;
        for (int i = seqLo; i <= max; ++i) {
            if (seq.charAt(i) != first) {
                while (++i <= max && seq.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + termLen - 1;
            int k = 1;
            while (j < end && seq.charAt(j) == term.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull CharSequence seq, int seqLo, int seqHi, @NotNull CharSequence term, int occurrence) {
        int m = term.length();
        if (m == 0) {
            return 0;
        }
        if (occurrence == 0) {
            return -1;
        }
        int foundIndex = -1;
        int count = 0;
        if (occurrence > 0) {
            for (int i = seqLo; i < seqHi; ++i) {
                if (foundIndex == -1) {
                    if (seqHi - i < m) {
                        return -1;
                    }
                    if (seq.charAt(i) == term.charAt(0)) {
                        foundIndex = i;
                    }
                } else if (seq.charAt(i) != term.charAt(i - foundIndex)) {
                    i = foundIndex;
                    foundIndex = -1;
                }
                if (foundIndex == -1 || i - foundIndex != m - 1) continue;
                if (++count == occurrence) {
                    return foundIndex;
                }
                foundIndex = -1;
            }
        } else {
            for (int i = seqHi - 1; i >= seqLo; --i) {
                if (foundIndex == -1) {
                    if (i - seqLo + 1 < m) {
                        return -1;
                    }
                    if (seq.charAt(i) == term.charAt(m - 1)) {
                        foundIndex = i;
                    }
                } else if (seq.charAt(i) != term.charAt(m - 1 + i - foundIndex)) {
                    i = foundIndex;
                    foundIndex = -1;
                }
                if (foundIndex == -1 || foundIndex - i != m - 1) continue;
                if (--count == occurrence) {
                    return foundIndex + 1 - m;
                }
                foundIndex = -1;
            }
        }
        return -1;
    }

    public static int indexOf(CharSequence seq, char c) {
        return Chars.indexOf(seq, 0, c);
    }

    public static int indexOf(CharSequence seq, int seqLo, char c) {
        return Chars.indexOf(seq, seqLo, seq.length(), c);
    }

    public static int indexOf(CharSequence seq, int seqLo, int seqHi, char c) {
        return Chars.indexOf(seq, seqLo, seqHi, c, 1);
    }

    public static int indexOf(CharSequence seq, int seqLo, int seqHi, char ch, int occurrence) {
        if (occurrence == 0) {
            return -1;
        }
        int count = 0;
        if (occurrence > 0) {
            for (int i = seqLo; i < seqHi; ++i) {
                if (seq.charAt(i) != ch || ++count != occurrence) continue;
                return i;
            }
        } else {
            for (int i = seqHi - 1; i >= seqLo; --i) {
                if (seq.charAt(i) != ch || --count != occurrence) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfIgnoreCase(@NotNull CharSequence seq, int seqLo, int seqHi, @NotNull CharSequence term) {
        int termLen = term.length();
        if (termLen == 0) {
            return 0;
        }
        char first = Character.toLowerCase(term.charAt(0));
        int max = seqHi - termLen;
        for (int i = seqLo; i <= max; ++i) {
            if (Character.toLowerCase(seq.charAt(i)) != first) {
                while (++i <= max && Character.toLowerCase(seq.charAt(i)) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + termLen - 1;
            int k = 1;
            while (j < end && Character.toLowerCase(seq.charAt(j)) == Character.toLowerCase(term.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfLastUnquoted(@NotNull CharSequence seq, char ch) {
        return Chars.indexOfLastUnquoted(seq, ch, 0, seq.length());
    }

    public static int indexOfLastUnquoted(@NotNull CharSequence seq, char ch, int seqLo, int seqHi) {
        boolean inQuotes = false;
        int last = -1;
        for (int i = seqLo; i < seqHi; ++i) {
            if (seq.charAt(i) == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (seq.charAt(i) != ch || inQuotes) continue;
            last = i;
        }
        return last;
    }

    public static int indexOfLowerCase(@NotNull CharSequence seq, int seqLo, int seqHi, @NotNull CharSequence termLC) {
        int termLen = termLC.length();
        if (termLen == 0) {
            return 0;
        }
        char first = termLC.charAt(0);
        int max = seqHi - termLen;
        for (int i = seqLo; i <= max; ++i) {
            if (Character.toLowerCase(seq.charAt(i)) != first) {
                while (++i <= max && Character.toLowerCase(seq.charAt(i)) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + termLen - 1;
            int k = 1;
            while (j < end && Character.toLowerCase(seq.charAt(j)) == termLC.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfNonWhitespace(@NotNull CharSequence seq, int seqLo, int seqHi, int searchDirection) {
        if (searchDirection == 0) {
            return -1;
        }
        if (searchDirection > 0) {
            for (int i = seqLo; i < seqHi; ++i) {
                if (Character.isWhitespace(seq.charAt(i))) continue;
                return i;
            }
        } else {
            for (int i = seqHi - 1; i >= seqLo; --i) {
                if (Character.isWhitespace(seq.charAt(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isAscii(@NotNull CharSequence cs) {
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            if (cs.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace((int)c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDoubleQuote(char c) {
        return c == '\"';
    }

    public static boolean isDoubleQuoted(CharSequence s) {
        if (s == null || s.length() < 2) {
            return false;
        }
        return Chars.isDoubleQuote(s.charAt(0)) && Chars.isDoubleQuote(s.charAt(s.length() - 1));
    }

    public static boolean isOnlyDecimals(CharSequence s) {
        int len = s.length();
        for (int i = len - 1; i > -1; --i) {
            char digit = s.charAt(i);
            if (digit >= '0' && digit <= '9') continue;
            return false;
        }
        return len > 0;
    }

    public static boolean isQuote(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    public static boolean isQuoted(CharSequence s) {
        if (s == null || s.length() < 2) {
            return false;
        }
        char open = s.charAt(0);
        return Chars.isQuote(open) && open == s.charAt(s.length() - 1);
    }

    public static int lastIndexOf(@NotNull CharSequence sequence, int sequenceLo, int sequenceHi, @NotNull CharSequence term) {
        return Chars.indexOf(sequence, sequenceLo, sequenceHi, term, -1);
    }

    public static int lastIndexOf(@NotNull CharSequence sequence, int sequenceLo, int sequenceHi, char c) {
        return Chars.indexOf(sequence, sequenceLo, sequenceHi, c, -1);
    }

    public static int lastIndexOfDifferent(@NotNull CharSequence sequence, int sequenceLo, int sequenceHi, char c) {
        for (int i = sequenceHi - 1; i >= sequenceLo; --i) {
            if (sequence.charAt(i) == c) continue;
            return i;
        }
        return -1;
    }

    public static boolean lessThan(@Nullable CharSequence l, @Nullable CharSequence r) {
        if (l == null || r == null) {
            return false;
        }
        int ll = l.length();
        int rl = r.length();
        int min = Math.min(ll, rl);
        for (int i = 0; i < min; ++i) {
            int k = l.charAt(i) - r.charAt(i);
            if (k == 0) continue;
            return k < 0;
        }
        return ll < rl;
    }

    public static boolean lessThan(@Nullable CharSequence l, @Nullable CharSequence r, boolean negated) {
        boolean eq = Chars.equalsNullable(l, r);
        return negated ? eq || Chars.greaterThan(l, r) : !eq && Chars.lessThan(l, r);
    }

    public static int lowerCaseAsciiHashCode(CharSequence value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + Chars.toLowerCaseAscii(value.charAt(p));
        }
        return h;
    }

    public static int lowerCaseAsciiHashCode(CharSequence value) {
        int len = value.length();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < len; ++p) {
            h = 31 * h + Chars.toLowerCaseAscii(value.charAt(p));
        }
        return h;
    }

    public static int lowerCaseHashCode(CharSequence value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + Character.toLowerCase(value.charAt(p));
        }
        return h;
    }

    public static int lowerCaseHashCode(CharSequence value) {
        int len = value.length();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < len; ++p) {
            h = 31 * h + Character.toLowerCase(value.charAt(p));
        }
        return h;
    }

    public static boolean noMatch(CharSequence l, int llo, int lhi, CharSequence r, int rlo, int rhi) {
        int lp = llo;
        int rp = rlo;
        while (lp < lhi && rp < rhi) {
            if (Character.toLowerCase(l.charAt(lp++)) == r.charAt(rp++)) continue;
            return true;
        }
        return lp != lhi || rp != rhi;
    }

    public static CharSequence repeat(final String s, final int times) {
        return new CharSequence(){

            @Override
            public char charAt(int index) {
                return s.charAt(index % s.length());
            }

            @Override
            public int length() {
                return s.length() * times;
            }

            @Override
            @NotNull
            public CharSequence subSequence(int start, int end) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ObjList<Path> splitLpsz(CharSequence args) {
        ObjList<Path> paths = new ObjList<Path>();
        int n = args.length();
        int lastLen = 0;
        int lastIndex = 0;
        boolean inQuote = false;
        block4: for (int i = 0; i < n; ++i) {
            char b = args.charAt(i);
            switch (b) {
                case ' ': {
                    if (lastLen <= 0) continue block4;
                    if (inQuote) {
                        ++lastLen;
                        continue block4;
                    }
                    paths.add(new Path().of(args, lastIndex, lastLen + lastIndex));
                    lastLen = 0;
                    continue block4;
                }
                case '\"': {
                    inQuote = !inQuote;
                    continue block4;
                }
                default: {
                    if (lastLen == 0) {
                        lastIndex = i;
                    }
                    ++lastLen;
                }
            }
        }
        if (lastLen > 0) {
            paths.add(new Path().of(args, lastIndex, lastLen + lastIndex));
        }
        return paths;
    }

    public static boolean startsWith(@Nullable CharSequence cs, @Nullable CharSequence starts) {
        if (cs == null || starts == null) {
            return false;
        }
        int l = starts.length();
        return l == 0 || cs.length() >= l && Chars.equalsChars(cs, starts, l);
    }

    public static boolean startsWith(CharSequence _this, int thisLo, int thisHi, CharSequence that) {
        int thisLen = thisHi - thisLo;
        int len = that.length();
        if (thisLen < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (_this.charAt(thisLo + i) == that.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(CharSequence _this, char c) {
        return _this.length() > 0 && _this.charAt(0) == c;
    }

    public static boolean startsWithIgnoreCase(CharSequence cs, CharSequence startsWith) {
        if (cs == null || startsWith == null) {
            return false;
        }
        int l = startsWith.length();
        if (l == 0) {
            return true;
        }
        return cs.length() >= l && Chars.equalsWithIgnoreCase(startsWith, cs, l);
    }

    public static boolean startsWithLowerCase(@Nullable CharSequence cs, @Nullable CharSequence startsLC) {
        if (cs == null || startsLC == null) {
            return false;
        }
        int l = startsLC.length();
        if (l == 0) {
            return true;
        }
        return cs.length() >= l && Chars.equalsCharsLowerCase(startsLC, cs, l);
    }

    public static void toLowerCase(@Nullable CharSequence str, @NotNull CharSink<?> sink) {
        if (str != null) {
            Chars.toLowerCase(str, 0, str.length(), sink);
        }
    }

    public static void toLowerCase(@NotNull CharSequence str, int lo, int hi, @NotNull CharSink<?> sink) {
        for (int i = lo; i < hi; ++i) {
            sink.put(Character.toLowerCase(str.charAt(i)));
        }
    }

    public static String toLowerCaseAscii(@Nullable CharSequence value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        if (len == 0) {
            return "";
        }
        StringSink b = Misc.getThreadLocalSink();
        for (int i = 0; i < len; ++i) {
            b.put(Chars.toLowerCaseAscii(value.charAt(i)));
        }
        return ((Object)b).toString();
    }

    public static char toLowerCaseAscii(char character) {
        return character > '@' && character < '[' ? (char)(character + 32) : character;
    }

    public static void toSink(@Nullable BinarySequence sequence, @NotNull CharSink<?> sink) {
        if (sequence == null) {
            return;
        }
        int len = (int)sequence.length();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                if (i % 16 == 0) {
                    sink.put('\n');
                    Numbers.appendHexPadded(sink, i);
                }
            } else {
                Numbers.appendHexPadded(sink, i);
            }
            sink.put(' ');
            int b = sequence.byteAt(i);
            int v = b < 0 ? 256 + b : b;
            if (v < 16) {
                sink.put('0');
                sink.put(Numbers.hexDigits[b]);
                continue;
            }
            sink.put(Numbers.hexDigits[v / 16]);
            sink.put(Numbers.hexDigits[v % 16]);
        }
    }

    public static String toString(char value) {
        if (value < CHAR_STRINGS.length) {
            return CHAR_STRINGS[value];
        }
        return Character.toString(value);
    }

    public static String toString(CharSequence s) {
        return s == null ? null : s.toString();
    }

    public static String toString(CharSequence cs, int start, int end) {
        StringSink b = Misc.getThreadLocalSink();
        b.put(cs, start, end);
        return ((Object)b).toString();
    }

    public static String toString(@NotNull CharSequence cs, int start, int end, char unescape) {
        StringSink b = Misc.getThreadLocalSink();
        Chars.unescape(cs, start, end, unescape, b);
        return ((Object)b).toString();
    }

    public static void toUpperCase(@Nullable CharSequence str, @NotNull CharSink<?> sink) {
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                sink.put(Character.toUpperCase(str.charAt(i)));
            }
        }
    }

    public static void trim(TrimType type, CharSequence str, StringSink sink) {
        int startIdx;
        if (str == null) {
            return;
        }
        int endIdx = str.length() - 1;
        if (type == TrimType.LTRIM || type == TrimType.TRIM) {
            for (startIdx = 0; startIdx < endIdx && str.charAt(startIdx) == ' '; ++startIdx) {
            }
        }
        if (type == TrimType.RTRIM || type == TrimType.TRIM) {
            while (startIdx < endIdx && str.charAt(endIdx) == ' ') {
                --endIdx;
            }
        }
        sink.clear();
        if (startIdx != endIdx) {
            sink.put(str, startIdx, endIdx + 1);
        }
    }

    public static void unescape(@NotNull CharSequence cs, int start, int end, char unescape, @NotNull Utf16Sink sink) {
        int lastChar = end - 1;
        for (int i = start; i < end; ++i) {
            char c = cs.charAt(i);
            sink.put(c);
            if (c != unescape || i >= lastChar || cs.charAt(i + 1) != unescape) continue;
            ++i;
        }
    }

    private static int[] base64CreateInvertedAlphabet(char[] alphabet) {
        int[] inverted = new int[128];
        Arrays.fill(inverted, -1);
        int length = alphabet.length;
        for (int i = 0; i < length; ++i) {
            char letter = alphabet[i];
            assert (letter < '\u0080');
            inverted[letter] = (byte)i;
        }
        return inverted;
    }

    private static void base64Decode(@Nullable CharSequence encoded, @NotNull Utf8Sink target, int[] invertedAlphabet) {
        int sourcePos;
        int length;
        if (encoded == null) {
            return;
        }
        for (length = encoded.length(); length > 0 && encoded.charAt(length - 1) == '='; --length) {
        }
        int remainder = length % 4;
        int end = length - remainder;
        for (sourcePos = 0; sourcePos < end; sourcePos += 4) {
            int b0 = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos)) << 18;
            int b1 = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 1)) << 12;
            int b2 = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 2)) << 6;
            int b4 = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 3));
            int wrk = b0 | b1 | b2 | b4;
            target.putAny((byte)(wrk >>> 16));
            target.putAny((byte)(wrk >>> 8 & 0xFF));
            target.putAny((byte)(wrk & 0xFF));
        }
        switch (remainder) {
            case 0: {
                break;
            }
            case 1: {
                throw CairoException.nonCritical().put("invalid base64 encoding [string=").putAsPrintable(encoded).put(']');
            }
            case 2: {
                int wrk = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos)) << 18;
                target.putAny((byte)((wrk |= Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 1)) << 12) >>> 16));
                break;
            }
            case 3: {
                int wrk = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos)) << 18;
                wrk |= Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 1)) << 12;
                target.putAny((byte)((wrk |= Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 2)) << 6) >>> 16));
                target.putAny((byte)(wrk >>> 8 & 0xFF));
            }
        }
    }

    private static void base64Decode(CharSequence encoded, ByteBuffer target, int[] invertedAlphabet) {
        int length;
        if (encoded == null) {
            return;
        }
        assert (target != null);
        for (length = encoded.length(); length > 0 && encoded.charAt(length - 1) == '='; --length) {
        }
        int remainder = length % 4;
        int sourcePos = 0;
        int targetPos = target.position();
        int end = length - remainder;
        while (sourcePos < end) {
            int b0 = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos)) << 18;
            int b1 = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 1)) << 12;
            int b2 = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 2)) << 6;
            int b4 = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 3));
            int wrk = b0 | b1 | b2 | b4;
            target.put(targetPos, (byte)(wrk >>> 16));
            target.put(targetPos + 1, (byte)(wrk >>> 8 & 0xFF));
            target.put(targetPos + 2, (byte)(wrk & 0xFF));
            sourcePos += 4;
            targetPos += 3;
        }
        target.position(targetPos);
        switch (remainder) {
            case 0: {
                break;
            }
            case 1: {
                throw CairoException.nonCritical().put("invalid base64 encoding [string=").putAsPrintable(encoded).put(']');
            }
            case 2: {
                int wrk = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos)) << 18;
                target.put((byte)((wrk |= Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 1)) << 12) >>> 16));
                break;
            }
            case 3: {
                int wrk = Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos)) << 18;
                wrk |= Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 1)) << 12;
                target.put((byte)((wrk |= Chars.base64InvertedLookup(invertedAlphabet, encoded.charAt(sourcePos + 2)) << 6) >>> 16));
                target.put((byte)(wrk >>> 8 & 0xFF));
            }
        }
    }

    private static int base64Encode(@Nullable BinarySequence sequence, int maxLength, @NotNull CharSink<?> buffer, char @NotNull [] alphabet) {
        if (sequence == null) {
            return 0;
        }
        long len = Math.min((long)maxLength, sequence.length());
        int pad = 0;
        int i = 0;
        while ((long)i < len) {
            int b = (sequence.byteAt(i) & 0xFF) << 16 & 0xFFFFFF;
            if ((long)(i + 1) < len) {
                b |= (sequence.byteAt(i + 1) & 0xFF) << 8;
            } else {
                ++pad;
            }
            if ((long)(i + 2) < len) {
                b |= sequence.byteAt(i + 2) & 0xFF;
            } else {
                ++pad;
            }
            for (int j = 0; j < 4 - pad; ++j) {
                int c = (b & 0xFC0000) >> 18;
                buffer.putAscii(alphabet[c]);
                b <<= 6;
            }
            i += 3;
        }
        return pad;
    }

    private static int base64InvertedLookup(int[] invertedAlphabet, char ch) {
        if (ch > '\u007f') {
            throw CairoException.nonCritical().put("non-ascii character while decoding base64 [ch=").put((long)ch).put(']');
        }
        int index = invertedAlphabet[ch];
        if (index == -1) {
            throw CairoException.nonCritical().put("invalid base64 character [ch=").put(ch).put(']');
        }
        return index;
    }

    private static boolean equalsChars(@NotNull CharSequence l, @NotNull CharSequence r, int len) {
        for (int i = 0; i < len; ++i) {
            if (l.charAt(i) == r.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsCharsIgnoreCase(@NotNull CharSequence l, @NotNull CharSequence r, int len) {
        for (int i = 0; i < len; ++i) {
            if (Character.toLowerCase(l.charAt(i)) == Character.toLowerCase(r.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsCharsIgnoreCase(@NotNull CharSequence l, @NotNull CharSequence r, int len, int rLo, int rHi) {
        assert (len == rHi - rLo);
        for (int i = 0; i < len; ++i) {
            if (Character.toLowerCase(l.charAt(i)) == Character.toLowerCase(r.charAt(i + rLo))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsCharsLowerCase(@NotNull CharSequence lLC, @NotNull CharSequence r, int len) {
        for (int i = 0; i < len; ++i) {
            if (lLC.charAt(i) == Character.toLowerCase(r.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsWithIgnoreCase(@NotNull CharSequence lLC, @NotNull CharSequence r, int len) {
        for (int i = 0; i < len; ++i) {
            if (Character.toLowerCase(lLC.charAt(i)) == Character.toLowerCase(r.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        base64Inverted = Chars.base64CreateInvertedAlphabet(base64);
        base64Url = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
        base64UrlInverted = Chars.base64CreateInvertedAlphabet(base64Url);
        CHAR_STRINGS = new String[128];
        for (char c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
            Chars.CHAR_STRINGS[c] = Character.toString(c);
        }
    }
}

