/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.histogram.org.HdrHistogram;

import io.questdb.std.histogram.org.HdrHistogram.AbstractHistogram;
import io.questdb.std.histogram.org.HdrHistogram.DoubleHistogram;
import io.questdb.std.histogram.org.HdrHistogram.PackedHistogram;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;

public class PackedDoubleHistogram
extends DoubleHistogram {
    public PackedDoubleHistogram(int numberOfSignificantValueDigits) {
        this(2L, numberOfSignificantValueDigits);
        this.setAutoResize(true);
    }

    public PackedDoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits) {
        this(highestToLowestValueRatio, numberOfSignificantValueDigits, PackedHistogram.class);
    }

    public PackedDoubleHistogram(DoubleHistogram source) {
        super(source);
    }

    PackedDoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits, Class<? extends AbstractHistogram> internalCountsHistogramClass) {
        super(highestToLowestValueRatio, numberOfSignificantValueDigits, internalCountsHistogramClass);
    }

    PackedDoubleHistogram(long highestToLowestValueRatio, int numberOfSignificantValueDigits, Class<? extends AbstractHistogram> internalCountsHistogramClass, AbstractHistogram internalCountsHistogram) {
        super(highestToLowestValueRatio, numberOfSignificantValueDigits, internalCountsHistogramClass, internalCountsHistogram);
    }

    public static PackedDoubleHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestToLowestValueRatio) {
        try {
            int cookie = buffer.getInt();
            if (!PackedDoubleHistogram.isNonCompressedDoubleHistogramCookie(cookie)) {
                throw new IllegalArgumentException("The buffer does not contain a DoubleHistogram");
            }
            return PackedDoubleHistogram.constructHistogramFromBuffer(cookie, buffer, PackedDoubleHistogram.class, PackedHistogram.class, minBarForHighestToLowestValueRatio);
        }
        catch (DataFormatException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static PackedDoubleHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestToLowestValueRatio) throws DataFormatException {
        int cookie = buffer.getInt();
        if (!PackedDoubleHistogram.isCompressedDoubleHistogramCookie(cookie)) {
            throw new IllegalArgumentException("The buffer does not contain a compressed DoubleHistogram");
        }
        return PackedDoubleHistogram.constructHistogramFromBuffer(cookie, buffer, PackedDoubleHistogram.class, PackedHistogram.class, minBarForHighestToLowestValueRatio);
    }
}

