/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.config;

import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataConfig;
import java.io.Serializable;

public enum ClickHouseDefaults implements ClickHouseOption
{
    ASYNC("async", true, "Whether the client should run in async mode."),
    AUTO_SESSION("auto_session", true, "Whether to create session automatically when there are multiple queries."),
    BUFFERING("buffering", ClickHouseDataConfig.DEFAULT_BUFFERING_MODE, "Buffering mode."),
    HOST("host", "localhost", "Host to connect to."),
    PROTOCOL("protocol", ClickHouseProtocol.ANY, "Protocol to use."),
    DATABASE("database", "default", "Database to connect to."),
    USER("user", "default", "User name for authentication."),
    PASSWORD("password", "", "Password for authentication.", true),
    FORMAT("format", ClickHouseDataConfig.DEFAULT_FORMAT, "Preferred data format for serialization and deserialization."),
    MAX_SCHEDULER_THREADS("max_scheduler_threads", 1, "Maximum number of threads that the scheduler(shared by all client instances) can use to run the adhoc/scheduled tasks like discovery and health check.."),
    MAX_THREADS("max_threads", 0, "Maximum size of shared thread pool, 0 or negative number means same as CPU cores."),
    MAX_REQUESTS("max_requests", 0, "Maximum size of shared thread pool, 0 means no limit."),
    ROUNDING_MODE("rounding_mode", ClickHouseDataConfig.DEFAULT_ROUNDING_MODE, "Default rounding mode for BigDecimal."),
    THREAD_KEEPALIVE_TIMEOUT("thread_keepalive_timeout", 0L, "Thread keep alive timeout in milliseconds. 0 or negative number means additional thread will be closed immediately after execution completed."),
    SERVER_TIME_ZONE("time_zone", "UTC", "Server time zone."),
    SERVER_VERSION("version", "latest", "Server version"),
    SSL_CERTIFICATE_TYPE("sslcerttype", "X.509", "SSL/TLS certificate type."),
    SSL_KEY_ALGORITHM("sslkeyalg", "RSA", "Key algorithm."),
    SSL_PROTOCOL("sslprotocol", "TLS", "SSL protocol."),
    SRV_RESOLVE("srv_resolve", false, "Whether to resolve DNS SRV name.");

    private final String key;
    private final Serializable defaultValue;
    private final Class<? extends Serializable> clazz;
    private final String description;
    private final boolean sensitive;

    private <T extends Serializable> ClickHouseDefaults(String key, T defaultValue, String description) {
        this(key, defaultValue, description, false);
    }

    private <T extends Serializable> ClickHouseDefaults(String key, T defaultValue, String description, boolean sensitive) {
        this.key = ClickHouseChecker.nonNull(key, "key");
        this.defaultValue = ClickHouseChecker.nonNull(defaultValue, "defaultValue");
        this.clazz = defaultValue.getClass();
        this.description = ClickHouseChecker.nonNull(description, "description");
        this.sensitive = sensitive;
    }

    @Override
    public Serializable getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getPrefix() {
        return "DEFAULT";
    }

    @Override
    public Class<? extends Serializable> getValueType() {
        return this.clazz;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }
}

