/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.internal.async.SingleResultCallback;

@FunctionalInterface
public interface AsyncCallbackSupplier<R> {
    public void get(SingleResultCallback<R> var1);

    default public AsyncCallbackSupplier<R> whenComplete(Runnable after) {
        @NotThreadSafe
        final class MutableBoolean {
            private boolean value;

            MutableBoolean() {
            }
        }
        MutableBoolean afterExecuted = new MutableBoolean();
        Runnable trackableAfter = () -> {
            try {
                after.run();
            }
            finally {
                afterExecuted.value = true;
            }
        };
        return callback -> {
            SingleResultCallback<Object> callbackThatCallsAfter = (result, t) -> {
                Throwable primaryException = t;
                try {
                    trackableAfter.run();
                }
                catch (Throwable afterException) {
                    if (primaryException == null) {
                        primaryException = afterException;
                    } else {
                        primaryException.addSuppressed(afterException);
                    }
                    callback.onResult(null, primaryException);
                    return;
                }
                callback.onResult(result, primaryException);
            };
            Throwable primaryUnexpectedException = null;
            try {
                this.get(callbackThatCallsAfter);
            }
            catch (Throwable unexpectedException) {
                primaryUnexpectedException = unexpectedException;
                throw unexpectedException;
            }
            finally {
                if (primaryUnexpectedException != null && !afterExecuted.value) {
                    try {
                        trackableAfter.run();
                    }
                    catch (Throwable afterException) {
                        primaryUnexpectedException.addSuppressed(afterException);
                    }
                }
            }
        };
    }
}

