/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.servlet.function.ChangePathPatternParserVisitor;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public abstract class RequestPredicates {
    private static final Log logger = LogFactory.getLog(RequestPredicates.class);

    public static RequestPredicate all() {
        return request -> true;
    }

    public static RequestPredicate method(HttpMethod httpMethod) {
        Assert.notNull((Object)httpMethod, (String)"HttpMethod must not be null");
        return new SingleHttpMethodPredicate(httpMethod);
    }

    public static RequestPredicate methods(HttpMethod ... httpMethods) {
        Assert.notEmpty((Object[])httpMethods, (String)"HttpMethods must not be empty");
        if (httpMethods.length == 1) {
            return new SingleHttpMethodPredicate(httpMethods[0]);
        }
        return new MultipleHttpMethodsPredicate(httpMethods);
    }

    public static RequestPredicate path(String pattern) {
        Assert.notNull((Object)pattern, (String)"'pattern' must not be null");
        PathPatternParser parser = PathPatternParser.defaultInstance;
        pattern = parser.initFullPathPattern(pattern);
        return RequestPredicates.pathPredicates(parser).apply(pattern);
    }

    public static Function<String, RequestPredicate> pathPredicates(PathPatternParser patternParser) {
        Assert.notNull((Object)patternParser, (String)"PathPatternParser must not be null");
        return pattern -> new PathPatternPredicate(patternParser.parse(pattern));
    }

    public static RequestPredicate headers(Predicate<ServerRequest.Headers> headersPredicate) {
        return new HeadersPredicate(headersPredicate);
    }

    public static RequestPredicate contentType(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"'mediaTypes' must not be empty");
        if (mediaTypes.length == 1) {
            return new SingleContentTypePredicate(mediaTypes[0]);
        }
        return new MultipleContentTypesPredicate(mediaTypes);
    }

    public static RequestPredicate accept(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"'mediaTypes' must not be empty");
        if (mediaTypes.length == 1) {
            return new SingleAcceptPredicate(mediaTypes[0]);
        }
        return new MultipleAcceptsPredicate(mediaTypes);
    }

    public static RequestPredicate GET(String pattern) {
        return RequestPredicates.method(HttpMethod.GET).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate HEAD(String pattern) {
        return RequestPredicates.method(HttpMethod.HEAD).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate POST(String pattern) {
        return RequestPredicates.method(HttpMethod.POST).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate PUT(String pattern) {
        return RequestPredicates.method(HttpMethod.PUT).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate PATCH(String pattern) {
        return RequestPredicates.method(HttpMethod.PATCH).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate DELETE(String pattern) {
        return RequestPredicates.method(HttpMethod.DELETE).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate OPTIONS(String pattern) {
        return RequestPredicates.method(HttpMethod.OPTIONS).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate pathExtension(String extension) {
        Assert.notNull((Object)extension, (String)"'extension' must not be null");
        return new PathExtensionPredicate(extension);
    }

    public static RequestPredicate pathExtension(Predicate<String> extensionPredicate) {
        return new PathExtensionPredicate(extensionPredicate);
    }

    public static RequestPredicate param(String name, String value) {
        return new ParamPredicate(name, value);
    }

    public static RequestPredicate param(String name, Predicate<String> predicate) {
        return new ParamPredicate(name, predicate);
    }

    private static void traceMatch(String prefix, Object desired, @Nullable Object actual, boolean match) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match ? "matches" : "does not match", actual));
        }
    }

    private static PathPattern mergePatterns(@Nullable PathPattern oldPattern, PathPattern newPattern) {
        if (oldPattern != null) {
            return oldPattern.combine(newPattern);
        }
        return newPattern;
    }

    private static class SingleHttpMethodPredicate
    implements RequestPredicate {
        private final HttpMethod httpMethod;

        public SingleHttpMethodPredicate(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public boolean test(ServerRequest request) {
            HttpMethod method = SingleHttpMethodPredicate.method(request);
            boolean match = this.httpMethod.equals((Object)method);
            RequestPredicates.traceMatch("Method", this.httpMethod, method, match);
            return match;
        }

        static HttpMethod method(ServerRequest request) {
            String accessControlRequestMethod;
            if (CorsUtils.isPreFlightRequest((HttpServletRequest)request.servletRequest()) && (accessControlRequestMethod = request.headers().firstHeader("Access-Control-Request-Method")) != null) {
                return HttpMethod.valueOf((String)accessControlRequestMethod);
            }
            return request.method();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.method(Set.of(this.httpMethod));
        }

        public String toString() {
            return this.httpMethod.toString();
        }
    }

    private static class MultipleHttpMethodsPredicate
    implements RequestPredicate {
        private final Set<HttpMethod> httpMethods;

        public MultipleHttpMethodsPredicate(HttpMethod[] httpMethods) {
            this.httpMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(httpMethods));
        }

        @Override
        public boolean test(ServerRequest request) {
            HttpMethod method = SingleHttpMethodPredicate.method(request);
            boolean match = this.httpMethods.contains(method);
            RequestPredicates.traceMatch("Method", this.httpMethods, method, match);
            return match;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.method(Collections.unmodifiableSet(this.httpMethods));
        }

        public String toString() {
            return this.httpMethods.toString();
        }
    }

    private static class HeadersPredicate
    implements RequestPredicate {
        private final Predicate<ServerRequest.Headers> headersPredicate;

        public HeadersPredicate(Predicate<ServerRequest.Headers> headersPredicate) {
            Assert.notNull(headersPredicate, (String)"Predicate must not be null");
            this.headersPredicate = headersPredicate;
        }

        @Override
        public boolean test(ServerRequest request) {
            if (CorsUtils.isPreFlightRequest((HttpServletRequest)request.servletRequest())) {
                return true;
            }
            return this.headersPredicate.test(request.headers());
        }

        public String toString() {
            return this.headersPredicate.toString();
        }
    }

    private static class SingleContentTypePredicate
    extends HeadersPredicate {
        private final MediaType mediaType;

        public SingleContentTypePredicate(MediaType mediaType) {
            super((ServerRequest.Headers headers) -> {
                MediaType contentType = headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
                boolean match = mediaType.includes(contentType);
                RequestPredicates.traceMatch("Content-Type", mediaType, contentType, match);
                return match;
            });
            this.mediaType = mediaType;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.header("Content-Type", this.mediaType.toString());
        }

        @Override
        public String toString() {
            return "Content-Type: " + this.mediaType;
        }
    }

    private static class MultipleContentTypesPredicate
    extends HeadersPredicate {
        private final MediaType[] mediaTypes;

        public MultipleContentTypesPredicate(MediaType[] mediaTypes) {
            super(headers -> {
                MediaType contentType = headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
                boolean match = false;
                for (MediaType mediaType : mediaTypes) {
                    if (!mediaType.includes(contentType)) continue;
                    match = true;
                    break;
                }
                RequestPredicates.traceMatch("Content-Type", mediaTypes, contentType, match);
                return match;
            });
            this.mediaTypes = mediaTypes;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.header("Content-Type", Arrays.toString(this.mediaTypes));
        }

        @Override
        public String toString() {
            return "Content-Type: " + Arrays.toString(this.mediaTypes);
        }
    }

    private static class SingleAcceptPredicate
    extends HeadersPredicate {
        private final MediaType mediaType;

        public SingleAcceptPredicate(MediaType mediaType) {
            super((ServerRequest.Headers headers) -> {
                List<MediaType> acceptedMediaTypes = SingleAcceptPredicate.acceptedMediaTypes(headers);
                boolean match = false;
                for (MediaType acceptedMediaType : acceptedMediaTypes) {
                    if (!acceptedMediaType.isCompatibleWith(mediaType)) continue;
                    match = true;
                    break;
                }
                RequestPredicates.traceMatch("Accept", mediaType, acceptedMediaTypes, match);
                return match;
            });
            this.mediaType = mediaType;
        }

        static List<MediaType> acceptedMediaTypes(ServerRequest.Headers headers) {
            List<MediaType> acceptedMediaTypes = headers.accept();
            if (acceptedMediaTypes.isEmpty()) {
                acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
            } else {
                MimeTypeUtils.sortBySpecificity(acceptedMediaTypes);
            }
            return acceptedMediaTypes;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.header("Accept", this.mediaType.toString());
        }

        @Override
        public String toString() {
            return "Accept: " + this.mediaType;
        }
    }

    private static class MultipleAcceptsPredicate
    extends HeadersPredicate {
        private final MediaType[] mediaTypes;

        public MultipleAcceptsPredicate(MediaType[] mediaTypes) {
            super(headers -> {
                List<MediaType> acceptedMediaTypes = SingleAcceptPredicate.acceptedMediaTypes(headers);
                boolean match = false;
                block0: for (MediaType acceptedMediaType : acceptedMediaTypes) {
                    for (MediaType mediaType : mediaTypes) {
                        if (!acceptedMediaType.isCompatibleWith(mediaType)) continue;
                        match = true;
                        break block0;
                    }
                }
                RequestPredicates.traceMatch("Accept", mediaTypes, acceptedMediaTypes, match);
                return match;
            });
            this.mediaTypes = mediaTypes;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.header("Accept", Arrays.toString(this.mediaTypes));
        }

        @Override
        public String toString() {
            return "Accept: " + Arrays.toString(this.mediaTypes);
        }
    }

    private static class PathExtensionPredicate
    implements RequestPredicate {
        private final Predicate<String> extensionPredicate;
        @Nullable
        private final String extension;

        public PathExtensionPredicate(Predicate<String> extensionPredicate) {
            Assert.notNull(extensionPredicate, (String)"Predicate must not be null");
            this.extensionPredicate = extensionPredicate;
            this.extension = null;
        }

        public PathExtensionPredicate(String extension) {
            Assert.notNull((Object)extension, (String)"Extension must not be null");
            this.extensionPredicate = s -> {
                boolean match = extension.equalsIgnoreCase((String)s);
                RequestPredicates.traceMatch("Extension", extension, s, match);
                return match;
            };
            this.extension = extension;
        }

        @Override
        public boolean test(ServerRequest request) {
            String pathExtension = UriUtils.extractFileExtension((String)request.path());
            return pathExtension != null && this.extensionPredicate.test(pathExtension);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.pathExtension(this.extension != null ? this.extension : this.extensionPredicate.toString());
        }

        public String toString() {
            return String.format("*.%s", this.extension != null ? this.extension : this.extensionPredicate);
        }
    }

    private static class ParamPredicate
    implements RequestPredicate {
        private final String name;
        private final Predicate<String> valuePredicate;
        @Nullable
        private final String value;

        public ParamPredicate(String name, Predicate<String> valuePredicate) {
            Assert.notNull((Object)name, (String)"Name must not be null");
            Assert.notNull(valuePredicate, (String)"Predicate must not be null");
            this.name = name;
            this.valuePredicate = valuePredicate;
            this.value = null;
        }

        public ParamPredicate(String name, String value) {
            Assert.notNull((Object)name, (String)"Name must not be null");
            Assert.notNull((Object)value, (String)"Value must not be null");
            this.name = name;
            this.valuePredicate = value::equals;
            this.value = value;
        }

        @Override
        public boolean test(ServerRequest request) {
            Optional<String> s = request.param(this.name);
            return s.filter(this.valuePredicate).isPresent();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.param(this.name, this.value != null ? this.value : this.valuePredicate.toString());
        }

        public String toString() {
            return String.format("?%s %s", this.name, this.value != null ? this.value : this.valuePredicate);
        }
    }

    private static class PathPatternPredicate
    extends RequestModifyingPredicate
    implements ChangePathPatternParserVisitor.Target {
        private PathPattern pattern;

        public PathPatternPredicate(PathPattern pattern) {
            Assert.notNull((Object)pattern, (String)"'pattern' must not be null");
            this.pattern = pattern;
        }

        @Override
        protected RequestModifyingPredicate.Result testInternal(ServerRequest request) {
            PathContainer pathContainer = request.requestPath().pathWithinApplication();
            PathPattern.PathMatchInfo info = this.pattern.matchAndExtract(pathContainer);
            RequestPredicates.traceMatch("Pattern", this.pattern.getPatternString(), request.path(), info != null);
            if (info != null) {
                return RequestModifyingPredicate.Result.of(true, attributes -> this.modifyAttributes((Map<String, Object>)attributes, request, info.getUriVariables()));
            }
            return RequestModifyingPredicate.Result.of(false);
        }

        private void modifyAttributes(Map<String, Object> attributes, ServerRequest request, Map<String, String> variables) {
            Map pathVariables = CollectionUtils.compositeMap(request.pathVariables(), variables);
            attributes.put(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.unmodifiableMap(pathVariables));
            PathPattern pattern = RequestPredicates.mergePatterns((PathPattern)attributes.get(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE), this.pattern);
            attributes.put(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE, pattern);
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            return Optional.ofNullable(this.pattern.matchStartOfPath(request.requestPath().pathWithinApplication())).map(info -> new NestedPathPatternServerRequestWrapper(request, (PathPattern.PathRemainingMatchInfo)info, this.pattern));
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.path(this.pattern.getPatternString());
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            String patternString = this.pattern.getPatternString();
            this.pattern = parser.parse(patternString);
        }

        public String toString() {
            return this.pattern.getPatternString();
        }
    }

    private static class NestedPathPatternServerRequestWrapper
    extends ExtendedAttributesServerRequestWrapper {
        private final RequestPath requestPath;

        public NestedPathPatternServerRequestWrapper(ServerRequest request, PathPattern.PathRemainingMatchInfo info, PathPattern pattern) {
            super(request, NestedPathPatternServerRequestWrapper.mergeAttributes(request, info.getUriVariables(), pattern));
            this.requestPath = NestedPathPatternServerRequestWrapper.requestPath(request.requestPath(), info);
        }

        private static Map<String, Object> mergeAttributes(ServerRequest request, Map<String, String> newPathVariables, PathPattern newPathPattern) {
            Map<String, String> oldPathVariables = request.pathVariables();
            Map pathVariables = oldPathVariables.isEmpty() ? newPathVariables : CollectionUtils.compositeMap(oldPathVariables, newPathVariables);
            PathPattern oldPathPattern = request.attribute(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE).orElse(null);
            PathPattern pathPattern = RequestPredicates.mergePatterns(oldPathPattern, newPathPattern);
            LinkedHashMap result = CollectionUtils.newLinkedHashMap((int)2);
            result.put(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, pathVariables);
            result.put(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE, pathPattern);
            return result;
        }

        private static RequestPath requestPath(RequestPath original, PathPattern.PathRemainingMatchInfo info) {
            StringBuilder contextPath = new StringBuilder(original.contextPath().value());
            contextPath.append(info.getPathMatched().value());
            int length = contextPath.length();
            if (length > 0 && contextPath.charAt(length - 1) == '/') {
                contextPath.setLength(length - 1);
            }
            return original.modifyContextPath(contextPath.toString());
        }

        @Override
        public RequestPath requestPath() {
            return this.requestPath;
        }

        @Override
        public String path() {
            return this.requestPath.pathWithinApplication().value();
        }

        @Override
        @Deprecated
        public PathContainer pathContainer() {
            return this.requestPath;
        }
    }

    private static class ExtendedAttributesServerRequestWrapper
    extends DelegatingServerRequest {
        private final Map<String, Object> attributes;

        public ExtendedAttributesServerRequestWrapper(ServerRequest delegate, Map<String, Object> newAttributes) {
            super(delegate);
            Assert.notNull(newAttributes, (String)"NewAttributes must not be null");
            Map<String, Object> oldAttributes = delegate.attributes();
            this.attributes = CollectionUtils.compositeMap(newAttributes, oldAttributes, newAttributes::put, newAttributes::putAll);
        }

        @Override
        public Optional<Object> attribute(String name) {
            return Optional.ofNullable(this.attributes.get(name));
        }

        @Override
        public Map<String, Object> attributes() {
            return this.attributes;
        }

        @Override
        public String pathVariable(String name) {
            Map<String, String> pathVariables = this.pathVariables();
            if (pathVariables.containsKey(name)) {
                return pathVariables.get(name);
            }
            throw new IllegalArgumentException("No path variable with name \"" + name + "\" available");
        }

        @Override
        public Map<String, String> pathVariables() {
            return this.attributes.getOrDefault(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.emptyMap());
        }
    }

    private static abstract class DelegatingServerRequest
    implements ServerRequest {
        private final ServerRequest delegate;

        protected DelegatingServerRequest(ServerRequest delegate) {
            Assert.notNull((Object)delegate, (String)"Delegate must not be null");
            this.delegate = delegate;
        }

        @Override
        public HttpMethod method() {
            return this.delegate.method();
        }

        @Override
        @Deprecated
        public String methodName() {
            return this.delegate.methodName();
        }

        @Override
        public URI uri() {
            return this.delegate.uri();
        }

        @Override
        public UriBuilder uriBuilder() {
            return this.delegate.uriBuilder();
        }

        @Override
        public String path() {
            return this.delegate.path();
        }

        @Override
        @Deprecated
        public PathContainer pathContainer() {
            return this.delegate.pathContainer();
        }

        @Override
        public RequestPath requestPath() {
            return this.delegate.requestPath();
        }

        @Override
        public ServerRequest.Headers headers() {
            return this.delegate.headers();
        }

        @Override
        public MultiValueMap<String, Cookie> cookies() {
            return this.delegate.cookies();
        }

        @Override
        public Optional<InetSocketAddress> remoteAddress() {
            return this.delegate.remoteAddress();
        }

        @Override
        public List<HttpMessageConverter<?>> messageConverters() {
            return this.delegate.messageConverters();
        }

        @Override
        public <T> T body(Class<T> bodyType) throws ServletException, IOException {
            return this.delegate.body(bodyType);
        }

        @Override
        public <T> T body(ParameterizedTypeReference<T> bodyType) throws ServletException, IOException {
            return this.delegate.body(bodyType);
        }

        @Override
        public <T> T bind(Class<T> bindType) throws BindException {
            return this.delegate.bind(bindType);
        }

        @Override
        public <T> T bind(Class<T> bindType, Consumer<WebDataBinder> dataBinderCustomizer) throws BindException {
            return this.delegate.bind(bindType, dataBinderCustomizer);
        }

        @Override
        public Optional<Object> attribute(String name) {
            return this.delegate.attribute(name);
        }

        @Override
        public Map<String, Object> attributes() {
            return this.delegate.attributes();
        }

        @Override
        public Optional<String> param(String name) {
            return this.delegate.param(name);
        }

        @Override
        public MultiValueMap<String, String> params() {
            return this.delegate.params();
        }

        @Override
        public MultiValueMap<String, Part> multipartData() throws IOException, ServletException {
            return this.delegate.multipartData();
        }

        @Override
        public String pathVariable(String name) {
            return this.delegate.pathVariable(name);
        }

        @Override
        public Map<String, String> pathVariables() {
            return this.delegate.pathVariables();
        }

        @Override
        public HttpSession session() {
            return this.delegate.session();
        }

        @Override
        public Optional<Principal> principal() {
            return this.delegate.principal();
        }

        @Override
        public HttpServletRequest servletRequest() {
            return this.delegate.servletRequest();
        }

        @Override
        public Optional<ServerResponse> checkNotModified(Instant lastModified) {
            return this.delegate.checkNotModified(lastModified);
        }

        @Override
        public Optional<ServerResponse> checkNotModified(String etag) {
            return this.delegate.checkNotModified(etag);
        }

        @Override
        public Optional<ServerResponse> checkNotModified(Instant lastModified, String etag) {
            return this.delegate.checkNotModified(lastModified, etag);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static class OrRequestPredicate
    extends RequestModifyingPredicate
    implements ChangePathPatternParserVisitor.Target {
        private final RequestPredicate left;
        private final RequestModifyingPredicate leftModifying;
        private final RequestPredicate right;
        private final RequestModifyingPredicate rightModifying;

        public OrRequestPredicate(RequestPredicate left, RequestPredicate right) {
            Assert.notNull((Object)left, (String)"Left RequestPredicate must not be null");
            Assert.notNull((Object)right, (String)"Right RequestPredicate must not be null");
            this.left = left;
            this.leftModifying = OrRequestPredicate.of(left);
            this.right = right;
            this.rightModifying = OrRequestPredicate.of(right);
        }

        @Override
        protected RequestModifyingPredicate.Result testInternal(ServerRequest request) {
            RequestModifyingPredicate.Result leftResult = this.leftModifying.testInternal(request);
            if (leftResult.value()) {
                return leftResult;
            }
            return this.rightModifying.testInternal(request);
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            Optional<ServerRequest> leftResult = this.left.nest(request);
            if (leftResult.isPresent()) {
                return leftResult;
            }
            return this.right.nest(request);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startOr();
            this.left.accept(visitor);
            visitor.or();
            this.right.accept(visitor);
            visitor.endOr();
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            ChangePathPatternParserVisitor.Target target;
            RequestPredicate requestPredicate = this.left;
            if (requestPredicate instanceof ChangePathPatternParserVisitor.Target) {
                target = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target.changeParser(parser);
            }
            if ((requestPredicate = this.right) instanceof ChangePathPatternParserVisitor.Target) {
                target = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target.changeParser(parser);
            }
        }

        public String toString() {
            return String.format("(%s || %s)", this.left, this.right);
        }
    }

    static class NegateRequestPredicate
    extends RequestModifyingPredicate
    implements ChangePathPatternParserVisitor.Target {
        private final RequestPredicate delegate;
        private final RequestModifyingPredicate delegateModifying;

        public NegateRequestPredicate(RequestPredicate delegate) {
            Assert.notNull((Object)delegate, (String)"Delegate must not be null");
            this.delegate = delegate;
            this.delegateModifying = NegateRequestPredicate.of(delegate);
        }

        @Override
        protected RequestModifyingPredicate.Result testInternal(ServerRequest request) {
            RequestModifyingPredicate.Result result = this.delegateModifying.testInternal(request);
            return RequestModifyingPredicate.Result.of(!result.value(), result::modifyAttributes);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startNegate();
            this.delegate.accept(visitor);
            visitor.endNegate();
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            RequestPredicate requestPredicate = this.delegate;
            if (requestPredicate instanceof ChangePathPatternParserVisitor.Target) {
                ChangePathPatternParserVisitor.Target target = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target.changeParser(parser);
            }
        }

        public String toString() {
            return "!" + this.delegate.toString();
        }
    }

    static class AndRequestPredicate
    extends RequestModifyingPredicate
    implements ChangePathPatternParserVisitor.Target {
        private final RequestPredicate left;
        private final RequestModifyingPredicate leftModifying;
        private final RequestPredicate right;
        private final RequestModifyingPredicate rightModifying;

        public AndRequestPredicate(RequestPredicate left, RequestPredicate right) {
            Assert.notNull((Object)left, (String)"Left RequestPredicate must not be null");
            Assert.notNull((Object)right, (String)"Right RequestPredicate must not be null");
            this.left = left;
            this.leftModifying = AndRequestPredicate.of(left);
            this.right = right;
            this.rightModifying = AndRequestPredicate.of(right);
        }

        @Override
        protected RequestModifyingPredicate.Result testInternal(ServerRequest request) {
            ServerRequest rightRequest;
            RequestModifyingPredicate.Result leftResult = this.leftModifying.testInternal(request);
            if (!leftResult.value()) {
                return leftResult;
            }
            if (leftResult.modifiesAttributes()) {
                LinkedHashMap<String, Object> leftAttributes = new LinkedHashMap<String, Object>(2);
                leftResult.modifyAttributes(leftAttributes);
                rightRequest = new ExtendedAttributesServerRequestWrapper(request, leftAttributes);
            } else {
                rightRequest = request;
            }
            RequestModifyingPredicate.Result rightResult = this.rightModifying.testInternal(rightRequest);
            if (!rightResult.value()) {
                return rightResult;
            }
            return RequestModifyingPredicate.Result.of(true, attributes -> {
                leftResult.modifyAttributes((Map<String, Object>)attributes);
                rightResult.modifyAttributes((Map<String, Object>)attributes);
            });
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            return this.left.nest(request).flatMap(this.right::nest);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startAnd();
            this.left.accept(visitor);
            visitor.and();
            this.right.accept(visitor);
            visitor.endAnd();
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            ChangePathPatternParserVisitor.Target target;
            RequestPredicate requestPredicate = this.left;
            if (requestPredicate instanceof ChangePathPatternParserVisitor.Target) {
                target = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target.changeParser(parser);
            }
            if ((requestPredicate = this.right) instanceof ChangePathPatternParserVisitor.Target) {
                target = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target.changeParser(parser);
            }
        }

        public String toString() {
            return String.format("(%s && %s)", this.left, this.right);
        }
    }

    private static abstract class RequestModifyingPredicate
    implements RequestPredicate {
        private RequestModifyingPredicate() {
        }

        public static RequestModifyingPredicate of(final RequestPredicate requestPredicate) {
            if (requestPredicate instanceof RequestModifyingPredicate) {
                RequestModifyingPredicate modifyingPredicate = (RequestModifyingPredicate)requestPredicate;
                return modifyingPredicate;
            }
            return new RequestModifyingPredicate(){

                @Override
                protected Result testInternal(ServerRequest request) {
                    return Result.of(requestPredicate.test(request));
                }
            };
        }

        @Override
        public final boolean test(ServerRequest request) {
            Result result = this.testInternal(request);
            boolean value = result.value();
            if (value) {
                result.modifyAttributes(request.attributes());
            }
            return value;
        }

        protected abstract Result testInternal(ServerRequest var1);

        protected static final class Result {
            private static final Result TRUE = new Result(true, null);
            private static final Result FALSE = new Result(false, null);
            private final boolean value;
            @Nullable
            private final Consumer<Map<String, Object>> modifyAttributes;

            private Result(boolean value, @Nullable Consumer<Map<String, Object>> modifyAttributes) {
                this.value = value;
                this.modifyAttributes = modifyAttributes;
            }

            public static Result of(boolean value) {
                return Result.of(value, null);
            }

            public static Result of(boolean value, @Nullable Consumer<Map<String, Object>> modifyAttributes) {
                if (modifyAttributes == null) {
                    return value ? TRUE : FALSE;
                }
                return new Result(value, modifyAttributes);
            }

            public boolean value() {
                return this.value;
            }

            public void modifyAttributes(Map<String, Object> attributes) {
                if (this.modifyAttributes != null) {
                    this.modifyAttributes.accept(attributes);
                }
            }

            public boolean modifiesAttributes() {
                return this.modifyAttributes != null;
            }
        }
    }

    public static interface Visitor {
        public void method(Set<HttpMethod> var1);

        public void path(String var1);

        public void pathExtension(String var1);

        public void header(String var1, String var2);

        public void param(String var1, String var2);

        public void startAnd();

        public void and();

        public void endAnd();

        public void startOr();

        public void or();

        public void endOr();

        public void startNegate();

        public void endNegate();

        public void unknown(RequestPredicate var1);
    }
}

