/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.CommonObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.EncryptionProvider;
import net.snowflake.client.jdbc.cloud.storage.QueryIdHelper;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageHelper;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.OperationContext;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentials;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsAnonymous;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageException;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.StorageExtendedErrorInformation;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobInputStream;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobListingDetails;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobProperties;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.BlobRequestOptions;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobClient;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlobContainer;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.CloudBlockBlob;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.blob.ListBlobItem;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SFPair;
import net.snowflake.client.util.Stopwatch;

public class SnowflakeAzureClient
implements SnowflakeStorageClient {
    private static final String localFileSep = SnowflakeUtil.systemGetProperty("file.separator");
    private static final String AZ_ENCRYPTIONDATAPROP = "encryptiondata";
    private static final String AZ_STREAMING_INGEST_CLIENT_NAME = "ingestclientname";
    private static final String AZ_STREAMING_INGEST_CLIENT_KEY = "ingestclientkey";
    private int encryptionKeySize = 0;
    private StageInfo stageInfo;
    private RemoteStoreFileEncryptionMaterial encMat;
    private CloudBlobClient azStorageClient;
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeAzureClient.class);
    private OperationContext opContext = null;
    private SFBaseSession session;

    private SnowflakeAzureClient() {
    }

    public static SnowflakeAzureClient createSnowflakeAzureClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat, SFBaseSession sfSession) throws SnowflakeSQLException {
        logger.debug("Initializing Snowflake Azure client with encryption: {}", encMat != null ? "true" : "false");
        SnowflakeAzureClient azureClient = new SnowflakeAzureClient();
        azureClient.setupAzureClient(stage, encMat, sfSession);
        return azureClient;
    }

    private void setupAzureClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat, SFBaseSession sfSession) throws IllegalArgumentException, SnowflakeSQLException {
        this.stageInfo = stage;
        this.encMat = encMat;
        this.session = sfSession;
        logger.debug("Setting up the Azure client ", false);
        try {
            URI storageEndpoint = SnowflakeAzureClient.buildAzureStorageEndpointURI(stage.getEndPoint(), stage.getStorageAccount());
            String sasToken = (String)stage.getCredentials().get("AZURE_SAS_TOKEN");
            StorageCredentials azCreds = sasToken != null ? new StorageCredentialsSharedAccessSignature(sasToken) : StorageCredentialsAnonymous.ANONYMOUS;
            if (stage.getIsClientSideEncrypted() && encMat != null) {
                byte[] decodedKey = Base64.getDecoder().decode(encMat.getQueryStageMasterKey());
                this.encryptionKeySize = decodedKey.length * 8;
                if (this.encryptionKeySize != 128 && this.encryptionKeySize != 192 && this.encryptionKeySize != 256) {
                    throw new SnowflakeSQLLoggedException(QueryIdHelper.queryIdFromEncMatOr(encMat, null), this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "unsupported key size", this.encryptionKeySize);
                }
            }
            this.azStorageClient = new CloudBlobClient(storageEndpoint, azCreds);
            this.opContext = new OperationContext();
            if (this.session != null) {
                HttpUtil.setProxyForAzure(this.session.getHttpClientKey(), this.opContext);
            } else {
                HttpUtil.setSessionlessProxyForAzure(stage.getProxyProperties(), this.opContext);
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("invalid_azure_credentials");
        }
    }

    @Override
    public int getMaxRetries() {
        if (this.session != null && this.session.getConnectionPropertiesMap().containsKey((Object)SFSessionProperty.PUT_GET_MAX_RETRIES)) {
            return (Integer)this.session.getConnectionPropertiesMap().get((Object)SFSessionProperty.PUT_GET_MAX_RETRIES);
        }
        return 25;
    }

    @Override
    public int getRetryBackoffMaxExponent() {
        return 4;
    }

    @Override
    public int getRetryBackoffMin() {
        return 1000;
    }

    @Override
    public boolean isEncrypting() {
        return this.encryptionKeySize > 0 && this.stageInfo.getIsClientSideEncrypted();
    }

    @Override
    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    @Override
    public void renew(Map<?, ?> stageCredentials) throws SnowflakeSQLException {
        logger.debug("Renewing the Azure client", new Object[0]);
        this.stageInfo.setCredentials(stageCredentials);
        this.setupAzureClient(this.stageInfo, this.encMat, this.session);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public StorageObjectSummaryCollection listObjects(String remoteStorageLocation, String prefix) throws StorageProviderException {
        StorageObjectSummaryCollection storageObjectSummaries;
        try {
            CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
            Iterable<ListBlobItem> listBlobItemIterable = container.listBlobs(prefix, true, EnumSet.noneOf(BlobListingDetails.class), null, this.opContext);
            storageObjectSummaries = new StorageObjectSummaryCollection(listBlobItemIterable);
        }
        catch (URISyntaxException | StorageException ex) {
            logger.debug("Failed to list objects: {}", ex);
            throw new StorageProviderException(ex);
        }
        return storageObjectSummaries;
    }

    @Override
    public StorageObjectMetadata getObjectMetadata(String remoteStorageLocation, String prefix) throws StorageProviderException {
        CommonObjectMetadata azureObjectMetadata = null;
        try {
            CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
            CloudBlockBlob blob = container.getBlockBlobReference(prefix);
            blob.downloadAttributes(null, null, this.opContext);
            Map<String, String> userDefinedMetadata = SnowflakeUtil.createCaseInsensitiveMap(blob.getMetadata());
            BlobProperties properties = blob.getProperties();
            long contentLength = properties.getLength();
            String contentEncoding = properties.getContentEncoding();
            azureObjectMetadata = new CommonObjectMetadata(contentLength, contentEncoding, userDefinedMetadata);
        }
        catch (StorageException ex) {
            logger.debug("Failed to retrieve BLOB metadata: {} - {}", ex.getErrorCode(), SnowflakeAzureClient.FormatStorageExtendedErrorInformation(ex.getExtendedErrorInformation()));
            throw new StorageProviderException(ex);
        }
        catch (URISyntaxException ex) {
            logger.debug("Cannot retrieve BLOB properties, invalid URI: {}", ex);
            throw new StorageProviderException(ex);
        }
        return azureObjectMetadata;
    }

    @Override
    public void download(SFSession session, String command, String localLocation, String destFileName, int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion, String presignedUrl, String queryId) throws SnowflakeSQLException {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        String localFilePath = localLocation + localFileSep + destFileName;
        logger.debug("Staring download of file from Azure stage path: {} to {}", stageFilePath, localFilePath);
        int retryCount = 0;
        while (true) {
            try {
                File localFile = new File(localFilePath);
                CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
                CloudBlockBlob blob = container.getBlockBlobReference(stageFilePath);
                BlobRequestOptions transferOptions = new BlobRequestOptions();
                transferOptions.setConcurrentRequestCount(parallelism);
                blob.downloadToFile(localFilePath, null, transferOptions, this.opContext);
                stopwatch.stop();
                long downloadMillis = stopwatch.elapsedMillis();
                blob.downloadAttributes(null, transferOptions, this.opContext);
                Map<String, String> userDefinedMetadata = SnowflakeUtil.createCaseInsensitiveMap(blob.getMetadata());
                AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData(userDefinedMetadata.get(AZ_ENCRYPTIONDATAPROP), queryId);
                String key = encryptionData.getKey();
                String iv = encryptionData.getValue();
                if (this.isEncrypting() && this.getEncryptionKeySize() <= 256) {
                    stopwatch.restart();
                    if (key == null || iv == null) {
                        throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "File metadata incomplete");
                    }
                    try {
                        EncryptionProvider.decrypt(localFile, key, iv, this.encMat);
                        stopwatch.stop();
                        long decryptMillis = stopwatch.elapsedMillis();
                        logger.info("Azure file {} downloaded to {}. It took {} ms (download: {} ms, decryption: {} ms) with {} retries", remoteStorageLocation, localFile.getAbsolutePath(), downloadMillis + decryptMillis, downloadMillis, decryptMillis, retryCount);
                    }
                    catch (Exception ex) {
                        logger.error("Error decrypting file", ex);
                        throw ex;
                    }
                } else {
                    logger.info("Azure file {} downloaded to {}. It took {} ms with {} retries", remoteStorageLocation, localFile.getAbsolutePath(), downloadMillis, retryCount);
                }
                return;
            }
            catch (Exception ex) {
                logger.debug("Download unsuccessful {}", ex);
                SnowflakeAzureClient.handleAzureException(ex, ++retryCount, "download", session, command, this, queryId);
                if (retryCount <= this.getMaxRetries()) continue;
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected: download unsuccessful without exception!");
            }
            break;
        }
    }

    @Override
    public InputStream downloadToStream(SFSession session, String command, int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion, String presignedUrl, String queryId) throws SnowflakeSQLException {
        logger.debug("Staring download of file from Azure stage path: {} to input stream", stageFilePath);
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        int retryCount = 0;
        while (true) {
            try {
                CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
                CloudBlockBlob blob = container.getBlockBlobReference(stageFilePath);
                BlobInputStream stream = blob.openInputStream(null, null, this.opContext);
                stopwatch.stop();
                long downloadMillis = stopwatch.elapsedMillis();
                Map<String, String> userDefinedMetadata = SnowflakeUtil.createCaseInsensitiveMap(blob.getMetadata());
                AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData(userDefinedMetadata.get(AZ_ENCRYPTIONDATAPROP), queryId);
                String key = encryptionData.getKey();
                String iv = encryptionData.getValue();
                if (this.isEncrypting() && this.getEncryptionKeySize() <= 256) {
                    stopwatch.restart();
                    if (key == null || iv == null) {
                        throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "File metadata incomplete");
                    }
                    try {
                        InputStream is = EncryptionProvider.decryptStream(stream, key, iv, this.encMat);
                        stopwatch.stop();
                        long decryptMillis = stopwatch.elapsedMillis();
                        logger.info("Azure file {} downloaded to input stream. It took {} ms (download: {} ms, decryption: {} ms) with {} retries", stageFilePath, downloadMillis + decryptMillis, downloadMillis, decryptMillis, retryCount);
                        return is;
                    }
                    catch (Exception ex) {
                        logger.error("Error in decrypting file", ex);
                        throw ex;
                    }
                }
                logger.info("Azure file {} downloaded to input stream. Download took {} ms with {} retries", stageFilePath, downloadMillis, retryCount);
                return stream;
            }
            catch (Exception ex) {
                logger.debug("Downloading unsuccessful {}", ex);
                SnowflakeAzureClient.handleAzureException(ex, ++retryCount, "download", session, command, this, queryId);
                if (retryCount < this.getMaxRetries()) continue;
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected: download unsuccessful without exception!");
            }
            break;
        }
    }

    @Override
    public void upload(SFSession session, String command, int parallelism, boolean uploadFromStream, String remoteStorageLocation, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, StorageObjectMetadata meta, String stageRegion, String presignedUrl, String queryId) throws SnowflakeSQLException {
        logger.info(StorageHelper.getStartUploadLog("Azure", uploadFromStream, inputStream, fileBackedOutputStream, srcFile, destFileName), new Object[0]);
        ArrayList<FileInputStream> toClose = new ArrayList<FileInputStream>();
        long originalContentLength = meta.getContentLength();
        SFPair<InputStream, Boolean> uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, meta, originalContentLength, fileBackedOutputStream, toClose, queryId);
        if (!(meta instanceof CommonObjectMetadata)) {
            throw new IllegalArgumentException("Unexpected metadata object type");
        }
        int retryCount = 0;
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        while (true) {
            try {
                InputStream fileInputStream = (InputStream)uploadStreamInfo.left;
                CloudBlobContainer container = this.azStorageClient.getContainerReference(remoteStorageLocation);
                CloudBlockBlob blob = container.getBlockBlobReference(destFileName);
                blob.setMetadata(new HashMap<String, String>(meta.getUserMetadata()));
                BlobRequestOptions transferOptions = new BlobRequestOptions();
                transferOptions.setConcurrentRequestCount(parallelism);
                blob.upload(fileInputStream, -1L, null, transferOptions, this.opContext);
                stopwatch.stop();
                if (uploadFromStream) {
                    logger.info("Uploaded data from input stream to Azure location: {}. It took {} ms with {} retries", remoteStorageLocation, stopwatch.elapsedMillis(), retryCount);
                } else {
                    logger.info("Uploaded file {} to Azure location: {}. It took {} ms with {} retries", srcFile.getAbsolutePath(), remoteStorageLocation, stopwatch.elapsedMillis(), retryCount);
                }
                blob.uploadMetadata(null, transferOptions, this.opContext);
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                return;
            }
            catch (Exception ex) {
                SnowflakeAzureClient.handleAzureException(ex, ++retryCount, "upload", session, command, this, queryId);
                if (uploadFromStream && fileBackedOutputStream == null) {
                    throw new SnowflakeSQLException(queryId, ex, "58000", ErrorCode.IO_ERROR.getMessageCode(), "Encountered exception during upload: " + ex.getMessage() + "\nCannot retry upload from stream.");
                }
                uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, meta, originalContentLength, fileBackedOutputStream, toClose, queryId);
                if (retryCount <= this.getMaxRetries()) continue;
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                throw new SnowflakeSQLException(queryId, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Unexpected: upload unsuccessful without exception!");
            }
            break;
        }
    }

    @Override
    public void handleStorageException(Exception ex, int retryCount, String operation, SFSession session, String command, String queryId) throws SnowflakeSQLException {
        SnowflakeAzureClient.handleAzureException(ex, retryCount, operation, session, command, this, queryId);
    }

    private SFPair<InputStream, Boolean> createUploadStream(File srcFile, boolean uploadFromStream, InputStream inputStream, StorageObjectMetadata meta, long originalContentLength, FileBackedOutputStream fileBackedOutputStream, List<FileInputStream> toClose, String queryId) throws SnowflakeSQLException {
        InputStream stream;
        block10: {
            logger.debug("createUploadStream({}, {}, {}, {}, {}, {})", this, srcFile, uploadFromStream, inputStream, fileBackedOutputStream, toClose);
            FileInputStream srcFileStream = null;
            try {
                if (this.isEncrypting() && this.getEncryptionKeySize() <= 256) {
                    try {
                        InputStream inputStream2;
                        if (uploadFromStream) {
                            inputStream2 = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                        } else {
                            srcFileStream = new FileInputStream(srcFile);
                            inputStream2 = srcFileStream;
                        }
                        InputStream uploadStream = inputStream2;
                        toClose.add(srcFileStream);
                        stream = EncryptionProvider.encrypt(meta, originalContentLength, uploadStream, this.encMat, this);
                        uploadFromStream = true;
                        break block10;
                    }
                    catch (Exception ex) {
                        logger.error("Failed to encrypt input", ex);
                        throw new SnowflakeSQLLoggedException(queryId, this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Failed to encrypt input", ex.getMessage());
                    }
                }
                if (uploadFromStream) {
                    stream = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                } else {
                    srcFileStream = new FileInputStream(srcFile);
                    toClose.add(srcFileStream);
                    stream = srcFileStream;
                }
            }
            catch (FileNotFoundException ex) {
                logger.error("Failed to open input file", ex);
                throw new SnowflakeSQLLoggedException(queryId, this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Failed to open input file", ex.getMessage());
            }
            catch (IOException ex) {
                logger.error("Failed to open input stream", ex);
                throw new SnowflakeSQLLoggedException(queryId, this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Failed to open input stream", ex.getMessage());
            }
        }
        return SFPair.of(stream, uploadFromStream);
    }

    private static void handleAzureException(Exception ex, int retryCount, String operation, SFSession session, String command, SnowflakeAzureClient azClient, String queryId) throws SnowflakeSQLException {
        if (ex.getCause() instanceof InvalidKeyException) {
            SnowflakeFileTransferAgent.throwJCEMissingError(operation, ex, queryId);
        }
        if (SnowflakeUtil.getRootCause(ex) instanceof IOException) {
            SnowflakeFileTransferAgent.throwNoSpaceLeftError(session, operation, ex, queryId);
        }
        if (ex instanceof StorageException) {
            StorageException se = (StorageException)ex;
            if (((StorageException)ex).getHttpStatusCode() == 403) {
                if (session != null) {
                    SnowflakeFileTransferAgent.renewExpiredToken(session, command, azClient);
                } else {
                    throw new SnowflakeSQLException(queryId, se.getErrorCode(), 240001, "Azure credentials may have expired");
                }
            }
            if (retryCount > azClient.getMaxRetries() || ((StorageException)ex).getHttpStatusCode() == 404) {
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)ErrorCode.AZURE_SERVICE_ERROR.getMessageCode(), se, operation, se.getErrorCode(), se.getHttpStatusCode(), se.getMessage(), SnowflakeAzureClient.FormatStorageExtendedErrorInformation(se.getExtendedErrorInformation()));
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
            logger.debug("Stack trace: ", ex);
            int backoffInMillis = azClient.getRetryBackoffMin();
            if (retryCount > 1) {
                backoffInMillis <<= Math.min(retryCount - 1, azClient.getRetryBackoffMaxExponent());
            }
            try {
                logger.debug("Sleep for {} milliseconds before retry", backoffInMillis);
                Thread.sleep(backoffInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (se.getHttpStatusCode() == 403) {
                SnowflakeFileTransferAgent.renewExpiredToken(session, command, azClient);
            }
        } else if (ex instanceof InterruptedException || SnowflakeUtil.getRootCause(ex) instanceof SocketTimeoutException) {
            if (retryCount > azClient.getMaxRetries()) {
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), ex, "Encountered exception during " + operation + ": " + ex.getMessage());
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
        } else {
            throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), ex, "Encountered exception during " + operation + ": " + ex.getMessage());
        }
    }

    static String FormatStorageExtendedErrorInformation(StorageExtendedErrorInformation info) {
        if (info == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("StorageExceptionExtendedErrorInformation: {ErrorCode= ");
        sb.append(info.getErrorCode());
        sb.append(", ErrorMessage= ");
        sb.append(info.getErrorMessage());
        HashMap<String, String[]> details = info.getAdditionalDetails();
        if (details != null) {
            sb.append(", AdditionalDetails= { ");
            for (Map.Entry<String, String[]> detail : details.entrySet()) {
                sb.append(detail.getKey());
                sb.append("= ");
                for (String value : detail.getValue()) {
                    sb.append(value);
                }
                sb.append(",");
            }
            sb.setCharAt(sb.length() - 1, '}');
        }
        sb.append("}");
        return sb.toString();
    }

    private static URI buildAzureStorageEndpointURI(String storageEndPoint, String storageAccount) throws URISyntaxException {
        URI storageEndpoint = new URI("https", storageAccount + "." + storageEndPoint + "/", null, null);
        return storageEndpoint;
    }

    private String buildEncryptionMetadataJSON(String iv64, String key64) {
        return String.format("{\"EncryptionMode\":\"FullBlob\",\"WrappedContentKey\":{\"KeyId\":\"symmKey1\",\"EncryptedKey\":\"%s\",\"Algorithm\":\"AES_CBC_256\"},\"EncryptionAgent\":{\"Protocol\":\"1.0\",\"EncryptionAlgorithm\":\"AES_CBC_256\"},\"ContentEncryptionIV\":\"%s\",\"KeyWrappingMetadata\":{\"EncryptionLibrary\":\"Java 5.3.0\"}}", key64, iv64);
    }

    private AbstractMap.SimpleEntry<String, String> parseEncryptionData(String jsonEncryptionData, String queryId) throws SnowflakeSQLException {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        JsonFactory factory = mapper.getFactory();
        try {
            JsonParser parser = factory.createParser(jsonEncryptionData);
            JsonNode encryptionDataNode = (JsonNode)mapper.readTree(parser);
            String iv = encryptionDataNode.get("ContentEncryptionIV").asText();
            String key = encryptionDataNode.get("WrappedContentKey").get("EncryptedKey").asText();
            return new AbstractMap.SimpleEntry<String, String>(key, iv);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLLoggedException(queryId, this.session, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), ex, "Error parsing encryption data as json: " + ex.getMessage());
        }
    }

    @Override
    public String getMatdescKey() {
        return "matdesc";
    }

    @Override
    public void addEncryptionMetadata(StorageObjectMetadata meta, MatDesc matDesc, byte[] ivData, byte[] encryptedKey, long contentLength) {
        meta.addUserMetadata(this.getMatdescKey(), matDesc.toString());
        meta.addUserMetadata(AZ_ENCRYPTIONDATAPROP, this.buildEncryptionMetadataJSON(Base64.getEncoder().encodeToString(ivData), Base64.getEncoder().encodeToString(encryptedKey)));
        meta.setContentLength(contentLength);
    }

    @Override
    public void addDigestMetadata(StorageObjectMetadata meta, String digest) {
        if (!SnowflakeUtil.isBlank(digest)) {
            meta.addUserMetadata("sfcdigest", digest);
        }
    }

    @Override
    public String getDigestMetadata(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get("sfcdigest");
    }

    @Override
    public void addStreamingIngestMetadata(StorageObjectMetadata meta, String clientName, String clientKey) {
        meta.addUserMetadata(AZ_STREAMING_INGEST_CLIENT_NAME, clientName);
        meta.addUserMetadata(AZ_STREAMING_INGEST_CLIENT_KEY, clientKey);
    }

    @Override
    public String getStreamingIngestClientName(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get(AZ_STREAMING_INGEST_CLIENT_NAME);
    }

    @Override
    public String getStreamingIngestClientKey(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get(AZ_STREAMING_INGEST_CLIENT_KEY);
    }
}

